/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.motohr;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import promauto.jroboplc.core.TagTable;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Environment;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.motohr.CounterType;
import promauto.jroboplc.plugin.motohr.DataService;
import promauto.jroboplc.plugin.motohr.Mach;
import promauto.jroboplc.plugin.motohr.MachGroup;
import promauto.jroboplc.plugin.motohr.MotohrModule;
import promauto.jroboplc.plugin.motohr.Stat;
import promauto.jroboplc.plugin.motohr.SysUtil;

public class Context {
    public Environment env;
    public Configuration cfg;
    public MotohrModule module;
    public DataService service;
    public Stat stat;
    public SysUtil sysUtil;
    public String moduleName;
    public TagTable tagtable;
    public final Map<String, CounterType> counterTypes;
    public final List<MachGroup> machGroups;
    public final List<Mach> machs;
    public final List<Tag> repoTags = new ArrayList<Tag>();
    public int period;
    public String databaseModuleName;
    public Tag tagConnected;
    public TagRW tagTime;

    public Context() {
        this.counterTypes = new HashMap<String, CounterType>();
        this.machGroups = new LinkedList<MachGroup>();
        this.machs = new LinkedList<Mach>();
    }

    public void setModule(MotohrModule module) {
        this.module = module;
        this.moduleName = module.getName();
        this.tagtable = module.getTagTable();
    }

    public void addRepoTags(Tag ... tags) {
        Collections.addAll(this.repoTags, tags);
    }

    public void setDataService(DataService service) {
        this.service = service;
    }

    public void setEnvironment(Environment environment) {
        this.env = environment;
        this.cfg = this.env.getConfiguration();
    }

    public void setStat(Stat stat) {
        this.stat = stat;
    }

    public void setSysUtil(SysUtil sysUtil) {
        this.sysUtil = sysUtil;
    }

    public LocalDateTime now() {
        if (this.service.getDb() == null) {
            return LocalDateTime.now();
        }
        return this.service.getDb().getServerDatetime();
    }

    public long convertTime(LocalDateTime dt) {
        return dt.toEpochSecond(ZoneOffset.UTC);
    }

    public void updateTime() {
        this.tagTime.setReadValLong(this.convertTime(this.now()));
    }
}

