/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.motohr;

import java.sql.SQLException;
import java.util.Map;
import javafx.util.Pair;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.motohr.Context;
import promauto.jroboplc.plugin.motohr.CounterType;
import promauto.jroboplc.plugin.motohr.Mach;

public class Counter {
    public static Map<Pair<Integer, Integer>, Pair<Integer, Integer>> cache;
    private int id;
    private final Context ctx;
    public final CounterType counterType;
    public final Mach mach;
    private final TagRW tagSec;
    private final boolean total;

    public Counter(Context ctx, CounterType counterType, Mach mach) {
        this.ctx = ctx;
        this.counterType = counterType;
        this.mach = mach;
        this.tagSec = ctx.tagtable.createRWInt(mach.name + '.' + counterType.name, 0);
        this.total = counterType.name.equals("total");
    }

    public void init() throws SQLException {
        Pair<Integer, Integer> found = cache.get(new Pair((Object)this.mach.getId(), (Object)this.counterType.getId()));
        if (found == null) {
            this.id = this.ctx.service.createCounter(this.mach.getId(), this.counterType.getId());
            this.tagSec.setReadValInt(0);
        } else {
            this.id = (Integer)found.getKey();
            this.tagSec.setReadValInt((Integer)found.getValue());
            this.ctx.service.syncCounter(this.id);
        }
    }

    public void addSeconds(int sec) throws SQLException {
        this.tagSec.setReadValInt(this.tagSec.getInt() + (this.counterType.timer ? -1 : 1) * sec);
        this.ctx.service.saveCounter(this.id, this.tagSec.getInt());
    }

    public void execute() throws SQLException {
        if (this.tagSec.hasWriteValue() && !this.total) {
            int value = this.tagSec.getWriteValInt();
            if (this.counterType.timer && value < 0 || !this.counterType.timer && value != 0) {
                return;
            }
            this.tagSec.setReadValInt(value += (this.counterType.timer ? 1 : -1) * this.mach.getRunningSec());
            this.ctx.service.saveCounter(this.id, this.tagSec.getInt());
        }
    }

    public int getValue() {
        return this.tagSec.getInt() + (this.counterType.timer ? -1 : 1) * this.mach.getRunningSec();
    }

    public boolean isTotal() {
        return this.total;
    }

    public int getId() {
        return this.id;
    }
}

