/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.motohr;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javafx.util.Pair;
import promauto.jroboplc.plugin.motohr.DataService;
import promauto.jroboplc.plugin.motohr.DataServiceBaseImpl;
import promauto.jroboplc.plugin.motohr.MachState;

public class DataServiceImpl
extends DataServiceBaseImpl
implements DataService {
    private static final String TABLE_COUNTER_TYPE = "MH_COUNTER_TYPE";
    private static final String TABLE_MACH = "MH_MACH";
    private static final String TABLE_COUNTER = "MH_COUNTER";
    private static final String TABLE_INTERVAL = "MH_INTERVAL";
    private static final String TABLE_MACH_STATE = "MH_MACH_STATE";
    private static final String TABLE_STAT = "MH_STAT";
    private static final int SYNCTYPE_COUNTER_TYPE = 0;
    private static final int SYNCTYPE_COUNTER = 1;
    private static final int SYNCTYPE_MACH = 2;

    @Override
    public void startSync() throws SQLException {
        this.startSyncTable(0, TABLE_COUNTER_TYPE);
        this.startSyncTable(1, TABLE_COUNTER);
        this.startSyncTable(2, TABLE_MACH);
    }

    @Override
    public void finishSync() throws SQLException {
        this.finishSyncTable(0, TABLE_COUNTER_TYPE);
        this.finishSyncTable(1, TABLE_COUNTER);
    }

    @Override
    public int syncCounterType(String name, String descr, boolean timer) throws SQLException {
        this.sql = String.format("update or insert into %s (name, descr, timer, deleted) values ('%s', '%s', %d, 0) matching (name)", TABLE_COUNTER_TYPE, name, descr, timer ? 1 : 0);
        int id = this.executeAndGetId(this.sql);
        this.removeSyncId(0, id);
        return id;
    }

    @Override
    public int syncMach(String tagname, String name, String descr) throws SQLException {
        this.sql = String.format("update or insert into %s (tagname, name, descr) values ('%s', '%s', '%s') matching (name)", TABLE_MACH, tagname, name, descr);
        int id = this.executeAndGetId(this.sql);
        this.removeSyncId(2, id);
        return id;
    }

    @Override
    public Map<Integer, MachState> getMachStates() throws SQLException {
        HashMap<Integer, MachState> states = new HashMap<Integer, MachState>();
        this.sql = String.format("select mach_id, dt, running, statcnt, statsec from %s", TABLE_MACH_STATE);
        try (ResultSet rs = this.st.executeQuery(this.sql);){
            while (rs.next()) {
                states.put(rs.getInt(1), new MachState(rs.getTimestamp(2).toLocalDateTime(), rs.getInt(3) == 1, rs.getInt(4), rs.getInt(5)));
            }
        }
        return states;
    }

    @Override
    public void saveMachState(int id, MachState state) throws SQLException {
        this.sql = String.format("update or insert into %s (mach_id, dt, running, statcnt, statsec) values (%d, '%s', %d, %d, %d) matching (mach_id)", TABLE_MACH_STATE, id, this.db.formatDatetime(state.dt), state.running ? 1 : 0, state.statcnt, state.statsec);
        this.st.executeUpdate(this.sql);
    }

    @Override
    public Map<Pair<Integer, Integer>, Pair<Integer, Integer>> getCounters() throws SQLException {
        HashMap<Pair<Integer, Integer>, Pair<Integer, Integer>> counters = new HashMap<Pair<Integer, Integer>, Pair<Integer, Integer>>();
        this.sql = String.format("select mach_id, counter_type_id, id, sec from %s where deleted=0", TABLE_COUNTER);
        try (ResultSet rs = this.st.executeQuery(this.sql);){
            while (rs.next()) {
                counters.put((Pair<Integer, Integer>)new Pair((Object)rs.getInt(1), (Object)rs.getInt(2)), (Pair<Integer, Integer>)new Pair((Object)rs.getInt(3), (Object)rs.getInt(4)));
            }
        }
        return counters;
    }

    @Override
    public int createCounter(int machId, int counterTypeId) throws SQLException {
        this.sql = String.format("update or insert into %s (mach_id, counter_type_id, sec, deleted) values (%d, %d, 0, 0) matching (mach_id, counter_type_id)", TABLE_COUNTER, machId, counterTypeId);
        return this.executeAndGetId(this.sql);
    }

    @Override
    public void saveInterval(int id, LocalDateTime dt1, LocalDateTime dt2, int sec) throws SQLException {
        this.sql = String.format("insert into %s (mach_id, dtbeg, dtend, sec) values (%d, '%s', '%s', %d)", TABLE_INTERVAL, id, this.db.formatDatetime(dt1), this.db.formatDatetime(dt2), sec);
        this.st.executeUpdate(this.sql);
    }

    @Override
    public void saveCounter(int id, int sec) throws SQLException {
        this.sql = String.format("update %s set sec=%d where id=%d", TABLE_COUNTER, sec, id);
        this.st.executeUpdate(this.sql);
    }

    @Override
    public void saveStat(int id, int period, int cnt, int sec) throws SQLException {
        this.sql = String.format("insert into %s (mach_id, period, cnt, sec) values (%d, %d, %d, %d)", TABLE_STAT, id, period, cnt, sec);
        this.st.executeUpdate(this.sql);
    }

    @Override
    public int sweepInterval(LocalDateTime dt) throws SQLException {
        this.sql = String.format("delete from %s where dtbeg < '%s'", TABLE_INTERVAL, this.db.formatDatetime(dt));
        return this.st.executeUpdate(this.sql);
    }

    @Override
    public int packMach() throws SQLException {
        int n = 0;
        HashSet ids = (HashSet)this.sync.get(2);
        for (Integer id : ids) {
            this.sql = String.format("delete from %s where id=%d", TABLE_MACH, id);
            n += this.st.executeUpdate(this.sql);
        }
        ids.clear();
        return n;
    }

    @Override
    public void syncCounter(int id) {
        this.removeSyncId(1, id);
    }
}

