/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.motohr;

import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.motohr.Context;
import promauto.jroboplc.plugin.motohr.Counter;
import promauto.jroboplc.plugin.motohr.MachState;

public class Mach {
    private int id;
    private final Context ctx;
    public final Tag tag;
    public final String tagname;
    public final String name;
    public final String descr;
    public MachState state;
    public List<Counter> counters;
    private Counter counterTotal;
    public final TagRW tagTime;

    public Mach(Context ctx, Tag tag, String tagname, String name, String descr) {
        this.ctx = ctx;
        this.tag = tag;
        this.tagname = tagname;
        this.name = name;
        this.descr = descr;
        this.state = null;
        this.tagTime = ctx.tagtable.createRWLong(name + ".time", 0L);
    }

    public static boolean executeAll(Context ctx) throws SQLException {
        boolean res = true;
        for (Mach mach : ctx.machs) {
            res &= mach.execute();
        }
        return res;
    }

    public int getId() {
        return this.id;
    }

    public Counter getCounterTotal() {
        return this.counterTotal;
    }

    public void init() throws SQLException {
        this.id = this.ctx.service.syncMach(this.tagname, this.name, this.descr);
        this.state = MachState.cache.get(this.id);
        if (this.state == null) {
            this.state = new MachState(this.ctx.now(), this.tag.getBool(), 0, 0);
            this.ctx.service.saveMachState(this.id, this.state);
        }
        this.updateTime();
        for (Counter counter : this.counters) {
            counter.init();
            if (!counter.isTotal()) continue;
            this.counterTotal = counter;
        }
    }

    public boolean execute() throws SQLException {
        if (this.tag.getStatus() == Tag.Status.Deleted) {
            return false;
        }
        if (this.tag.getBool() != this.state.running) {
            LocalDateTime dtnow = this.ctx.now();
            this.state.running = this.tag.getBool();
            if (this.state.running) {
                ++this.state.statcnt;
            } else {
                int sec = (int)ChronoUnit.SECONDS.between(this.state.dt, dtnow);
                this.ctx.service.saveInterval(this.id, this.state.dt, dtnow, sec);
                for (Counter counter : this.counters) {
                    counter.addSeconds(sec);
                }
            }
            this.state.dt = dtnow;
            this.ctx.service.saveMachState(this.id, this.state);
            this.updateTime();
        }
        for (Counter counter : this.counters) {
            counter.execute();
        }
        return true;
    }

    private void updateTime() {
        if (this.state.running) {
            this.tagTime.setReadValLong(this.ctx.convertTime(this.state.dt));
        } else {
            this.tagTime.setReadValLong(0L);
        }
    }

    public void saveStat(int period) throws SQLException {
        if (this.counterTotal == null) {
            return;
        }
        int totalsec = this.counterTotal.getValue();
        if (period > 0) {
            int statsec = totalsec - this.state.statsec;
            this.ctx.service.saveStat(this.id, period, this.state.statcnt, statsec);
        }
        this.state.statcnt = 0;
        this.state.statsec = totalsec;
        this.ctx.service.saveMachState(this.id, this.state);
    }

    public int getRunningSec() {
        if (this.state.running) {
            return (int)(this.ctx.tagTime.getLong() - this.tagTime.getLong());
        }
        return 0;
    }
}

