/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.motohr;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.exceptions.ConfigurationNotValidException;
import promauto.jroboplc.plugin.motohr.Context;
import promauto.jroboplc.plugin.motohr.Counter;
import promauto.jroboplc.plugin.motohr.CounterType;
import promauto.jroboplc.plugin.motohr.Mach;
import promauto.jroboplc.plugin.motohr.MachState;

public class MachGroup {
    private final Context ctx;
    public final List<CounterType> counterTypes;
    public final Pattern patternTag;
    public final Pattern patternDescr;
    public final Pattern patternInclude;
    public final Pattern patternExclude;
    public final String prefix;
    public final String replDescr;
    public static Map<String, Mach> cacheMach;

    public MachGroup(Context ctx, Object conf) throws ConfigurationNotValidException {
        this.ctx = ctx;
        this.counterTypes = new LinkedList<CounterType>();
        Configuration cm = ctx.env.getConfiguration();
        this.patternTag = Pattern.compile(cm.get(conf, "expr.tag", ".*\\.MCHB_(.*)_Plata"));
        this.patternDescr = Pattern.compile(cm.get(conf, "expr.descr", "(.*)(_Plata)"));
        this.replDescr = cm.get(conf, "repl.descr", "$1.descr");
        this.prefix = cm.get(conf, "prefix", "");
        String exprInclude = cm.get(conf, "include", "");
        String exprExclude = cm.get(conf, "exclude", "");
        this.patternInclude = !exprInclude.isEmpty() ? Pattern.compile(exprInclude) : null;
        this.patternExclude = !exprExclude.isEmpty() ? Pattern.compile(exprExclude) : null;
        for (String ctname : cm.getStringList(conf, "counters")) {
            CounterType ct = ctx.counterTypes.get(ctname);
            if (ct == null) {
                cm.throwConfigurationNotValidException("MachGroup has unknown counter type: " + ctname);
                continue;
            }
            if (this.counterTypes.contains(ct)) continue;
            this.counterTypes.add(ct);
        }
    }

    public static void initAll(Context ctx) throws SQLException {
        ctx.machs.clear();
        cacheMach = new HashMap<String, Mach>();
        MachState.cache = ctx.service.getMachStates();
        Counter.cache = ctx.service.getCounters();
        for (MachGroup mg : ctx.machGroups) {
            mg.init();
        }
        for (Mach mach : ctx.machs) {
            mach.init();
        }
        MachState.cache.clear();
        Counter.cache.clear();
        cacheMach.clear();
    }

    public void init() throws SQLException {
        Map<String, Tag> alltags = this.ctx.env.getModuleManager().getTagsAll();
        for (String tagname : alltags.keySet()) {
            Mach machFound;
            String descrTagname;
            Tag tagDescr;
            Matcher matcherTag = this.patternTag.matcher(tagname);
            if (!matcherTag.find() || this.patternInclude != null && !this.patternInclude.matcher(tagname).matches() || this.patternExclude != null && !this.patternExclude.matcher(tagname).matches()) continue;
            Tag tag = alltags.get(tagname);
            String name = this.prefix + matcherTag.group(1);
            String descr = "";
            Matcher matcherDescr = this.patternDescr.matcher(tagname);
            if (matcherDescr.find() && (tagDescr = alltags.get(descrTagname = matcherDescr.replaceFirst(this.replDescr))) != null) {
                descr = tagDescr.getString();
            }
            if ((machFound = cacheMach.get(name)) == null) {
                Mach mach = new Mach(this.ctx, tag, tagname, name, descr);
                mach.counters = this.counterTypes.stream().map(ct -> new Counter(this.ctx, (CounterType)ct, mach)).collect(Collectors.toList());
                this.ctx.machs.add(mach);
                cacheMach.put(mach.name, mach);
                continue;
            }
            this.counterTypes.stream().filter(ct -> machFound.counters.stream().noneMatch(cnt -> cnt.counterType == ct)).forEach(ct -> machFound.counters.add(new Counter(this.ctx, (CounterType)ct, machFound)));
        }
    }
}

