/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import promauto.jroboplc.core.State;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Input;
import promauto.jroboplc.plugin.roboplant.Output;

public class DeviceSEQD
extends Device {
    Input inpInput;
    List<SeqdInput> inpStartBan = new ArrayList<SeqdInput>();
    List<SeqdInput> inpStop = new ArrayList<SeqdInput>();
    List<SeqdInput> inpStopStart = new ArrayList<SeqdInput>();
    List<SeqdInput> inpStopRun = new ArrayList<SeqdInput>();
    List<SeqdInput> inpStopFlow = new ArrayList<SeqdInput>();
    List<SeqdInput> inpStopDly = new ArrayList<SeqdInput>();
    List<SeqdInput> inpSusp = new ArrayList<SeqdInput>();
    Tag tagBtnStart;
    Tag tagBtnStop;
    Tag tagBtnSusp;
    Tag tagBtnEmrg;
    Tag tagBtnCancel;
    Tag tagTimeBtnStart;
    Tag tagFlags;
    Tag tagExclStartBan;
    Tag tagExclStop;
    Tag tagExclStopStart;
    Tag tagExclStopRun;
    Tag tagExclStopFlow;
    Tag tagExclStopDly;
    Tag tagExclSusp;
    Tag tagOutputOn;
    Tag tagOutputRun;
    Tag tagSost;
    Tag tagCounter;
    Tag tagMesReady;
    Tag tagMesAutoStop;
    Tag tagStopFlow;
    Tag tagStopDlyCnt;
    List<Tag> tagStopDlyTime = new ArrayList<Tag>();
    List<Tag> tagMesStartBan = new ArrayList<Tag>();
    List<Tag> tagMesStop = new ArrayList<Tag>();
    List<Tag> tagMesStopStart = new ArrayList<Tag>();
    List<Tag> tagMesStopRun = new ArrayList<Tag>();
    List<Tag> tagMesStopFlow = new ArrayList<Tag>();
    List<Tag> tagMesStopDly = new ArrayList<Tag>();
    List<Tag> tagMesSusp = new ArrayList<Tag>();
    List<Tag> tagTimeStart = new ArrayList<Tag>();
    List<Tag> tagTimeStop = new ArrayList<Tag>();
    List<Tag> tagOut = new ArrayList<Tag>();
    int SEQD_INP_AMOUNT;
    int outAmount;
    int curOut;
    int cnt;
    int cntBtnStart;
    int stopDlyCancel;
    int sost;

    @Override
    public void prepareTags(Device.RefBool res) {
        this.createTagDescr();
        this.inpInput = this.getInput("Input", res);
        this.tagBtnStart = this.getOutputTag("BtnStart", res);
        this.tagBtnStop = this.getOutputTag("BtnStop", res);
        this.tagBtnSusp = this.getOutputTag("BtnSusp", res);
        this.tagBtnEmrg = this.getOutputTag("BtnEmrg", res);
        this.tagBtnCancel = this.getOutputTag("BtnCancel", res);
        this.tagTimeBtnStart = this.getOutputTag("TimeBtnStart", res);
        this.tagFlags = this.getOutputTag("Flags", res);
        this.tagExclStartBan = this.getOutputTag("ExclStartBan", res);
        this.tagExclStop = this.getOutputTag("ExclStop", res);
        this.tagExclStopStart = this.getOutputTag("ExclStopStart", res);
        this.tagExclStopRun = this.getOutputTag("ExclStopRun", res);
        this.tagExclStopFlow = this.getOutputTag("ExclStopFlow", res);
        this.tagExclStopDly = this.getOutputTag("ExclStopDly", res);
        this.tagExclSusp = this.getOutputTag("ExclSusp", res);
        this.tagOutputOn = this.getOutputTag("OutputOn", res);
        this.tagOutputRun = this.getOutputTag("OutputRun", res);
        this.tagSost = this.getOutputTag("Sost", res);
        this.tagCounter = this.getOutputTag("Counter", res);
        this.tagMesReady = this.getOutputTag("MesReady", res);
        this.tagMesAutoStop = this.getOutputTag("MesAutoStop", res);
        this.tagStopFlow = this.getOutputTag("StopFlow", res);
        this.tagStopDlyCnt = this.getOutputTag("StopDlyCnt", res);
        this.prepareInputArrays();
        this.prepareOutputArrays();
        this.curOut = -1;
        this.cnt = 0;
        this.cntBtnStart = 0;
        this.stopDlyCancel = 0;
        this.sost = 0;
    }

    private void prepareInputArrays() {
        this.inpStartBan.clear();
        this.inpStop.clear();
        this.inpStopStart.clear();
        this.inpStopRun.clear();
        this.inpStopFlow.clear();
        this.inpStopDly.clear();
        this.inpSusp.clear();
        Pattern p = Pattern.compile("\\d*");
        for (Input inp : this.inputs) {
            String s;
            switch (s = p.matcher(inp.name).replaceAll("")) {
                case "StartBan": {
                    this.inpStartBan.add(new SeqdInput(inp));
                    break;
                }
                case "Stop": {
                    this.inpStop.add(new SeqdInput(inp));
                    break;
                }
                case "StopStart": {
                    this.inpStopStart.add(new SeqdInput(inp));
                    break;
                }
                case "StopRun": {
                    this.inpStopRun.add(new SeqdInput(inp));
                    break;
                }
                case "StopFlow": {
                    this.inpStopFlow.add(new SeqdInput(inp));
                    break;
                }
                case "StopDly": {
                    this.inpStopDly.add(new SeqdInput(inp));
                    break;
                }
                case "Susp": {
                    this.inpSusp.add(new SeqdInput(inp));
                }
            }
        }
    }

    private void prepareOutputArrays() {
        this.tagStopDlyTime.clear();
        this.tagMesStartBan.clear();
        this.tagMesStop.clear();
        this.tagMesStopStart.clear();
        this.tagMesStopRun.clear();
        this.tagMesStopFlow.clear();
        this.tagMesStopDly.clear();
        this.tagMesSusp.clear();
        this.tagTimeStart.clear();
        this.tagTimeStop.clear();
        this.tagOut.clear();
        Pattern p = Pattern.compile("\\d*");
        for (Output out : this.outputs) {
            String s;
            switch (s = p.matcher(out.name).replaceAll("")) {
                case "StopTime": {
                    this.tagStopDlyTime.add(out.tag);
                    break;
                }
                case "MesStartBan": {
                    this.tagMesStartBan.add(out.tag);
                    break;
                }
                case "MesStop": {
                    this.tagMesStop.add(out.tag);
                    break;
                }
                case "MesStopStart": {
                    this.tagMesStopStart.add(out.tag);
                    break;
                }
                case "MesStopRun": {
                    this.tagMesStopRun.add(out.tag);
                    break;
                }
                case "MesStopFlow": {
                    this.tagMesStopFlow.add(out.tag);
                    break;
                }
                case "MesStopDly": {
                    this.tagMesStopDly.add(out.tag);
                    break;
                }
                case "MesSusp": {
                    this.tagMesSusp.add(out.tag);
                    break;
                }
                case "TimeStart": {
                    this.tagTimeStart.add(out.tag);
                    break;
                }
                case "TimeStop": {
                    this.tagTimeStop.add(out.tag);
                    break;
                }
                case "Out": {
                    this.tagOut.add(out.tag);
                }
            }
        }
        this.outAmount = Math.min(Math.min(this.tagOut.size(), this.tagTimeStart.size()), this.tagTimeStop.size());
        this.SEQD_INP_AMOUNT = this.inpStartBan.size();
    }

    @Override
    public boolean execute() {
        int i;
        int flags = this.tagFlags.getInt();
        int stopDlyCnt = this.tagStopDlyCnt.getInt();
        int input = this.inpInput.getInt();
        int startBan = this.evalSeqdInput(this.inpStartBan, this.tagExclStartBan.getInt(), this.sost > 0 && this.sost < 4);
        int stop = this.evalSeqdInput(this.inpStop, this.tagExclStop.getInt(), this.sost == 3 || this.sost == 4 || this.sost == 6);
        int stopStart = this.evalSeqdInput(this.inpStopStart, this.tagExclStopStart.getInt(), this.sost == 3 || this.sost == 6);
        int stopRun = this.evalSeqdInput(this.inpStopRun, this.tagExclStopRun.getInt(), this.sost == 4);
        int stopFlow = this.evalSeqdInput(this.inpStopFlow, this.tagExclStopFlow.getInt(), true);
        int stopDly = this.evalSeqdInput(this.inpStopDly, this.tagExclStopDly.getInt(), this.sost == 4);
        int susp = this.evalSeqdInput(this.inpSusp, this.tagExclSusp.getInt(), this.sost == 3 || this.sost == 6 && (flags & 1) == 1);
        int stopDlyEvent = 0;
        if (stopDly > 0) {
            if (stopDlyCnt > 0) {
                if (this.stopDlyCancel != stopDly) {
                    int mask = 1;
                    for (i = 0; i < this.SEQD_INP_AMOUNT; ++i) {
                        if ((stopDly & mask) > 0 && stopDlyCnt > this.tagStopDlyTime.get(i).getInt()) {
                            stopDlyCnt = this.tagStopDlyTime.get(i).getInt();
                        }
                        mask <<= 1;
                    }
                    if (stopDlyCnt > 0) {
                        --stopDlyCnt;
                    }
                }
                if (this.tagBtnCancel.getBool()) {
                    this.stopDlyCancel = stopDly;
                    stopDlyCnt = 65535;
                    this.tagBtnCancel.setInt(0);
                }
            } else {
                stopDlyEvent = 1;
            }
        } else {
            stopDlyCnt = 65535;
            this.stopDlyCancel = 0;
        }
        int btnStartEvent = 0;
        if (this.tagBtnStart.getBool()) {
            if (this.cntBtnStart >= this.tagTimeBtnStart.getInt()) {
                this.tagBtnStart.setInt(0);
                this.sost = 2;
                this.cntBtnStart = 0;
                btnStartEvent = 1;
            } else {
                ++this.cntBtnStart;
            }
        } else {
            this.cntBtnStart = 0;
        }
        if (this.tagBtnEmrg.getBool() || (flags & 2) > 0 && this.inpStop.get((int)(this.inpStop.size() - 1)).value > 0) {
            this.sost = 0;
            btnStartEvent = 0;
            this.cnt = 0;
            this.curOut = -1;
        } else if (this.sost == 0) {
            if (btnStartEvent > 0 || input > 0) {
                startBan = this.evalSeqdInput(this.inpStartBan, this.tagExclStartBan.getInt(), true);
                this.sost = startBan > 0 ? 1 : 3;
            }
            this.curOut = -1;
        }
        if (this.sost == 1) {
            if (this.tagBtnStop.getBool()) {
                this.sost = 0;
            } else if (startBan == 0) {
                this.sost = 2;
            }
        }
        if (this.sost == 2) {
            startBan = this.evalSeqdInput(this.inpStartBan, this.tagExclStartBan.getInt(), true);
            if (this.tagBtnStop.getBool()) {
                this.sost = 0;
            } else if (startBan > 0) {
                this.sost = 1;
            } else if (btnStartEvent > 0) {
                this.sost = 3;
            }
        }
        if (this.sost == 3) {
            if (stop > 0 || stopStart > 0) {
                this.tagMesAutoStop.setInt(1);
            }
            if (this.tagBtnStop.getBool() || stop > 0 || stopStart > 0) {
                this.sost = 5;
            } else if (this.tagBtnSusp.getBool() || susp > 0) {
                this.sost = 6;
            } else if (this.curOut >= this.outAmount) {
                this.sost = 4;
            } else {
                this.evalStartCounter();
            }
        }
        if (this.sost == 4) {
            if (stop > 0 || stopRun > 0 || stopDlyEvent > 0) {
                this.tagMesAutoStop.setInt(1);
            }
            if (this.tagBtnStop.getBool() || stop > 0 || stopRun > 0 || stopDlyEvent > 0) {
                this.sost = 5;
            }
        }
        if (this.sost == 5) {
            if (this.curOut == -1) {
                this.sost = 0;
                this.tagMesAutoStop.setInt(0);
            } else {
                this.evalStopCounter();
            }
        }
        if (this.sost == 6) {
            if (this.tagBtnStop.getBool() || stop > 0 || stopStart > 0) {
                this.sost = 5;
            } else if ((flags & 1) == 0 ? btnStartEvent > 0 : !this.tagBtnSusp.getBool() && susp == 0) {
                this.sost = 3;
            }
        }
        this.tagBtnStop.setInt(0);
        this.tagBtnEmrg.setInt(0);
        if ((flags & 1) == 0) {
            this.tagBtnSusp.setInt(0);
        }
        this.tagOutputOn.setBool(this.sost > 0);
        this.tagOutputRun.setBool(this.sost == 4);
        this.tagMesReady.setBool(this.sost == 2);
        this.tagStopFlow.setBool(stopFlow > 0);
        this.tagSost.setInt(this.sost);
        this.tagStopDlyCnt.setInt(stopDlyCnt);
        this.tagCounter.setInt(this.cnt);
        for (i = 0; i < this.outAmount; ++i) {
            this.tagOut.get(i).setBool(this.curOut >= i);
        }
        for (i = 0; i < this.SEQD_INP_AMOUNT; ++i) {
            this.tagMesStartBan.get(i).setInt(this.inpStartBan.get((int)i).value);
            this.tagMesStop.get(i).setInt(this.inpStop.get((int)i).value);
            this.tagMesStopDly.get(i).setInt(this.inpStopDly.get((int)i).value);
            this.tagMesStopFlow.get(i).setInt(this.inpStopFlow.get((int)i).value);
            this.tagMesStopRun.get(i).setInt(this.inpStopRun.get((int)i).value);
            this.tagMesStopStart.get(i).setInt(this.inpStopStart.get((int)i).value);
            this.tagMesSusp.get(i).setBool(this.inpSusp.get((int)i).input.getInt() > 0 && (this.sost == 3 || this.sost == 6));
        }
        return true;
    }

    protected int evalSeqdInput(List<SeqdInput> si, int excl, boolean enable) {
        if (enable) {
            int mask1 = 1;
            int mask2 = 256;
            int inpsum = 0;
            for (int i = 0; i < this.SEQD_INP_AMOUNT; ++i) {
                si.get((int)i).value = (excl & mask1) > 0 ? 0 : si.get((int)i).input.getInt();
                inpsum += (excl & mask2) > 0 || si.get((int)i).value == 0 ? 0 : mask1;
                mask1 <<= 1;
                mask2 <<= 1;
            }
            return inpsum;
        }
        for (int i = 0; i < this.SEQD_INP_AMOUNT; ++i) {
            si.get((int)i).value = 0;
        }
        return 0;
    }

    protected void evalStartCounter() {
        if (this.curOut < 0) {
            this.curOut = 0;
            this.cnt = 0;
        }
        while (this.curOut < this.outAmount && this.cnt++ >= this.tagTimeStart.get(this.curOut).getInt()) {
            ++this.curOut;
            this.cnt = 0;
        }
    }

    protected void evalStopCounter() {
        if (this.curOut >= this.outAmount) {
            this.curOut = this.outAmount - 1;
            this.cnt = 0;
        }
        while (this.curOut >= 0 && this.cnt++ >= this.tagTimeStop.get(this.curOut).getInt()) {
            --this.curOut;
            this.cnt = 0;
        }
    }

    @Override
    public void saveStateExtra(State state) {
        state.saveVar("curOut", this.curOut);
        state.saveVar("cnt", this.cnt);
        state.saveVar("cntBtnStart", this.cntBtnStart);
        state.saveVar("stopDlyCancel", this.stopDlyCancel);
        state.saveVar("sost", this.sost);
        this.saveInputValues(state, this.inpStartBan, "inpStartBan");
        this.saveInputValues(state, this.inpStop, "inpStop");
        this.saveInputValues(state, this.inpStopStart, "inpStopStart");
        this.saveInputValues(state, this.inpStopRun, "inpStopRun");
        this.saveInputValues(state, this.inpStopFlow, "inpStopFlow");
        this.saveInputValues(state, this.inpStopDly, "inpStopDly");
        this.saveInputValues(state, this.inpSusp, "inpSusp");
    }

    private void saveInputValues(State state, List<SeqdInput> list, String listname) {
        for (int i = 0; i < list.size(); ++i) {
            state.saveVar(listname + "_value_" + i, list.get((int)i).value);
        }
    }

    @Override
    public void loadStateExtra(State state) {
        this.curOut = state.loadVar("curOut", this.curOut);
        this.cnt = state.loadVar("cnt", this.cnt);
        this.cntBtnStart = state.loadVar("cntBtnStart", this.cntBtnStart);
        this.stopDlyCancel = state.loadVar("stopDlyCancel", this.stopDlyCancel);
        this.sost = state.loadVar("sost", this.sost);
        this.loadInputValues(state, this.inpStartBan, "inpStartBan");
        this.loadInputValues(state, this.inpStop, "inpStop");
        this.loadInputValues(state, this.inpStopStart, "inpStopStart");
        this.loadInputValues(state, this.inpStopRun, "inpStopRun");
        this.loadInputValues(state, this.inpStopFlow, "inpStopFlow");
        this.loadInputValues(state, this.inpStopDly, "inpStopDly");
        this.loadInputValues(state, this.inpSusp, "inpSusp");
    }

    private void loadInputValues(State state, List<SeqdInput> list, String listname) {
        for (int i = 0; i < list.size(); ++i) {
            list.get((int)i).value = state.loadVar(listname + "_value_" + i, list.get((int)i).value);
        }
    }

    public static class SeqdInput {
        Input input;
        int value;

        public SeqdInput(Input input) {
            this.input = input;
            this.value = 0;
        }
    }
}

