/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.task;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractModule;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.api.Task;
import promauto.jroboplc.core.api.TaskManager;
import promauto.jroboplc.plugin.task.TaskItem;
import promauto.jroboplc.plugin.task.TaskItemFlagSet;
import promauto.jroboplc.plugin.task.TaskItemFlagWait;
import promauto.jroboplc.plugin.task.TaskItemSleep;

public class TaskModule
extends AbstractModule
implements Runnable,
Task {
    private final Logger logger = LoggerFactory.getLogger(TaskModule.class);
    private Thread thread;
    protected Tag tagRunning;
    protected Tag tagTimecounter;
    protected Tag tagTimetotal_s;
    protected Tag tagTimecycle;
    protected Tag tagStatBaton;
    protected volatile boolean running = false;
    protected volatile boolean isStopped = true;
    protected volatile int stateBaton;
    protected int period;
    protected AtomicLong timecounter = new AtomicLong();
    private volatile long timetotal;
    private volatile long timecycle;
    protected LinkedList<TaskItem> items = new LinkedList();
    private Set<String> modules = new HashSet<String>();
    private int delayStart;

    public TaskModule(Plugin plugin, String name) {
        super(plugin, name);
        this.taskable = false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean loadModule(Object conf) {
        this.tagRunning = this.tagtable.createBool("running", false);
        this.tagTimecounter = this.tagtable.createInt("timecounter", 0);
        this.tagTimetotal_s = this.tagtable.createInt("timetotal", 0);
        this.tagTimecycle = this.tagtable.createInt("timecycle", 0);
        this.tagStatBaton = this.tagtable.createInt("statebaton", 0);
        Configuration cm = this.env.getConfiguration();
        this.delayStart = cm.get(conf, "delayStart", 0);
        this.period = cm.get(conf, "period", 1000);
        List<Object> records = cm.toList(cm.get(conf, "modules"));
        TaskManager tm = this.env.getTaskManager();
        Pattern p = Pattern.compile("(\\w+)\\((.*)\\)");
        try {
            for (Object rec : records) {
                void var8_9;
                Object var8_10 = null;
                Matcher m = p.matcher(rec.toString());
                if (m.find()) {
                    String func = m.group(1);
                    String args = m.group(2);
                    if (func.equals("_wait")) {
                        TaskItemFlagWait taskItemFlagWait = new TaskItemFlagWait(this, args);
                    } else if (func.equals("_set")) {
                        TaskItemFlagSet taskItemFlagSet = new TaskItemFlagSet(this, args);
                    } else {
                        if (!func.equals("_sleep")) return false;
                        TaskItemSleep taskItemSleep = new TaskItemSleep(this, args);
                    }
                } else {
                    String modname = rec.toString();
                    Task task = tm.getTask(modname);
                    if (task != null && !task.getName().equals(this.name)) {
                        this.env.printError(this.logger, this.name, "Module is already usen in another task:", modname, task.getName());
                        return false;
                    }
                    this.modules.add(modname);
                    TaskItem taskItem = new TaskItem(this, modname);
                }
                this.items.add((TaskItem)var8_9);
            }
            return true;
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            return false;
        }
    }

    @Override
    public boolean prepareModule() {
        for (TaskItem ti : this.items) {
            if (ti.init()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeModule() {
        if (this.running) {
            return true;
        }
        TaskModule taskModule = this;
        synchronized (taskModule) {
            if (!this.running) {
                this.isStopped = false;
                this.thread = new Thread(this);
                this.thread.setName("thread-" + this.name);
                this.running = true;
                this.tagRunning.setBool(true);
                this.stateBaton = 0;
                this.tagStatBaton.setInt(this.stateBaton);
                this.thread.start();
            }
        }
        return true;
    }

    @Override
    public boolean closedownModule() {
        this.isStopped = true;
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                this.env.printError(this.logger, e, this.name);
            }
        }
        try {
            while (this.running) {
                this.isStopped = true;
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException e) {
            this.env.printError(this.logger, e, this.name);
        }
        return true;
    }

    @Override
    public String getInfo() {
        String s = this.enable ? "cnt=" + this.timecounter + " total=" + this.timetotal + " cycle=" + this.timecycle + "/" + this.period : "disabled";
        return s;
    }

    @Override
    public void run() {
        try {
            Thread.sleep(this.delayStart);
            long timetotalbeg = System.currentTimeMillis();
            long timedelta = 0L;
            long timeend = timetotalbeg;
            long timeendReq = 0L;
            long maxTimeDelta = this.period / 4;
            this.timecounter.set(0L);
            while (this.env.isRunning() && !this.env.isTerminated() && !Thread.currentThread().isInterrupted()) {
                this.execute();
                if (this.isStopped) break;
                long timebeg = timeend;
                if (this.period > 0) {
                    timeendReq = timebeg + ((long)this.period - timedelta);
                }
                try {
                    for (TaskItem item : this.items) {
                        item.execute(timeendReq);
                        if (!this.isStopped) continue;
                        break;
                    }
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (Exception e) {
                    this.env.printError(this.logger, e, this.name, "Exception in the task");
                }
                this.timecycle = System.currentTimeMillis() - timebeg;
                this.tagTimecycle.setInt((int)this.timecycle);
                timeend = System.currentTimeMillis();
                if (!this.isStopped && this.period > 0) {
                    if (timeend - timeendReq < 0L) {
                        long timesleep = Math.max((long)this.period, timeendReq - timeend);
                        Thread.sleep(timesleep);
                        timeend = System.currentTimeMillis();
                    }
                    if ((timedelta = timeend - timebeg - ((long)this.period - timedelta)) < 0L) {
                        timedelta = 0L;
                    } else if (timedelta > maxTimeDelta) {
                        timedelta = maxTimeDelta;
                    }
                }
                this.tagTimecounter.setInt((int)this.timecounter.addAndGet(1L));
                this.timetotal = timeend - timetotalbeg;
                this.tagTimetotal_s.setInt((int)(this.timetotal / 1000L));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.running = false;
        this.tagRunning.setBool(false);
        this.isStopped = true;
    }

    @Override
    protected boolean reload() {
        boolean res = false;
        TaskModule tmp = new TaskModule(this.plugin, this.name);
        if (tmp.load() && tmp.prepare()) {
            this.copySettingsFrom(tmp);
            this.enable = tmp.enable;
            this.period = tmp.period;
            this.modules = tmp.modules;
            this.items = tmp.items;
            for (TaskItem item : this.items) {
                item.parentModule = this;
            }
            if (!this.enable && this.running) {
                this.isStopped = true;
            } else if (this.enable && !this.running) {
                this.execute();
            }
            res = true;
        }
        return res;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean hasModule(String module) {
        return this.modules.contains(module);
    }

    @Override
    public Set<String> getModules() {
        return this.modules;
    }

    @Override
    public int getPeriod() {
        return this.period;
    }
}

