/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperProcessConfig;
import org.tanukisoftware.wrapper.test.Main;
import org.tanukisoftware.wrapper.test.RuntimeExec;

public class ExecRead {
    private static boolean m_debug = false;
    private static final int CHILD_SLEEP_TIME_S = 2;
    private static final long CHILD_SLEEP_TIME_MS = 2000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doTest(String command, String testId, boolean readByteByteByByte, boolean newProcessGroup, boolean autoCloseInputStreams, long expectedTimeMs) {
        RuntimeExec.beginCase(testId);
        try {
            WrapperProcessConfig wrapperProcessConfig = new WrapperProcessConfig().setNewProcessGroup(newProcessGroup).setAutoCloseInputStreams(autoCloseInputStreams);
            try {
                RuntimeExec.handleWrapperProcess(testId, command, wrapperProcessConfig, 0L, true, false, false, 2, 0, m_debug, readByteByteByByte);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            RuntimeExec.endCase(testId, expectedTimeMs);
        }
    }

    private static void doTests(String executable, boolean testStdErr, boolean readByteByteByByte, boolean newProcessGroup, boolean autoCloseInputStreams) {
        StringBuffer sb = new StringBuffer();
        if (autoCloseInputStreams) {
            sb.append("AutoClose");
        } else {
            sb.append("Blocking ");
        }
        sb.append(" ");
        if (newProcessGroup) {
            sb.append("NewProcessGroup");
        } else {
            sb.append("SharedProcessGroup");
        }
        sb.append(" ");
        if (readByteByteByByte) {
            sb.append("Read ");
        } else {
            sb.append("Read2");
        }
        sb.append(" ");
        String context = sb.toString();
        String stdErrArg = testStdErr ? "-messagetostderr " : "";
        ExecRead.doTest(executable + " -message \"hello tanukis!\" " + stdErrArg + "-messageinterval 250 0 " + 2, context + "simplewaiter : ", readByteByteByByte, newProcessGroup, autoCloseInputStreams, 2000L);
        if (!WrapperManager.isWindows()) {
            ExecRead.doTest("bash -c \"" + executable + " -message hello\\ tanukis! " + stdErrArg + "-messageinterval 250 0 " + 2 + "\"", context + "Bash+simplewaiter : ", readByteByteByByte, newProcessGroup, autoCloseInputStreams, 2000L);
            ExecRead.doTest("bash -c \"export FOO=bar;" + executable + " -message hello\\ tanukis! " + stdErrArg + "-messageinterval 250 0 " + 2 + "\"", context + "Bash+env+simplewaiter : ", readByteByteByByte, newProcessGroup, autoCloseInputStreams, 2000L);
            ExecRead.doTest("bash -c \"" + executable + " -message hello\\ tanukis! " + stdErrArg + "-messageinterval 250 0 " + 2 + " &\"", context + "Bash+simplewaiter(detached) : ", readByteByteByByte, newProcessGroup, autoCloseInputStreams, (autoCloseInputStreams || WrapperManager.isZOS()) && !newProcessGroup ? 0L : 2000L);
            ExecRead.doTest("bash -c \"export FOO=bar;" + executable + " -message hello\\ tanukis! " + stdErrArg + "-messageinterval 250 0 " + 2 + " &\"", context + "Bash+env+simplewaiter(detached) : ", readByteByteByByte, newProcessGroup, autoCloseInputStreams, (autoCloseInputStreams || WrapperManager.isZOS()) && !newProcessGroup ? 0L : 2000L);
        }
    }

    public static void main(String[] args) {
        RuntimeExec.c_testsPerformed = 0;
        RuntimeExec.c_testsFailed = 0;
        String simplewaiter = WrapperManager.isWindows() ? "..\\test\\simplewaiter.exe" : "../test/simplewaiter";
        if (!WrapperManager.isWindows() && args.length > 0 && "true".equals(args[0])) {
            System.out.println(Main.getRes().getString("DEBUG mode enabled."));
            m_debug = true;
        }
        System.out.println("");
        System.out.println(Main.getRes().getString("A bunch of tests will be run. Please check that:\n- Each of the tests that take ~2 secs to execute have standard output messages.\n- Tests that stop immediately should not have stdout messages.\nThe summary of results below only take into account the expected times of execution."));
        ExecRead.doTests(simplewaiter, false, true, false, false);
        ExecRead.doTests(simplewaiter, false, true, false, true);
        ExecRead.doTests(simplewaiter, false, true, true, false);
        ExecRead.doTests(simplewaiter, false, true, true, true);
        ExecRead.doTests(simplewaiter, false, false, false, false);
        ExecRead.doTests(simplewaiter, false, false, false, true);
        ExecRead.doTests(simplewaiter, false, false, true, false);
        ExecRead.doTests(simplewaiter, false, false, true, true);
        ExecRead.doTests(simplewaiter, true, true, false, false);
        ExecRead.doTests(simplewaiter, true, true, false, true);
        ExecRead.doTests(simplewaiter, true, true, true, false);
        ExecRead.doTests(simplewaiter, true, true, true, true);
        ExecRead.doTests(simplewaiter, true, false, false, false);
        ExecRead.doTests(simplewaiter, true, false, false, true);
        ExecRead.doTests(simplewaiter, true, false, true, false);
        ExecRead.doTests(simplewaiter, true, false, true, true);
        int nbTestsFailed = RuntimeExec.c_testsFailed;
        int nbTestsPassed = RuntimeExec.c_testsPerformed - nbTestsFailed;
        System.out.println("");
        System.out.println(Main.getRes().getString("[PASSED] {0}", (Object)Integer.toString(nbTestsPassed)));
        System.out.println(Main.getRes().getString("[FAILED] {0}", (Object)Integer.toString(nbTestsFailed)));
        if (nbTestsFailed > 0) {
            System.exit(1);
        }
    }
}

