/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import org.tanukisoftware.wrapper.WrapperJNIError;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperProcess;
import org.tanukisoftware.wrapper.WrapperProcessConfig;
import org.tanukisoftware.wrapper.test.Main;

public class RuntimeExec {
    public static final int EXIT_CODE_NORMAL = 0;
    public static final int EXIT_CODE_ERROR = 1;
    public static final int EXIT_CODE_COMMAND_NOT_FOUND = WrapperManager.isWindows() ? 1 : 127;
    public static final int EXIT_CODE_TERM_CTRL_C = WrapperManager.isWindows() ? 1 : 143;
    public static final int EXIT_CODE_KILLED;
    public static final int EXIT_CODE_CRASH;
    static final String c_encoding;
    static int c_testsFailed;
    static boolean c_currentTestFailed;
    static int c_testsPerformed;
    static final int WAIT_MODE_NONE = 0;
    static final int WAIT_MODE_API = 1;
    static final int WAIT_MODE_MANUAL = 2;
    static BufferedReader debugStdOut;
    private static long c_start;

    static Thread handleOutputStream(final OutputStream os, final String encoding, final String text, final String label) {
        Thread runner = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    System.out.println(label);
                    BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os, encoding));
                    try {
                        bw.write(text, 0, text.length());
                    }
                    finally {
                        bw.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        runner.start();
        return runner;
    }

    static Thread handleInputStream(final InputStream is, final String encoding, final String label, final StringBuffer sb) {
        Thread runner = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));
                    try {
                        String line;
                        boolean firstLine = true;
                        while ((line = br.readLine()) != null) {
                            if (sb != null) {
                                if (firstLine) {
                                    firstLine = false;
                                } else {
                                    sb.append(System.getProperty("line.separator"));
                                }
                                sb.append(line);
                            }
                            System.out.println(label + " " + line);
                        }
                    }
                    finally {
                        br.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        runner.start();
        return runner;
    }

    static Thread handleInputStreamByteByByte(final InputStream is, final String label, final StringBuffer sb) {
        Thread runner = new Thread(){

            public void run() {
                try {
                    int c;
                    boolean printLabel = true;
                    while ((c = is.read()) != -1) {
                        if (sb != null) {
                            sb.append(c);
                        }
                        char chr = (char)c;
                        if (printLabel) {
                            System.out.print(label + " ");
                            printLabel = false;
                        }
                        System.out.print(chr);
                        if (chr != '\n') continue;
                        printLabel = true;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        runner.start();
        return runner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void handleJavaProcessInner(String testId, Process process) throws IOException, InterruptedException {
        try {
            RuntimeExec.handleInputStream(process.getInputStream(), c_encoding, testId + "stdout:", null);
            RuntimeExec.handleInputStream(process.getErrorStream(), c_encoding, testId + "stderr:", null);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            int exitCode = process.waitFor();
            System.out.println(Main.getRes().getString("{0}exitCode: {1}", (Object)testId, (Object)new Integer(exitCode)));
            throw throwable;
        }
        int exitCode = process.waitFor();
        System.out.println(Main.getRes().getString("{0}exitCode: {1}", (Object)testId, (Object)new Integer(exitCode)));
    }

    static void handleJavaProcess(String testId, String command) throws IOException, InterruptedException {
        System.out.println(Main.getRes().getString("{0}Runtime.exec command: {1}", (Object)testId, (Object)command));
        RuntimeExec.handleJavaProcessInner(testId, Runtime.getRuntime().exec(command));
    }

    static void handleJavaProcess(String testId, String[] command) throws IOException, InterruptedException {
        System.out.println(Main.getRes().getString("{0}Runtime.exec command: {1}", (Object)testId, (Object)RuntimeExec.toString(command)));
        RuntimeExec.handleJavaProcessInner(testId, Runtime.getRuntime().exec(command));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleWrapperProcessInner(String testId, WrapperProcess process, boolean newProcessGroup, long timeoutMS, boolean handleOutErr, boolean closeStdOutErr, String textStdIn, boolean closeStdIn, int waitMode, String outErrRegex, int expectedExitCode, boolean debug, boolean readByteByByte) throws IOException, InterruptedException {
        StringBuffer sbErr;
        StringBuffer sbOut;
        block61: {
            block59: {
                long time3;
                System.out.println(Main.getRes().getString("{0}  Launched PID={1}, PGID={2}", (Object)testId, (Object)Integer.toString(process.getPID()), (Object)Integer.toString(process.getPGID())));
                if (debug) {
                    final long sleepTime = timeoutMS * 2L / 3L;
                    final int pgid = process.getPGID();
                    new Thread(){

                        public void run() {
                            try {
                                Thread.sleep(sleepTime);
                                String[] cmd = new String[]{"/bin/sh", "-c", "ps -o pid,ppid,pgid,comm | grep -iE '" + pgid + "|pid' | grep -Ev ' sh| ps| grep'"};
                                Process proc = Runtime.getRuntime().exec(cmd);
                                debugStdOut = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                            }
                            catch (IOException e) {
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }.start();
                }
                if (newProcessGroup) {
                    if (process.getPID() != process.getPGID()) {
                        System.out.println(Main.getRes().getString("{0}    FAILED! A new process group was requested, but the child process does not have its own group.", (Object)testId));
                        c_currentTestFailed = true;
                    }
                } else if (process.getPID() == process.getPGID()) {
                    System.out.println(Main.getRes().getString("{0}    FAILED! A new process group was not requested, but the child process has a new group.", (Object)testId));
                    c_currentTestFailed = true;
                }
                Thread stdoutThread = null;
                Thread stderrThread = null;
                sbOut = null;
                sbErr = null;
                try {
                    if (textStdIn != null) {
                        RuntimeExec.handleOutputStream(process.getStdIn(), c_encoding, textStdIn, testId + "stdin: " + textStdIn);
                    }
                    if (handleOutErr) {
                        if (outErrRegex != null) {
                            sbOut = new StringBuffer();
                            sbErr = new StringBuffer();
                        }
                        if (readByteByByte) {
                            stdoutThread = RuntimeExec.handleInputStreamByteByByte(process.getStdOut(), testId + "stdout:", sbOut);
                            stderrThread = RuntimeExec.handleInputStreamByteByByte(process.getStdErr(), testId + "stderr:", sbErr);
                        } else {
                            stdoutThread = RuntimeExec.handleInputStream(process.getStdOut(), c_encoding, testId + "stdout:", sbOut);
                            stderrThread = RuntimeExec.handleInputStream(process.getStdErr(), c_encoding, testId + "stderr:", sbErr);
                        }
                    } else if (closeStdOutErr) {
                        process.getStdOut().close();
                        process.getStdErr().close();
                    }
                    if (closeStdIn) {
                        process.getStdIn().close();
                    }
                    if (waitMode != 1 && waitMode == 2 && timeoutMS > 0L) {
                        long start = System.currentTimeMillis();
                        while (process.isAlive() && System.currentTimeMillis() - start < timeoutMS) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {}
                        }
                        long time2 = System.currentTimeMillis() - start;
                        if (process.isAlive()) {
                            System.out.println(Main.getRes().getString("{0}Timed out after {1}ms waiting for child.  Destroying.", (Object)testId, (Object)Long.toString(time2)));
                            process.destroy();
                        } else if (System.currentTimeMillis() - start >= timeoutMS) {
                            System.out.println(Main.getRes().getString("{0}FAILED! Timed out after {1}ms waiting for child.  But child is already gone unexpectedly.", (Object)testId, (Object)Long.toString(time2)));
                            c_currentTestFailed = true;
                        } else {
                            System.out.println(Main.getRes().getString("{0}Child completed within {1}ms, before timeout of {2}ms.", (Object)testId, (Object)Long.toString(time2), (Object)Long.toString(timeoutMS)));
                        }
                    }
                    Object var23_22 = null;
                    if (waitMode != 1 && waitMode != 2) break block59;
                }
                catch (Throwable throwable) {
                    block62: {
                        Object var23_23 = null;
                        if (waitMode == 1 || waitMode == 2) {
                            int exitCode = process.waitFor();
                            if (exitCode == expectedExitCode) {
                                System.out.println(Main.getRes().getString("{0}exitCode: {1}", (Object)testId, (Object)new Integer(exitCode)));
                            } else {
                                System.out.println(Main.getRes().getString("{0}FAILED! exitCode: {1} but expected {2}", (Object)testId, (Object)new Integer(exitCode), (Object)new Integer(expectedExitCode)));
                                c_currentTestFailed = true;
                            }
                            long start = System.currentTimeMillis();
                            if (stdoutThread != null) {
                                System.out.println(Main.getRes().getString("{0}waiting for stdout thread...", (Object)testId));
                                try {
                                    stdoutThread.join();
                                    long time3 = System.currentTimeMillis() - start;
                                    if (time3 > 10L) {
                                        System.out.println(Main.getRes().getString("{0}stdout thread didn't complete for " + time3 + "ms. after child process exited.", (Object)testId));
                                    } else {
                                        System.out.println(Main.getRes().getString("{0}stdout thread complete promptly.", (Object)testId));
                                    }
                                }
                                catch (InterruptedException e) {
                                    System.out.println(Main.getRes().getString("{0}wait for stdout thread interrupted.", (Object)testId));
                                }
                            }
                            if (stderrThread != null) {
                                System.out.println(Main.getRes().getString("{0}waiting for stderr thread...", (Object)testId));
                                try {
                                    stderrThread.join();
                                    long time4 = System.currentTimeMillis() - start;
                                    if (time4 > 10L) {
                                        System.out.println(Main.getRes().getString("{0}stderr thread didn't complete for " + time4 + "ms. after child process exited.", (Object)testId));
                                        break block62;
                                    }
                                    System.out.println(Main.getRes().getString("{0}stderr thread complete promptly.", (Object)testId));
                                }
                                catch (InterruptedException e) {
                                    System.out.println(Main.getRes().getString("{0}wait for stderr thread interrupted.", (Object)testId));
                                }
                            }
                        } else {
                            System.out.println(Main.getRes().getString("{0}leave running...", (Object)testId));
                        }
                    }
                    if (outErrRegex != null && sbOut != null && sbErr != null) {
                        Pattern pattern = Pattern.compile(outErrRegex, 40);
                        if (pattern.matcher(sbOut).matches()) {
                            System.out.println(Main.getRes().getString("{0}Expected output found in {1}.", (Object)testId, (Object)"stdout"));
                        } else if (pattern.matcher(sbErr).matches()) {
                            System.out.println(Main.getRes().getString("{0}Expected output found in {1}.", (Object)testId, (Object)"stderr"));
                        } else {
                            System.out.println(Main.getRes().getString("{0}FAILED! Neither stdout nor stderr matched ''{1}''.", (Object)testId, (Object)outErrRegex));
                            c_currentTestFailed = true;
                        }
                    }
                    if (debug) {
                        System.out.println("----------------DEBUG----------------");
                        String s = null;
                        while ((s = debugStdOut.readLine()) != null) {
                            System.out.println(s);
                        }
                        System.out.println("-------------------------------------");
                    }
                    throw throwable;
                }
                int exitCode = process.waitFor();
                if (exitCode == expectedExitCode) {
                    System.out.println(Main.getRes().getString("{0}exitCode: {1}", (Object)testId, (Object)new Integer(exitCode)));
                } else {
                    System.out.println(Main.getRes().getString("{0}FAILED! exitCode: {1} but expected {2}", (Object)testId, (Object)new Integer(exitCode), (Object)new Integer(expectedExitCode)));
                    c_currentTestFailed = true;
                }
                long start = System.currentTimeMillis();
                if (stdoutThread != null) {
                    System.out.println(Main.getRes().getString("{0}waiting for stdout thread...", (Object)testId));
                    try {
                        stdoutThread.join();
                        time3 = System.currentTimeMillis() - start;
                        if (time3 > 10L) {
                            System.out.println(Main.getRes().getString("{0}stdout thread didn't complete for " + time3 + "ms. after child process exited.", (Object)testId));
                        } else {
                            System.out.println(Main.getRes().getString("{0}stdout thread complete promptly.", (Object)testId));
                        }
                    }
                    catch (InterruptedException e) {
                        System.out.println(Main.getRes().getString("{0}wait for stdout thread interrupted.", (Object)testId));
                    }
                }
                if (stderrThread != null) {
                    System.out.println(Main.getRes().getString("{0}waiting for stderr thread...", (Object)testId));
                    try {
                        stderrThread.join();
                        time3 = System.currentTimeMillis() - start;
                        if (time3 > 10L) {
                            System.out.println(Main.getRes().getString("{0}stderr thread didn't complete for " + time3 + "ms. after child process exited.", (Object)testId));
                            break block61;
                        }
                        System.out.println(Main.getRes().getString("{0}stderr thread complete promptly.", (Object)testId));
                    }
                    catch (InterruptedException e) {
                        System.out.println(Main.getRes().getString("{0}wait for stderr thread interrupted.", (Object)testId));
                    }
                }
                break block61;
            }
            System.out.println(Main.getRes().getString("{0}leave running...", (Object)testId));
        }
        if (outErrRegex != null && sbOut != null && sbErr != null) {
            Pattern pattern = Pattern.compile(outErrRegex, 40);
            if (pattern.matcher(sbOut).matches()) {
                System.out.println(Main.getRes().getString("{0}Expected output found in {1}.", (Object)testId, (Object)"stdout"));
            } else if (pattern.matcher(sbErr).matches()) {
                System.out.println(Main.getRes().getString("{0}Expected output found in {1}.", (Object)testId, (Object)"stderr"));
            } else {
                System.out.println(Main.getRes().getString("{0}FAILED! Neither stdout nor stderr matched ''{1}''.", (Object)testId, (Object)outErrRegex));
                c_currentTestFailed = true;
            }
        }
        if (debug) {
            System.out.println("----------------DEBUG----------------");
            String s = null;
            while ((s = debugStdOut.readLine()) != null) {
                System.out.println(s);
            }
            System.out.println("-------------------------------------");
        }
    }

    static void handleWrapperProcess(String testId, String command, WrapperProcessConfig config, long timeoutMS, boolean handleOutErr, boolean closeStdOutErr, String textStdIn, boolean closeStdIn, int waitMode, String outErrRegex, int expectedExitCode, boolean debug, boolean readByteByByte) throws IOException, InterruptedException {
        System.out.println(Main.getRes().getString("{0}WrapperManager.exec command: {1}", (Object)testId, (Object)command));
        if (config == null) {
            RuntimeExec.handleWrapperProcessInner(testId, WrapperManager.exec((String)command), true, timeoutMS, handleOutErr, closeStdOutErr, textStdIn, closeStdIn, waitMode, outErrRegex, expectedExitCode, debug, readByteByByte);
        } else {
            RuntimeExec.handleWrapperProcessInner(testId, WrapperManager.exec((String)command, (WrapperProcessConfig)config), config.isNewProcessGroup(), timeoutMS, handleOutErr, closeStdOutErr, textStdIn, closeStdIn, waitMode, outErrRegex, expectedExitCode, debug, readByteByByte);
        }
    }

    static void handleWrapperProcess(String testId, String command, WrapperProcessConfig config, long timeoutMS, boolean handleOutErr, boolean closeStdOutErr, boolean closeStdIn, int waitMode, int expectedExitCode, boolean debug, boolean readByteByByte) throws IOException, InterruptedException {
        RuntimeExec.handleWrapperProcess(testId, command, config, timeoutMS, handleOutErr, closeStdOutErr, null, closeStdIn, waitMode, null, expectedExitCode, debug, false);
    }

    static void handleWrapperProcess(String testId, String command, WrapperProcessConfig config, long timeoutMS, boolean handleOutErr, boolean closeStdOutErr, boolean closeStdIn, int waitMode, int expectedExitCode, boolean debug) throws IOException, InterruptedException {
        RuntimeExec.handleWrapperProcess(testId, command, config, timeoutMS, handleOutErr, closeStdOutErr, null, closeStdIn, waitMode, null, expectedExitCode, debug, false);
    }

    private static void handleWrapperProcess(String testId, String command) throws IOException, InterruptedException {
        RuntimeExec.handleWrapperProcess(testId, command, null, 0L, true, false, false, 2, 0, false);
    }

    private static void handleWrapperProcess(String testId, String[] command, WrapperProcessConfig config, long timeoutMS, boolean handleOutErr, boolean closeStdOutErr, boolean closeStdIn, int waitMode, int expectedExitCode) throws IOException, InterruptedException {
        System.out.println(Main.getRes().getString("{0}WrapperManager.exec command: {1}", (Object)testId, (Object)RuntimeExec.toString(command)));
        if (config == null) {
            RuntimeExec.handleWrapperProcessInner(testId, WrapperManager.exec((String[])command), true, timeoutMS, handleOutErr, closeStdOutErr, null, closeStdIn, waitMode, null, expectedExitCode, false, false);
        } else {
            RuntimeExec.handleWrapperProcessInner(testId, WrapperManager.exec((String[])command, (WrapperProcessConfig)config), config.isNewProcessGroup(), timeoutMS, handleOutErr, closeStdOutErr, null, closeStdIn, waitMode, null, expectedExitCode, false, false);
        }
    }

    private static void handleWrapperProcess(String testId, String[] command) throws IOException, InterruptedException {
        RuntimeExec.handleWrapperProcess(testId, command, null, 0L, true, false, false, 2, 0);
    }

    static void beginCase(String testId) {
        ++c_testsPerformed;
        c_currentTestFailed = false;
        c_start = System.currentTimeMillis();
        System.out.println();
        System.out.println(Main.getRes().getString("{0}BEGIN ----------------------------------------", (Object)testId));
    }

    static void endCase(String testId, long expectedTimeMs) {
        String result;
        long time = System.currentTimeMillis() - c_start;
        if (expectedTimeMs >= 0L) {
            long minTime = expectedTimeMs;
            long maxTime = expectedTimeMs + 999L;
            if (time < minTime || time > maxTime) {
                result = " " + Main.getRes().getString("FAILED! Expected time to be in range of {0} ~ {1}ms.", (Object)Long.toString(minTime), (Object)Long.toString(maxTime));
                c_currentTestFailed = true;
            } else {
                result = " " + Main.getRes().getString("OK.");
            }
        } else {
            result = "";
        }
        if (c_currentTestFailed) {
            ++c_testsFailed;
        }
        System.out.println(Main.getRes().getString("{0}END   ---------------------------------------- {1}ms.{2}", (Object)testId, (Object)Long.toString(time), (Object)result));
    }

    static void endCase(String testId) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        RuntimeExec.endCase(testId, -1L);
    }

    private static String toString(String[] command) {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        for (int i = 0; i < command.length; ++i) {
            String arg = command[i];
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("\"");
            sb.append(arg);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseSimpleTestJava(String simplewaiter) {
        String testId = "Simple Java : ";
        RuntimeExec.beginCase(testId);
        try {
            try {
                String command = simplewaiter + " -v \"test 123\" test 123 \"\\\"test\\\"";
                RuntimeExec.handleJavaProcess(testId, command);
            }
            catch (Exception e) {
                System.out.println(Main.getRes().getString("{0}ERROR - Unexpected error:", (Object)testId));
                e.printStackTrace();
                c_currentTestFailed = true;
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseSimpleTestWrapper(String simplewaiter) {
        String testId = "Simple Wrapper : ";
        RuntimeExec.beginCase(testId);
        try {
            try {
                String command = simplewaiter + " -v \"test 123\" test 123 \"\\\"test\\\"";
                RuntimeExec.handleWrapperProcess(testId, command);
            }
            catch (Exception e) {
                System.out.println(Main.getRes().getString("{0}ERROR - Unexpected error:", (Object)testId));
                e.printStackTrace();
                c_currentTestFailed = true;
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseSimpleTestJavaAry(String simplewaiter) {
        String testId = "Simple Java (Array) : ";
        RuntimeExec.beginCase(testId);
        try {
            try {
                String[] command = new String[]{simplewaiter, "-v", "\"test 123\"", "test 123", "\"\\\"test\\\"\""};
                RuntimeExec.handleJavaProcess(testId, command);
            }
            catch (Exception e) {
                System.out.println(Main.getRes().getString("{0}ERROR - Unexpected error:", (Object)testId));
                e.printStackTrace();
                c_currentTestFailed = true;
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseSimpleTestWrapperAry(String simplewaiter) {
        String testId = "Simple Wrapper (Array) : ";
        RuntimeExec.beginCase(testId);
        try {
            try {
                String[] command = new String[]{simplewaiter, "-v", "\"test 123\"", "test 123", "\"\\\"test\\\"\""};
                RuntimeExec.handleWrapperProcess(testId, command);
            }
            catch (Exception e) {
                System.out.println(Main.getRes().getString("{0}ERROR - Unexpected error:", (Object)testId));
                e.printStackTrace();
                c_currentTestFailed = true;
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseLongCommand(String simplewaiter, int len, boolean expectFailure) {
        block8: {
            String testId = "Long Command " + len + ": ";
            RuntimeExec.beginCase(testId);
            try {
                try {
                    StringBuffer sb = new StringBuffer();
                    sb.append(simplewaiter);
                    sb.append(" -v ");
                    while (sb.length() < len - 1) {
                        sb.append("x");
                    }
                    sb.append("y");
                    String command = sb.toString();
                    RuntimeExec.handleWrapperProcess(testId, command);
                    if (expectFailure) {
                        System.out.println(Main.getRes().getString("{0}Was looking for a failure, but the long command line passed.  This is likely because the limit is larger on this platform.", (Object)testId));
                    }
                }
                catch (Exception e) {
                    if (expectFailure) {
                        System.out.println(Main.getRes().getString("{0}Failed as expected: {1}", (Object)testId, (Object)e.toString()));
                        break block8;
                    }
                    System.out.println(Main.getRes().getString("{0}ERROR - Unexpected error:", (Object)testId));
                    e.printStackTrace();
                    c_currentTestFailed = true;
                }
            }
            finally {
                RuntimeExec.endCase(testId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseWaitFor(String simplewaiter) {
        String testId = "WaitFor : ";
        RuntimeExec.beginCase(testId);
        try {
            try {
                String command = simplewaiter + " 1 10";
                RuntimeExec.handleWrapperProcess(testId, command, null, 0L, true, false, false, 1, 1, false);
            }
            catch (Exception e) {
                System.out.println(Main.getRes().getString("{0}ERROR - Unexpected error:", (Object)testId));
                e.printStackTrace();
                c_currentTestFailed = true;
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseSmallChildProcess(String simplewaiter) {
        String testId = "Simple Wrapper (Array) : ";
        RuntimeExec.beginCase(testId);
        try {
            try {
                String command = simplewaiter + " 65 1";
                RuntimeExec.handleWrapperProcess(testId, command, null, 0L, false, false, true, 2, 65, false);
            }
            catch (InterruptedException e) {
                System.out.println(Main.getRes().getString("{0}ERROR - Unexpected error:", (Object)testId));
                e.printStackTrace();
                c_currentTestFailed = true;
            }
            catch (Exception e) {
                System.out.println(Main.getRes().getString("{0}ERROR - Unexpected error:", (Object)testId));
                e.printStackTrace();
                c_currentTestFailed = true;
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseVFork(String simplewaiter) {
        String testId = "VFork : ";
        RuntimeExec.beginCase(testId);
        try {
            if (!WrapperProcessConfig.isSupported((int)3)) {
                System.out.println(Main.getRes().getString("{0}vfork not supported", (Object)testId));
            } else {
                System.out.println(Main.getRes().getString("{0}vfork is supported", (Object)testId));
                try {
                    String command = simplewaiter + " 20 10";
                    RuntimeExec.handleWrapperProcess(testId, command, new WrapperProcessConfig().setStartType(3), 0L, true, false, false, 2, 20, false);
                }
                catch (Exception e) {
                    System.out.println(Main.getRes().getString("{0}ERROR - Unexpected error:", (Object)testId));
                    e.printStackTrace();
                    c_currentTestFailed = true;
                }
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void casePosixSpawn(String simplewaiter) {
        String testId = "PosixSpawn : ";
        RuntimeExec.beginCase(testId);
        try {
            if (!WrapperProcessConfig.isSupported((int)1)) {
                System.out.println(Main.getRes().getString("{0}posix spawn not supported", (Object)testId));
            } else {
                System.out.println(Main.getRes().getString("{0}posix spawn is supported", (Object)testId));
                try {
                    String command = simplewaiter + " 20 10";
                    RuntimeExec.handleWrapperProcess(testId, command, new WrapperProcessConfig().setStartType(1), 0L, true, false, false, 2, 20, false);
                }
                catch (Exception e) {
                    System.out.println(Main.getRes().getString("{0}ERROR - Unexpected error:", (Object)testId));
                    e.printStackTrace();
                    c_currentTestFailed = true;
                }
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseEnvSmall(String simplewaiter) {
        String testId = "Environment Small : ";
        RuntimeExec.beginCase(testId);
        try {
            try {
                WrapperProcessConfig config = new WrapperProcessConfig();
                Map environment = config.getEnvironment();
                environment.clear();
                environment.put("TEST", "TEST123");
                System.out.println(Main.getRes().getString("{0}size of Environment map = {1}", (Object)testId, (Object)new Integer(environment.size())));
                String command = simplewaiter + " -e TEST";
                RuntimeExec.handleWrapperProcess(testId, command, config, 0L, true, false, false, 2, 0, false);
            }
            catch (Exception e) {
                System.out.println(Main.getRes().getString("{0}ERROR - Unexpected error:", (Object)testId));
                e.printStackTrace();
                c_currentTestFailed = true;
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseEnvLarge(String simplewaiter, int len, boolean expectFailure) {
        block8: {
            String testId = "Environment Large " + len + ": ";
            RuntimeExec.beginCase(testId);
            try {
                try {
                    int valueLen = len - 4 - 1;
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < valueLen - 1; ++i) {
                        sb.append("X");
                    }
                    sb.append("Y");
                    String value = sb.toString();
                    WrapperProcessConfig config = new WrapperProcessConfig();
                    Map environment = config.getEnvironment();
                    environment.clear();
                    environment.put("TEST", value);
                    System.out.println(Main.getRes().getString("{0}size of Environment map = {1}", (Object)testId, (Object)new Integer(environment.size())));
                    String command = simplewaiter + " -e TEST";
                    RuntimeExec.handleWrapperProcess(testId, command, config, 0L, true, false, false, 2, 0, false);
                    if (expectFailure) {
                        System.out.println(Main.getRes().getString("{0}Was looking for a failure, but the long environment variable passed.  This is likely because the limit is larger on this platform.", (Object)testId));
                    }
                }
                catch (Exception e) {
                    if (expectFailure) {
                        System.out.println(Main.getRes().getString("{0}Failed as expected: {1}", (Object)testId, (Object)e.toString()));
                        break block8;
                    }
                    System.out.println(Main.getRes().getString("{0}ERROR - Unexpected error:", (Object)testId));
                    e.printStackTrace();
                    c_currentTestFailed = true;
                }
            }
            finally {
                RuntimeExec.endCase(testId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseWorkingDir(String simplewaiter) {
        String testId = "Change Working Dir : ";
        RuntimeExec.beginCase(testId);
        try {
            if (WrapperProcessConfig.isSupported((int)2) || WrapperProcessConfig.isSupported((int)3)) {
                System.out.println(Main.getRes().getString("{0}changing the working directory is supported", (Object)testId));
                try {
                    WrapperProcessConfig config = new WrapperProcessConfig();
                    config.setStartType(WrapperProcessConfig.isSupported((int)2) ? 2 : 3);
                    config.setWorkingDirectory(new File(".."));
                    String command = WrapperManager.isWindows() ? "cmd.exe /c dir" : "ls -l";
                    RuntimeExec.handleWrapperProcess(testId, command, config, 0L, true, false, false, 2, 0, false);
                }
                catch (Exception e) {
                    System.out.println(Main.getRes().getString("{0}ERROR - Unexpected error:", (Object)testId));
                    e.printStackTrace();
                    c_currentTestFailed = true;
                }
            } else {
                System.out.println(Main.getRes().getString("{0}changing the working directory is not supported", (Object)testId));
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseWrapperDuringJava(String simplewaiter) {
        String testId = "Wrapper During Java : ";
        RuntimeExec.beginCase(testId);
        try {
            try {
                String javaCommand = simplewaiter + " 5 10";
                String wrapperCommand = simplewaiter + " 6 5";
                Process javaProcess = Runtime.getRuntime().exec(javaCommand);
                RuntimeExec.handleInputStream(javaProcess.getInputStream(), c_encoding, testId + "Runtime.exec stdout:", null);
                RuntimeExec.handleInputStream(javaProcess.getErrorStream(), c_encoding, testId + "Runtime.exec stderr:", null);
                WrapperProcess wrapperProcess = WrapperManager.exec((String)wrapperCommand);
                RuntimeExec.handleInputStream(wrapperProcess.getStdOut(), c_encoding, testId + "WrapperManager.exec stdout:", null);
                RuntimeExec.handleInputStream(wrapperProcess.getStdErr(), c_encoding, testId + "WrapperManager.exec stderr:", null);
                System.out.println(Main.getRes().getString("{0}WrapperManager.exec exitCode: {1}", (Object)testId, (Object)new Integer(wrapperProcess.waitFor())));
                System.out.println(Main.getRes().getString("{0}Runtime.exec exitCode: {1}", (Object)testId, (Object)new Integer(javaProcess.waitFor())));
            }
            catch (Exception e) {
                System.out.println(Main.getRes().getString("{0}ERROR - Unexpected error:", (Object)testId));
                e.printStackTrace();
                c_currentTestFailed = true;
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseJavaDuringWrapper(String simplewaiter) {
        String testId = "Java During Wrapper : ";
        RuntimeExec.beginCase(testId);
        try {
            try {
                String wrapperCommand = simplewaiter + " 5 10";
                String javaCommand = simplewaiter + " 6 5";
                WrapperProcess wrapperProcess = WrapperManager.exec((String)wrapperCommand);
                RuntimeExec.handleInputStream(wrapperProcess.getStdOut(), c_encoding, testId + "WrapperManager.exec stdout:", null);
                RuntimeExec.handleInputStream(wrapperProcess.getStdErr(), c_encoding, testId + "WrapperManager.exec stderr:", null);
                Process javaProcess = Runtime.getRuntime().exec(javaCommand);
                RuntimeExec.handleInputStream(javaProcess.getInputStream(), c_encoding, testId + "Runtime.exec stdout:", null);
                RuntimeExec.handleInputStream(javaProcess.getErrorStream(), c_encoding, testId + "Runtime.exec stderr:", null);
                System.out.println(Main.getRes().getString("{0}Runtime.exec exitCode: {1}", (Object)testId, (Object)new Integer(javaProcess.waitFor())));
                System.out.println(Main.getRes().getString("{0}WrapperManager.exec exitCode: {1}", (Object)testId, (Object)new Integer(wrapperProcess.waitFor())));
            }
            catch (Exception e) {
                System.out.println(Main.getRes().getString("{0}ERROR - Unexpected error:", (Object)testId));
                e.printStackTrace();
                c_currentTestFailed = true;
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseInvalid(String simplewaiter) {
        String testId = "Invalid : ";
        RuntimeExec.beginCase(testId);
        try {
            try {
                String command = "invalid";
                RuntimeExec.handleWrapperProcess(testId, command, null, 0L, true, false, false, 2, EXIT_CODE_COMMAND_NOT_FOUND, false);
                System.out.println(Main.getRes().getString("{0}ERROR! Did not fail as expected.", (Object)testId));
                c_currentTestFailed = true;
            }
            catch (Exception e) {
                System.out.println(Main.getRes().getString("{0}Failed as expected.", (Object)testId));
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseTimeoutShort(String simplewaiter) {
        String testId = "Timeout Short : ";
        RuntimeExec.beginCase(testId);
        try {
            try {
                String command = simplewaiter + " 0 5";
                RuntimeExec.handleWrapperProcess(testId, command, null, 10000L, true, false, false, 2, 0, false);
            }
            catch (Exception e) {
                System.out.println(Main.getRes().getString("{0}ERROR - Unexpected error:", (Object)testId));
                e.printStackTrace();
                c_currentTestFailed = true;
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseTimeoutLong(String simplewaiter) {
        String testId = "Timeout Long : ";
        RuntimeExec.beginCase(testId);
        try {
            try {
                String command = simplewaiter + " 0 30";
                RuntimeExec.handleWrapperProcess(testId, command, null, 10000L, true, false, false, 2, EXIT_CODE_TERM_CTRL_C, false);
            }
            catch (Exception e) {
                System.out.println(Main.getRes().getString("{0}ERROR - Unexpected error:", (Object)testId));
                e.printStackTrace();
                c_currentTestFailed = true;
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean caseLeaveRunning(String simplewaiter) {
        String testId = "Leave Running : ";
        RuntimeExec.beginCase(testId);
        try {
            String command = simplewaiter + " 1 600";
            RuntimeExec.handleWrapperProcess(testId, command, null, 0L, true, false, false, 0, 1, false);
            boolean bl = false;
            return bl;
        }
        catch (WrapperJNIError e) {
            System.out.println(Main.getRes().getString("{0}Unable to launch child process because JNI library unavailable. Normal on shutdown.", (Object)testId));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println(Main.getRes().getString("{0}ERROR - Unexpected error:", (Object)testId));
            e.printStackTrace();
            c_currentTestFailed = true;
            boolean bl = true;
            return bl;
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    public static void main(String[] args) {
        c_testsPerformed = 0;
        c_testsFailed = 0;
        final String simplewaiter = WrapperManager.isWindows() ? "../test/simplewaiter.exe" : "../test/simplewaiter";
        System.out.println("Communicate with child processes using encoding: " + c_encoding);
        Random rand = new Random();
        System.out.println(Main.getRes().getString("Is DYNAMIC supported? A:") + WrapperProcessConfig.isSupported((int)4));
        System.out.println(Main.getRes().getString("Is FORK_EXEC supported? A:") + WrapperProcessConfig.isSupported((int)2));
        System.out.println(Main.getRes().getString("Is VFORK_EXEC supported? A:") + WrapperProcessConfig.isSupported((int)3));
        System.out.println(Main.getRes().getString("Is POSIX_SPAWN supported? A:") + WrapperProcessConfig.isSupported((int)1));
        RuntimeExec.caseSimpleTestJava(simplewaiter);
        RuntimeExec.caseSimpleTestWrapper(simplewaiter);
        RuntimeExec.caseSimpleTestJavaAry(simplewaiter);
        RuntimeExec.caseSimpleTestWrapperAry(simplewaiter);
        RuntimeExec.caseLongCommand(simplewaiter, 32766, false);
        RuntimeExec.caseLongCommand(simplewaiter, Short.MAX_VALUE, true);
        RuntimeExec.caseWaitFor(simplewaiter);
        RuntimeExec.caseSmallChildProcess(simplewaiter);
        RuntimeExec.caseVFork(simplewaiter);
        RuntimeExec.casePosixSpawn(simplewaiter);
        RuntimeExec.caseEnvSmall(simplewaiter);
        RuntimeExec.caseEnvLarge(simplewaiter, Short.MAX_VALUE, false);
        RuntimeExec.caseEnvLarge(simplewaiter, 32768, true);
        RuntimeExec.caseWorkingDir(simplewaiter);
        RuntimeExec.caseWrapperDuringJava(simplewaiter);
        RuntimeExec.caseJavaDuringWrapper(simplewaiter);
        RuntimeExec.caseInvalid(simplewaiter);
        RuntimeExec.caseTimeoutShort(simplewaiter);
        RuntimeExec.caseTimeoutLong(simplewaiter);
        RuntimeExec.caseLeaveRunning(simplewaiter);
        int nbTestsPassed = c_testsPerformed - c_testsFailed;
        System.out.println("");
        System.out.println("(Test results for current JVM #" + WrapperManager.getJVMId() + ")");
        System.out.println(Main.getRes().getString("[PASSED] {0}", (Object)Integer.toString(nbTestsPassed)));
        System.out.println(Main.getRes().getString("[FAILED] {0}", (Object)Integer.toString(c_testsFailed)));
        System.out.println();
        if (WrapperManager.getJVMId() == 1) {
            System.out.println(Main.getRes().getString("All Done. Restarting..."));
            WrapperManager.restart();
        } else {
            System.out.println(Main.getRes().getString("All Done. Registering long shutdown hook and stopping.\nWrapper should timeout and kill the JVM, cleaning up all processes in the process."));
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    System.out.println(Main.getRes().getString("Starting shutdown hook. Loop for 25 seconds."));
                    System.out.println(Main.getRes().getString("Should timeout unless this property is set: wrapper.jvm_exit.timeout=30"));
                    long start = System.currentTimeMillis();
                    boolean failed = false;
                    while (System.currentTimeMillis() - start < 25000L) {
                        if (!failed) {
                            failed = RuntimeExec.caseLeaveRunning(simplewaiter);
                            System.out.println(Main.getRes().getString("Launched child..."));
                        }
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException e) {}
                    }
                    System.out.println(Main.getRes().getString("Shutdown hook complete. Should exit now."));
                }
            });
            if (c_testsFailed > 0) {
                System.exit(1);
            } else {
                System.exit(0);
            }
        }
    }

    static {
        int n = EXIT_CODE_KILLED = WrapperManager.isWindows() ? 1 : 137;
        EXIT_CODE_CRASH = WrapperManager.isWindows() ? -1073741819 : (WrapperManager.isMacOSX() ? 132 : 139);
        c_testsFailed = 0;
        c_currentTestFailed = false;
        c_testsPerformed = 0;
        String encoding = System.getProperty("sun.jnu.encoding");
        if (encoding == null && (encoding = System.getProperty("file.encoding")) == null) {
            encoding = "Cp1252";
        }
        c_encoding = encoding;
    }
}

