/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.motohr;

import java.sql.SQLException;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.motohr.Context;
import promauto.jroboplc.plugin.motohr.CounterType;
import promauto.jroboplc.plugin.motohr.Mach;

public class Counter {
    private static final int COUNTER_DISABLED = Integer.MAX_VALUE;
    private final int id;
    private final Context ctx;
    public final CounterType counterType;
    public final Mach mach;
    private final TagRW tagSec;
    private final boolean total;

    public Counter(Context ctx, int id, CounterType counterType, Mach mach, int sec) {
        this.id = id;
        this.ctx = ctx;
        this.counterType = counterType;
        this.mach = mach;
        this.tagSec = ctx.tagtable.createRWInt(mach.name + ".cnt" + counterType.id, sec);
        this.total = counterType.id == 1;
    }

    public void addSeconds(int sec) throws SQLException {
        if (this.tagSec.getInt() != Integer.MAX_VALUE) {
            this.tagSec.setReadValInt(this.tagSec.getInt() + (this.counterType.timer ? -1 : 1) * sec);
            this.ctx.service.saveCounter(this.id, this.tagSec.getInt());
        }
    }

    public void execute() throws SQLException {
        if (this.tagSec.hasWriteValue()) {
            boolean valueDisabled;
            int oldValue;
            int newValue = this.tagSec.getWriteValInt();
            if (newValue == (oldValue = this.getValue())) {
                return;
            }
            int value = newValue;
            boolean bl = valueDisabled = value == Integer.MAX_VALUE;
            if (this.total && (valueDisabled || this.mach.state.running)) {
                return;
            }
            if (!this.counterType.timer && value != 0 && !valueDisabled) {
                return;
            }
            if (this.counterType.timer && value < 0) {
                return;
            }
            if (!valueDisabled) {
                value += (this.counterType.timer ? 1 : -1) * this.mach.getRunningSec();
            }
            this.tagSec.setReadValInt(value);
            this.ctx.service.saveCounter(this.id, this.tagSec.getInt());
        }
    }

    private Object valueToStr(int value) {
        return value == Integer.MAX_VALUE ? "\u041e\u0442\u043a\u043b" : String.format("%.1f", (double)value / 3600.0);
    }

    public int getValue() {
        if (this.tagSec.getInt() == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return this.tagSec.getInt() + (this.counterType.timer ? -1 : 1) * this.mach.getRunningSec();
    }

    public boolean isTotal() {
        return this.total;
    }

    public int getId() {
        return this.id;
    }

    public void remove() {
        this.ctx.tagtable.remove(this.tagSec);
    }

    public static class DTO {
        int id;
        int counterTypeId;
        int sec;

        public DTO(int id, int counterTypeId, int sec) {
            this.id = id;
            this.counterTypeId = counterTypeId;
            this.sec = sec;
        }
    }
}

