/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolModbus;

public class OwenTrm212Module
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(OwenTrm212Module.class);
    protected ProtocolModbus protocol = new ProtocolModbus(this);
    protected Tag tagLvoPSTAT;
    protected Tag tagLvoPPV1;
    protected Tag tagLvoPPV2;
    protected TagRW tagLvoPSP;

    public OwenTrm212Module(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        this.tagLvoPSTAT = this.tagtable.createInt("LvoP.STAT", 0, 8);
        this.tagLvoPPV1 = this.tagtable.createInt("LvoP.PV1", 0, 8);
        this.tagLvoPPV2 = this.tagtable.createInt("LvoP.PV2", 0, 8);
        this.tagLvoPSP = this.protocol.addWriteTag(4, this.tagtable.createRWInt("LvoP.SP", 0, 8));
        return true;
    }

    @Override
    protected void initChannelMap(List<String> chtags) {
        this.addChannelMapTag(chtags, this.tagLvoPPV1, "0");
        this.addChannelMapTag(chtags, this.tagLvoPPV2, "1");
        this.addChannelMapTag(chtags, this.tagLvoPSP, "sp");
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            this.tagLvoPSP.acceptWriteValue();
            return true;
        }
        boolean result = true;
        try {
            result = this.protocol.sendWriteTags(16);
            if (result && (result = this.protocol.requestCmd3(0, 3))) {
                this.tagLvoPSTAT.setInt(this.protocol.getAnswerWord(0));
                this.tagLvoPPV1.setInt(this.protocol.getAnswerWord(1));
                this.tagLvoPPV2.setInt(this.protocol.getAnswerWord(2));
            }
            if (result = this.protocol.requestCmd3(4, 1)) {
                this.tagLvoPSP.setReadValInt(this.protocol.getAnswerWord(0));
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            result = false;
        }
        return result;
    }
}

