/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.zip.CRC32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.utils.Numbers;

public class UpsNanoModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(UpsNanoModule.class);
    private static int BUFFOUT_SIZE = 15;
    private static int BUFFIN_SIZE = 8;
    protected int[] buffout = new int[BUFFOUT_SIZE];
    protected int[] buffin = new int[BUFFIN_SIZE];
    protected Tag tagBatTimeout;
    protected Tag tagSerTimeout;
    protected Tag tagOutAux;
    protected Tag tagInpAcok;
    protected Tag tagInpBatlow;
    protected Tag tagInpAux;
    protected Tag tagT;
    protected Tag tagShutdown;
    protected Tag tagBeep;
    protected Tag tagVersion;
    private CRC32 crc = new CRC32();

    public UpsNanoModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        this.tagBatTimeout = this.tagtable.createInt("BatTimeout", 60, 1);
        this.tagSerTimeout = this.tagtable.createInt("SerTimeout", 3, 1);
        this.tagBeep = this.tagtable.createInt("beep", 0, 1);
        this.tagInpAcok = this.tagtable.createInt("InpAcok", 0, 8);
        this.tagInpBatlow = this.tagtable.createInt("InpBatlow", 0, 8);
        this.tagInpAux = this.tagtable.createInt("InpAux", 0, 8);
        this.tagOutAux = this.tagtable.createInt("OutAux", 0, 8);
        this.tagT = this.tagtable.createInt("T", 0, 8);
        this.tagShutdown = this.tagtable.createInt("shutdown", 0, 8);
        this.tagVersion = this.tagtable.createInt("version", 0, 8);
        return true;
    }

    @Override
    public boolean executePeripherialModule() {
        boolean result = true;
        if (!this.emulated) {
            try {
                this.buffout[0] = this.tagVersion.getInt();
                Numbers.wordToBytes(this.tagBatTimeout.getInt(), this.buffout, 1);
                Numbers.wordToBytes(this.tagSerTimeout.getInt(), this.buffout, 3);
                this.buffout[5] = 0;
                this.buffout[6] = 0;
                this.buffout[7] = 0;
                this.buffout[8] = 0;
                this.buffout[9] = this.tagOutAux.getInt();
                this.buffout[10] = this.tagBeep.getInt() << 4;
                long cs = this.getCrc(this.buffout, BUFFOUT_SIZE - 4);
                Numbers.dwordToBytes(cs, this.buffout, BUFFOUT_SIZE - 4);
                result = this.request();
                if (result) {
                    this.tagInpAcok.setInt(this.buffin[1] & 1);
                    this.tagInpBatlow.setBool((this.buffin[1] & 2) > 0);
                    this.tagInpAux.setBool((this.buffin[1] & 4) > 0);
                    this.tagT.setInt(Numbers.bytesToWord(this.buffin, 2));
                }
            }
            catch (Exception e) {
                this.env.printError(this.logger, e, this.name);
                result = false;
            }
            this.tagShutdown.setBool(result && this.tagInpAcok.getInt() == 0);
        }
        return result;
    }

    private long getCrc(int[] buff, int len) {
        this.crc.reset();
        for (int i = 0; i < len; ++i) {
            this.crc.update(buff[i]);
        }
        return this.crc.getValue();
    }

    private boolean request() throws Exception {
        if (this.port == null) {
            return false;
        }
        for (int trynum = 0; trynum < this.retrial; ++trynum) {
            long cs2;
            long cs1;
            this.port.discard();
            this.port.writeBytes(this.buffout, BUFFOUT_SIZE);
            int n = this.port.readBytes(this.buffin, BUFFIN_SIZE);
            boolean badcrc = false;
            if (n == BUFFIN_SIZE && (badcrc = (cs1 = this.getCrc(this.buffin, BUFFIN_SIZE - 4)) == (cs2 = Numbers.bytesToDWord(this.buffin, BUFFIN_SIZE - 4)))) {
                if (this.buffin[0] == 255) {
                    this.changeVersion(this.buffin[1]);
                } else {
                    return true;
                }
            }
            if (this.canLogError()) {
                this.logError(trynum, badcrc, this.buffout, BUFFOUT_SIZE, this.buffin, n, "");
            }
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.tagErrorCnt.setInt(this.tagErrorCnt.getInt() + 1);
        return false;
    }

    private void changeVersion(int new_version) {
        this.tagVersion.setInt(new_version);
    }
}

