/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolModbus;
import promauto.utils.Numbers;

public class PaGeliosMaslo2v2Module
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(PaGeliosMaslo2v2Module.class);
    protected ProtocolModbus protocol = new ProtocolModbus(this);
    protected TagRW tagWeightHigh1;
    protected TagRW tagWeightLow1;
    protected TagRW tagNumHigh1;
    protected TagRW tagNumLow1;
    protected TagRW tagWeightHigh2;
    protected TagRW tagWeightLow2;
    protected TagRW tagNumHigh2;
    protected TagRW tagNumLow2;
    protected TagRW tagCmd;
    protected TagRW tagNominal;
    protected Tag tagNetto;
    protected Tag tagState;
    protected Tag tagDStep;
    protected Tag tagIn;
    protected Tag tagOut;
    protected Tag tagErrorCode;
    protected Tag tagStopCode;
    protected Tag tagWeightKg1;
    protected Tag tagWeightKg2;
    protected TagRW tagWesSvrState;
    private long wesSvrStateTimer;

    public PaGeliosMaslo2v2Module(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        this.tagWeightHigh1 = this.tagtable.createRWInt("WeightHigh1", 0, 8);
        this.tagWeightLow1 = this.tagtable.createRWInt("WeightLow1", 0, 8);
        this.tagNumHigh1 = this.tagtable.createRWInt("NumHigh1", 0, 8);
        this.tagNumLow1 = this.tagtable.createRWInt("NumLow1", 0, 8);
        this.tagWeightHigh2 = this.tagtable.createRWInt("WeightHigh2", 0, 8);
        this.tagWeightLow2 = this.tagtable.createRWInt("WeightLow2", 0, 8);
        this.tagNumHigh2 = this.tagtable.createRWInt("NumHigh2", 0, 8);
        this.tagNumLow2 = this.tagtable.createRWInt("NumLow2", 0, 8);
        this.tagCmd = this.tagtable.createRWInt("Cmd", 0, 8);
        this.tagNominal = this.tagtable.createRWInt("Nominal", 0, 8);
        this.tagNetto = this.tagtable.createInt("Netto", 0, 8);
        this.tagState = this.tagtable.createInt("State", 0, 8);
        this.tagDStep = this.tagtable.createInt("DStep", 0, 8);
        this.tagIn = this.tagtable.createInt("In", 0, 8);
        this.tagOut = this.tagtable.createInt("Out", 0, 8);
        this.tagErrorCode = this.tagtable.createInt("ErrorCode", 0, 8);
        this.tagStopCode = this.tagtable.createInt("StopCode", 0, 8);
        this.tagWeightKg1 = this.tagtable.createInt("WeightKg1", 0, 8);
        this.tagWeightKg2 = this.tagtable.createInt("WeightKg2", 0, 8);
        this.tagWesSvrState = this.tagtable.createRWInt("WesSvrState", 0);
        this.initCrc16Tags();
        this.crc16Tags.addAll(Arrays.asList(this.tagWeightHigh1, this.tagWeightLow1, this.tagNumHigh1, this.tagNumLow1, this.tagWeightHigh2, this.tagWeightLow2, this.tagNumHigh2, this.tagNumLow2));
        this.crc16Tags.add(this.tagError);
        return true;
    }

    @Override
    public boolean executePeripherialModule() {
        boolean result = true;
        if (this.emulated) {
            this.tagWeightHigh1.acceptWriteValue();
            this.tagWeightLow1.acceptWriteValue();
            this.tagNumHigh1.acceptWriteValue();
            this.tagNumLow1.acceptWriteValue();
            this.tagWeightHigh2.acceptWriteValue();
            this.tagWeightLow2.acceptWriteValue();
            this.tagNumHigh2.acceptWriteValue();
            this.tagNumLow2.acceptWriteValue();
            this.tagCmd.acceptWriteValue();
            this.tagNominal.acceptWriteValue();
        } else {
            try {
                if (result && this.tagNominal.hasWriteValue()) {
                    int value = this.tagNominal.getWriteValInt();
                    result &= this.protocol.requestCmd10(4112, 2, value >> 16, value & 0xFFFF);
                }
                if (result && this.tagCmd.hasWriteValue()) {
                    result &= this.protocol.requestCmd6(4103, this.tagCmd.getWriteValInt());
                }
                if (result && (result = this.protocol.requestCmd3(4096, 18))) {
                    this.tagNetto.setInt(Numbers.bytesToInt(this.protocol.buffin, 3));
                    this.tagState.setInt(Numbers.bytesToWord(this.protocol.buffin, 7));
                    this.tagIn.setInt(Numbers.bytesToWord(this.protocol.buffin, 9));
                    this.tagOut.setInt(Numbers.bytesToWord(this.protocol.buffin, 11));
                    this.tagErrorCode.setInt(Numbers.bytesToWord(this.protocol.buffin, 15));
                    this.tagCmd.setReadValInt(Numbers.bytesToWord(this.protocol.buffin, 17));
                    this.tagDStep.setInt(Numbers.bytesToWord(this.protocol.buffin, 19));
                    this.tagStopCode.setInt(Numbers.bytesToWord(this.protocol.buffin, 21));
                    this.tagNominal.setReadValInt(Numbers.bytesToInt(this.protocol.buffin, 35));
                }
                if (result && (result = this.protocol.requestCmd3(4128, 8))) {
                    this.tagWeightHigh1.setReadValInt(Numbers.bytesToWord(this.protocol.buffin, 3));
                    this.tagWeightLow1.setReadValInt(Numbers.bytesToWord(this.protocol.buffin, 5));
                    this.tagNumHigh1.setReadValInt(Numbers.bytesToWord(this.protocol.buffin, 7));
                    this.tagNumLow1.setReadValInt(Numbers.bytesToWord(this.protocol.buffin, 9));
                    this.tagWeightHigh2.setReadValInt(Numbers.bytesToWord(this.protocol.buffin, 11));
                    this.tagWeightLow2.setReadValInt(Numbers.bytesToWord(this.protocol.buffin, 13));
                    this.tagNumHigh2.setReadValInt(Numbers.bytesToWord(this.protocol.buffin, 15));
                    this.tagNumLow2.setReadValInt(Numbers.bytesToWord(this.protocol.buffin, 17));
                }
            }
            catch (Exception e) {
                this.env.printError(this.logger, e, this.name);
                result = false;
            }
        }
        this.tagWeightKg1.setInt(Math.round((((long)this.tagWeightHigh1.getInt() << 16) + (long)this.tagWeightLow1.getInt()) / 1000L));
        this.tagWeightKg2.setInt(Math.round((((long)this.tagWeightHigh2.getInt() << 16) + (long)this.tagWeightLow2.getInt()) / 1000L));
        this.wesSvrStateTimer = PaGeliosMaslo2v2Module.updateWesSvrState(this.tagWesSvrState, this.wesSvrStateTimer);
        return result;
    }
}

