/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import java.util.ArrayList;
import java.util.List;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Input;
import promauto.jroboplc.plugin.roboplant.Output;

public class DeviceSTGA
extends Device {
    private static final int FLAG_SINGLE = 1;
    private static final int FLAG_TRIGGER = 2;
    protected List<Group> groups = new ArrayList<Group>();
    Input inpInput;
    Input inpReset;
    Tag tagStage;
    Tag tagCycleCnt;
    Tag tagCycleMax;
    Tag tagStageStart;
    Tag tagStageLoop;
    Tag tagFlags;

    @Override
    public void prepareTags(Device.RefBool res) {
        this.inpInput = this.getInput("Input", res);
        this.inpReset = this.getInput("Reset", res);
        this.tagStage = this.getOutputTag("Stage", res);
        this.tagCycleCnt = this.getOutputTag("CycleCnt", res);
        this.tagCycleMax = this.getOutputTag("CycleMax", res);
        this.tagStageStart = this.getOutputTag("StageStart", res);
        this.tagStageLoop = this.getOutputTag("StageLoop", res);
        this.tagFlags = this.getOutputTag("Flags", res);
        this.groups.clear();
        int i = 1;
        while (true) {
            Group gr = new Group();
            gr.inpNext = this.getInput("Next" + i);
            Output output = this.getOutput("Output" + i);
            if (gr.inpNext == null || output == null) break;
            gr.tagOutput = output.tag;
            this.groups.add(gr);
            ++i;
        }
    }

    @Override
    public boolean execute() {
        int stage = this.tagStage.getInt();
        if (this.inpReset.getInt() > 0 || this.groups.size() == 0 || stage < 0 || stage > this.groups.size()) {
            stage = 0;
            this.tagCycleCnt.setInt(0);
        } else if (stage == 0) {
            if (this.inpInput.getInt() > 0 && this.canStartCycle()) {
                stage = Math.max(this.tagStageStart.getInt(), 1);
            }
        } else {
            Group gr = this.groups.get(stage - 1);
            if ((this.tagFlags.getInt() & 1) > 0) {
                if (stage == this.groups.size() && gr.inpNext.getInt() > 0) {
                    this.tagCycleCnt.setInt(1);
                }
                if (stage < this.groups.size()) {
                    stage += gr.inpNext.getInt();
                }
                if (stage > this.groups.size()) {
                    stage = this.groups.size();
                }
            } else if ((stage += gr.inpNext.getInt()) > this.groups.size()) {
                this.tagCycleCnt.setInt(this.tagCycleCnt.getInt() + 1);
                stage = this.inpInput.getInt() > 0 && this.canStartCycle() ? Math.max(this.tagStageLoop.getInt(), 1) : 0;
            } else if (stage < 0) {
                stage = 0;
            }
        }
        int curidx = stage - 1;
        if ((this.tagFlags.getInt() & 2) > 0) {
            for (int i = 0; i < this.groups.size(); ++i) {
                this.groups.get((int)i).tagOutput.setBool(i <= curidx);
            }
        } else {
            for (int i = 0; i < this.groups.size(); ++i) {
                this.groups.get((int)i).tagOutput.setBool(i == curidx);
            }
        }
        this.tagStage.setInt(stage);
        return true;
    }

    private boolean canStartCycle() {
        return this.tagCycleMax.getInt() <= 0 || this.tagCycleCnt.getInt() < this.tagCycleMax.getInt();
    }

    protected static class Group {
        Input inpNext;
        Tag tagOutput;

        protected Group() {
        }
    }
}

