/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.wessvr;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.RefGroup;
import promauto.jroboplc.core.tags.RefItem;
import promauto.jroboplc.plugin.wessvr.ArchiveBase;
import promauto.jroboplc.plugin.wessvr.ArchiveConfig;
import promauto.jroboplc.plugin.wessvr.Device;
import promauto.jroboplc.plugin.wessvr.Shiftset;
import promauto.jroboplc.plugin.wessvr.WessvrModule;

public abstract class DeviceBase
implements Device {
    private final Logger logger = LoggerFactory.getLogger(DeviceBase.class);
    private static final int CRC_ERROR_CNT_MAX = 10;
    private static final int STATE_DISABLED = 100;
    private static final int STATE_START = 99;
    private static final int STATE_OK = 0;
    private static final int STATE_ERROR_CONNECT = 1;
    private static final int STATE_ERROR_CRC = 2;
    private static final int STATE_ERROR_VALID = 3;
    private static final int STATE_ERROR_LINK = 4;
    protected final WessvrModule module;
    protected Shiftset shiftset;
    protected final RefGroup refs = EnvironmentInst.get().getRefFactory().createRefGroup();
    protected RefItem refErrorFlag;
    protected RefItem refUpdateTime;
    protected RefItem refWesSvrState;
    private RefItem refSN;
    private RefItem refReplacement;
    protected List<RefItem> vldZero = new ArrayList<RefItem>();
    protected List<RefItem> vldFFFF = new ArrayList<RefItem>();
    protected Tag tagState;
    protected Tag tagDescr;
    protected int idm;
    protected int idsl;
    protected String name;
    protected String descr;
    protected boolean enable;
    protected int arcvalSize;
    protected int arcoutSize;
    protected int arcoutPer;
    protected int arcoutTime;
    protected int arcvalIdr = 0;
    protected int arcoutIdr = 0;
    protected int statusIdr = 0;
    protected LocalDateTime statidleDt;
    protected int statidleTimeSec;
    protected double wmul;
    protected int protocolVersion;
    protected int arcStatusOff;
    protected int outCalcMode;
    protected int wesIncMax;
    protected long sizeSumWeight;
    protected long sizeSumNum;
    protected String serialNumber = "";
    protected boolean replaced = false;
    private List<ArchiveBase> archives = null;
    protected int[] statusValues = new int[5];
    protected long[] arcvalValues = new long[5];
    private Queue<Double> arcoutAvgQueue;
    private int arcoutAvgQueueSize;
    private SortedSet<ArcoutCalcRec> arcoutCalcQueue;
    private long arcoutLastWeight = -1L;
    private long arcoutLastMs = 0L;
    private boolean firstPass = true;
    private int crcErrorCnt = 0;

    public DeviceBase(WessvrModule module) {
        this.module = module;
        this.sizeSumWeight = 0x100000000L;
        this.sizeSumNum = 0x100000000L;
    }

    @Override
    public boolean load(ResultSet rs) throws SQLException {
        this.idm = rs.getInt("IDM");
        this.enable = rs.getBoolean("ENABLED");
        this.name = rs.getString("NAME");
        this.descr = rs.getString("DESCR");
        this.idsl = rs.getInt("IDSL");
        this.arcvalSize = rs.getInt("ARCVALSIZE");
        this.arcoutSize = rs.getInt("ARCOUTSIZE");
        this.arcoutPer = rs.getInt("ARCOUTPER") * 1000;
        this.arcoutTime = rs.getInt("ARCOUTTIME") * 1000;
        this.statidleTimeSec = rs.getInt("TIMEIDLE");
        this.wmul = rs.getInt("WMUL");
        this.protocolVersion = rs.getInt("PROTOCOLVERSION");
        this.arcStatusOff = rs.getInt("ARCSTATUS_OFF");
        this.outCalcMode = rs.getInt("OUTCALCMODE");
        this.wesIncMax = rs.getInt("WESINCMAX");
        this.serialNumber = rs.getString("SN");
        return true;
    }

    @Override
    public boolean isEnable() {
        return this.enable;
    }

    @Override
    public String getInfo() {
        return (this.tagState.getInt() <= 0 ? "" : "\u001b[31m\u001b[01m" + this.getStateAsString() + "\u001b[0m" + " ") + this.idm + " " + this.getModtype() + "/" + this.name + ", " + this.descr + (this.tagState.getInt() != 0 ? "" : ", w=" + this.getSumWeight() + ", n=" + this.getSumNum());
    }

    private String getStateAsString() {
        switch (this.tagState.getInt()) {
            case 100: {
                return "DISABLED";
            }
            case 99: {
                return "START";
            }
            case 0: {
                return "OK";
            }
            case 1: {
                return "CONNECTION ERROR";
            }
            case 2: {
                return "CRC ERROR";
            }
            case 3: {
                return "DATA IS NOT VALID";
            }
            case 4: {
                return "NOT LINKED";
            }
        }
        return "";
    }

    protected Tag getOrCreateTag(Tag.Type type, String tagname) {
        tagname = this.name + '.' + tagname;
        Tag tag = this.module.getTagTable().get(tagname);
        if (tag == null) {
            tag = this.module.getTagTable().createTag(type, tagname, 0);
        }
        return tag;
    }

    @Override
    public boolean init() throws SQLException {
        EnvironmentInst.get().printInfo(this.logger, this.module.getName(), "\u001b[32m\u001b[01minit:", this.idm + " " + this.name + "\u001b[0m");
        this.shiftset = this.module.getShiftsets().getShiftset(this.idsl);
        this.createTags();
        this.createRefs();
        this.refs.prepare();
        this.archives = this.module.getArchiveConfig().items.stream().map(item -> new ArchiveBase(this, (ArchiveConfig.Item)item)).collect(Collectors.toList());
        if (this.enable) {
            this.arcvalIdr = this.selectMaxIdr("arcval");
            this.arcoutIdr = this.selectMaxIdr("arcout");
            this.statusIdr = this.selectMaxIdr("arcstatus");
            this.statidleDt = this.selectDtByIdr("arcval", this.arcvalIdr);
            this.applyState(99);
            if (this.outCalcMode == 0) {
                this.arcoutAvgQueueSize = this.arcoutPer <= 0 || this.arcoutTime < this.arcoutPer ? 1 : this.arcoutTime / this.arcoutPer;
                this.arcoutAvgQueue = new LinkedList<Double>();
            } else {
                this.initArcoutCalcQueue();
            }
        } else {
            this.tagState.setInt(100);
        }
        return true;
    }

    private int selectMaxIdr(String table) throws SQLException {
        String sql = String.format("select max(idr) from %s where idm=%d", this.module.makeTableName(table), this.idm);
        try (ResultSet rs = this.module.executeQuery(sql);){
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        return 0;
    }

    private LocalDateTime selectDtByIdr(String table, int idr) throws SQLException {
        String sql = String.format("select dt from %s where idr=%d and idm=%d", this.module.makeTableName(table), idr, this.idm);
        try (ResultSet rs = this.module.executeQuery(sql);){
            if (rs.next()) {
                LocalDateTime localDateTime = rs.getTimestamp(1).toLocalDateTime();
                return localDateTime;
            }
        }
        return LocalDateTime.now();
    }

    private void createTags() {
        this.tagState = this.getOrCreateTag(Tag.Type.INT, "state");
        this.tagDescr = this.getOrCreateTag(Tag.Type.STRING, "descr");
        this.tagDescr.setString(this.descr);
    }

    protected void createRefs() {
        this.refErrorFlag = this.refs.createItem(this.name, "SYSTEM.ErrorFlag");
        this.refUpdateTime = this.refs.createItem(this.name, "SYSTEM.UpdateTime");
        this.refSN = this.refs.createItem(this.name, "SYSTEM.SN");
        this.refReplacement = this.refs.createItem(this.name, "Replacement");
        this.refWesSvrState = this.refs.createItem(this.name, "WesSvrState");
        this.refReplacement.setOptional(true);
        this.refSN.setOptional(true);
    }

    protected boolean checkCrc() {
        return this.refs.checkCrc16();
    }

    protected boolean linkRefs() {
        return this.refs.link();
    }

    @Override
    public void execute() throws SQLException {
        if (!this.linkRefs()) {
            this.applyState(4);
        } else {
            this.refs.read();
            this.doAfterRefsRead();
            if (this.refErrorFlag.getValue().getBool()) {
                this.applyState(1);
                this.archives.forEach(ArchiveBase::onConnectError);
            } else if (!this.checkCrc()) {
                this.applyState(2);
            } else if (!this.isRefDataValid()) {
                this.applyState(3);
            } else {
                this.applyState(0);
                this.replaced = this.checkAndUpdateSN() || this.isReplacement();
                for (ArchiveBase archive : this.archives) {
                    archive.execute();
                }
                if (this.firstPass) {
                    this.firstPass = false;
                    this.updateValuesStatus();
                    this.updateValuesArcval();
                }
                this.executeArcVal();
                this.executeArcOut();
                this.executeArcStatus();
            }
            this.updateWesSvrState();
        }
    }

    public boolean isReplaced() {
        return this.replaced;
    }

    private boolean checkAndUpdateSN() throws SQLException {
        if (!this.refSN.isLinked() || this.refSN.getValue().getString().equals(this.serialNumber)) {
            return false;
        }
        this.serialNumber = this.refSN.getValue().getString();
        String sql = String.format("update %s set SN='%s' where idm=%d", this.module.makeTableName("modules"), this.serialNumber, this.idm);
        this.module.executeUpdate(sql);
        return true;
    }

    private boolean isReplacement() {
        return this.refReplacement.isLinked() && this.refReplacement.getValue().getBool();
    }

    protected void updateWesSvrState() {
        if (this.module.isWesSvrStateEnabled()) {
            if (this.refWesSvrState.getTag().getInt() < 4) {
                this.refWesSvrState.getTag().setInt(4);
            } else {
                this.refWesSvrState.getTag().setInt(2);
            }
        }
    }

    RefItem addVldZero(RefItem item) {
        this.vldZero.add(item);
        return item;
    }

    RefItem addVldFFFF(RefItem item) {
        this.vldFFFF.add(item);
        return item;
    }

    private boolean validateZero() {
        return this.vldZero.size() == 0 || !this.vldZero.stream().allMatch(a -> a.getValue().getInt() == 0);
    }

    private boolean validateFFFF() {
        return this.vldFFFF.size() == 0 || !this.vldFFFF.stream().allMatch(a -> a.getValue().getInt() == 65535);
    }

    private boolean isRefDataValid() {
        return this.validateZero() && this.validateFFFF();
    }

    protected long getSumWeight() {
        return 0L;
    }

    protected long getSumNum() {
        return 0L;
    }

    private void applyState(int state) throws SQLException {
        if (state != this.tagState.getInt()) {
            if (state == 2) {
                if (this.crcErrorCnt < 10) {
                    ++this.crcErrorCnt;
                    return;
                }
            } else {
                this.crcErrorCnt = 0;
            }
            this.tagState.setInt(state);
            this.deleteByIdr("arcstatus", ++this.statusIdr, this.arcvalSize);
            String sql = String.format("insert into %s (idr, idm, dt, noconnect, nodata, status1, status2,status3, status4, status5) values (%d, %d, '%s', %d, %d, null, null, null, null, null)", this.module.makeTableName("arcstatus"), this.statusIdr, this.idm, LocalDateTime.now().format(this.module.getDatabase().getTimestampFormatter()), this.refErrorFlag.getValue() == null ? 0 : this.refErrorFlag.getValue().getInt(), state);
            this.module.executeUpdate(sql);
        }
    }

    private void executeArcStatus() throws SQLException {
        if (!this.updateValuesStatus()) {
            return;
        }
        this.deleteByIdr("arcstatus", ++this.statusIdr, this.arcvalSize);
        String sql = String.format("insert into %s (idr, idm, dt, noconnect, nodata, status1, status2, status3, status4, status5) values (%d, %d, '%s', %d, %d, %d, %d, %d, %d, %d)", this.module.makeTableName("arcstatus"), this.statusIdr, this.idm, this.refs.getDtRead().format(this.module.getDatabase().getTimestampFormatter()), this.refErrorFlag.getValue().getInt(), this.tagState.getInt(), this.statusValues[0], this.statusValues[1], this.statusValues[2], this.statusValues[3], this.statusValues[4]);
        this.module.executeUpdate(sql);
    }

    private void deleteByIdr(String table, int idr, int size) throws SQLException {
        String sql = String.format("delete from %s where idr<%d and idm=%d", this.module.makeTableName(table), idr - size, this.idm);
        this.module.executeUpdate(sql);
    }

    private void executeArcVal() throws SQLException {
        if (!this.updateValuesArcval()) {
            return;
        }
        this.deleteByIdr("arcval", ++this.arcvalIdr, this.arcvalSize);
        String sql = String.format("update or insert into %s (idr, idm, dt, sumwes, wnum, lastwes, wcycle, errcode) values (%d, %d, '%s', %d, %d, %d, %d, %d)", this.module.makeTableName("arcval"), this.arcvalIdr, this.idm, this.refs.getDtRead().format(this.module.getDatabase().getTimestampFormatter()), this.arcvalValues[0], this.arcvalValues[1], this.arcvalValues[2], this.arcvalValues[3], this.arcvalValues[4]);
        this.module.executeUpdate(sql);
        this.executeStatIdle();
    }

    private void executeStatIdle() throws SQLException {
        if (this.statidleTimeSec <= 0) {
            return;
        }
        int seconds = (int)this.statidleDt.until(this.refs.getDtRead(), ChronoUnit.SECONDS);
        if (seconds > this.statidleTimeSec) {
            String sql = String.format("insert into %s (idm, dtbeg, dtend, seconds) values (%d, '%s', '%s', %d)", this.module.makeTableName("statidle"), this.idm, this.statidleDt.format(this.module.getDatabase().getTimestampFormatter()), this.refs.getDtRead().format(this.module.getDatabase().getTimestampFormatter()), seconds);
            this.module.executeUpdate(sql);
        }
        this.statidleDt = this.refs.getDtRead();
    }

    boolean hasStatusValuesChanged(RefItem ... items) {
        int mask = 1;
        int n = Math.min(items.length, this.statusValues.length);
        for (int i = 0; i < n; ++i) {
            if ((this.arcStatusOff & mask) == 0 && items[i] != null && items[i].getTag().getInt() != this.statusValues[i]) {
                return true;
            }
            mask <<= 1;
        }
        return false;
    }

    private void executeArcOut() throws SQLException {
        long t;
        if (this.outCalcMode != 0) {
            this.updateArcoutCalcValue();
        }
        if ((t = System.currentTimeMillis()) - this.arcoutLastMs < (long)this.arcoutPer) {
            return;
        }
        this.arcoutLastMs = t;
        double arcoutAvgValue = 0.0;
        arcoutAvgValue = this.outCalcMode == 0 ? this.getArcoutAvgValue() : this.getArcoutCalcValue();
        this.deleteByIdr("arcout", ++this.arcoutIdr, this.arcoutSize);
        String sql = String.format(Locale.ROOT, "insert into %s (idr, idm, dt, outwes ) values (%d, %d, '%s', %f )", this.module.makeTableName("arcout"), this.arcoutIdr, this.idm, this.refs.getDtRead().format(this.module.getDatabase().getTimestampFormatter()), arcoutAvgValue);
        this.module.executeUpdate(sql);
    }

    private double getArcoutAvgValue() {
        double arcoutValue = this.getArcoutValue();
        if (arcoutValue <= 0.001) {
            this.arcoutAvgQueue.clear();
            return 0.0;
        }
        this.arcoutAvgQueue.add(arcoutValue);
        while (this.arcoutAvgQueue.size() > this.arcoutAvgQueueSize) {
            this.arcoutAvgQueue.poll();
        }
        return this.arcoutAvgQueue.stream().mapToDouble(a -> a).average().getAsDouble();
    }

    private void updateArcoutCalcValue() {
        long curtimems = System.currentTimeMillis();
        while (this.arcoutCalcQueue.size() > 0 && curtimems - this.arcoutCalcQueue.first().timems > (long)this.arcoutTime) {
            this.arcoutCalcQueue.remove(this.arcoutCalcQueue.first());
        }
        while (this.arcoutCalcQueue.size() > 0 && curtimems <= this.arcoutCalcQueue.last().timems) {
            this.arcoutCalcQueue.remove(this.arcoutCalcQueue.last());
        }
        if (this.arcoutLastWeight < 0L) {
            this.arcoutLastWeight = this.getSumWeight();
        }
        if (this.arcoutLastWeight != this.getSumWeight()) {
            this.arcoutLastWeight = this.getSumWeight();
            this.arcoutCalcQueue.add(new ArcoutCalcRec(curtimems, this.arcoutLastWeight));
        }
    }

    private double getArcoutCalcValue() {
        if (this.arcoutCalcQueue.size() == 0) {
            return 0.0;
        }
        long weight = this.arcoutCalcQueue.last().weight - this.arcoutCalcQueue.first().weight;
        if (weight < 0L) {
            weight = this.sizeSumWeight - this.arcoutCalcQueue.first().weight + this.arcoutCalcQueue.last().weight;
        }
        long time = this.arcoutCalcQueue.last().timems - this.arcoutCalcQueue.first().timems;
        long avgDoseTime = time / (long)this.arcoutCalcQueue.size();
        long timeSinceLastDosing = System.currentTimeMillis() - this.arcoutCalcQueue.last().timems;
        if (avgDoseTime > 0L && timeSinceLastDosing / avgDoseTime >= 3L) {
            return 0.0;
        }
        double output = time > 1L ? 3600000.0 * (double)weight / (double)time : 0.0;
        return output;
    }

    private void initArcoutCalcQueue() throws SQLException {
        this.arcoutCalcQueue = new TreeSet<ArcoutCalcRec>();
        LocalDateTime dt = LocalDateTime.now();
        long curtimems = System.currentTimeMillis();
        LocalDateTime dtbeg = dt.minusSeconds(this.arcoutTime / 1000);
        String sql = String.format("select dt, sumwes from %s where idm=%d and dt>'%s' and dt<'%s' order by dt", this.module.makeTableName("arcval"), this.idm, dtbeg.format(this.module.getDatabase().getTimestampFormatter()), dt.format(this.module.getDatabase().getTimestampFormatter()));
        try (ResultSet rs = this.module.executeQuery(sql);){
            while (rs.next()) {
                long time = curtimems - ChronoUnit.MILLIS.between(rs.getTimestamp(1).toLocalDateTime(), dt);
                long weight = rs.getLong(2);
                this.arcoutCalcQueue.add(new ArcoutCalcRec(time, weight));
            }
        }
    }

    protected boolean updateValuesStatus() {
        return false;
    }

    protected boolean updateValuesArcval() {
        return false;
    }

    protected double getArcoutValue() {
        return 0.0;
    }

    protected void doAfterRefsRead() {
    }

    private static final class ArcoutCalcRec
    implements Comparable<ArcoutCalcRec> {
        long timems;
        long weight;

        public ArcoutCalcRec(long timems, long weight) {
            this.timems = timems;
            this.weight = weight;
        }

        @Override
        public int compareTo(ArcoutCalcRec o) {
            return Long.compare(this.timems, o.timems);
        }
    }
}

