/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.ng.CursorFlag;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.FetchDirection;
import org.firebirdsql.gds.ng.FetchType;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.listeners.StatementListener;
import org.firebirdsql.jdbc.CompletionReason;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBFetcher;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBSQLException;

final class FBServerScrollFetcher
implements FBFetcher {
    private static final int CURSOR_SIZE_UNKNOWN = -1;
    private final FbStatement stmt;
    private final int maxRows;
    private FBObjectListener.FetcherListener fetcherListener;
    private int fetchSize;
    private boolean closed;
    private int cursorSize = -1;
    private int serverCursorSize = -1;
    private int serverPosition;
    private int localPosition;
    private List<RowValue> rows = new ArrayList<RowValue>();
    private int rowsOffset;

    FBServerScrollFetcher(int initialFetchSize, int maxRows, FbStatement stmt, FBObjectListener.FetcherListener fetcherListener) throws SQLException {
        if (!stmt.supportsFetchScroll()) {
            throw new FBDriverNotCapableException("Statement implementation does not support server-side scrollable result sets; this exception indicates a bug in Jaybird");
        }
        if (!stmt.isCursorFlagSet(CursorFlag.CURSOR_TYPE_SCROLLABLE)) {
            throw new FBDriverNotCapableException("Statement does not have CURSOR_TYPE_SCROLLABLE; this exception indicates a bug in Jaybird");
        }
        this.fetchSize = initialFetchSize;
        this.maxRows = maxRows;
        this.stmt = stmt;
        this.fetcherListener = fetcherListener;
    }

    private boolean inWindow(int position) throws SQLException {
        int windowSize = this.rows.size();
        int rowsOffset = this.rowsOffset;
        if (windowSize == 0 || rowsOffset == 0 || this.maxRows != 0 && position > this.requireCursorSize()) {
            return false;
        }
        return rowsOffset <= position && position < rowsOffset + windowSize;
    }

    private RowValue rowChange(int newLocalPosition) throws SQLException {
        this.localPosition = newLocalPosition;
        return this.inWindow(newLocalPosition) ? this.rows.get(newLocalPosition - this.rowsOffset) : null;
    }

    private boolean notifyRowChange(int newLocalPosition) throws SQLException {
        return this.notifyRow(this.rowChange(newLocalPosition));
    }

    private boolean notifyRow(RowValue rowValue) throws SQLException {
        this.fetcherListener.rowChanged(this, rowValue);
        return rowValue != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RowListener fetchWithListener(FetchType fetchType, int fetchSize, int position) throws SQLException {
        RowListener rowListener = new RowListener();
        this.stmt.addStatementListener(rowListener);
        try {
            this.stmt.fetchScroll(fetchType, fetchSize, position);
        }
        finally {
            this.stmt.removeStatementListener(rowListener);
        }
        return rowListener;
    }

    private void updateWindow(RowListener listener, ServerPositionCalculation serverPositionCalculation, FetchDirection fetchDirection) throws SQLException {
        this.rows.clear();
        List<RowValue> newRows = listener.rowValues;
        int rowCount = newRows.size();
        int serverPosition = this.serverPosition = serverPositionCalculation.newServerPosition(rowCount, listener);
        if (rowCount == 0) {
            this.rowsOffset = 0;
        } else {
            ArrayList rows = (ArrayList)this.rows;
            rows.ensureCapacity(rowCount);
            if (fetchDirection == FetchDirection.REVERSE) {
                if (rowCount == 1) {
                    rows.add(newRows.get(0));
                } else {
                    ListIterator<RowValue> iter = newRows.listIterator(rowCount);
                    while (iter.hasPrevious()) {
                        rows.add(iter.previous());
                    }
                }
                this.rowsOffset = listener.beforeFirst ? 1 : serverPosition;
            } else {
                rows.addAll(newRows);
                this.rowsOffset = serverPosition - rowCount + (listener.afterLast ? 0 : 1);
            }
        }
    }

    private void synchronizeServerPosition(int expectedPosition) throws SQLException {
        if (this.serverPosition != expectedPosition) {
            this.stmt.fetchScroll(FetchType.ABSOLUTE, -1, expectedPosition);
            this.serverPosition = expectedPosition;
        }
    }

    @Override
    public boolean first() throws SQLException {
        try (LockCloseable ignored = this.stmt.withLock();){
            this.checkOpen();
            int newLocalPosition = 1;
            if (!this.inWindow(newLocalPosition) && this.cursorSize != 0) {
                RowListener listener = this.fetchWithListener(FetchType.FIRST, -1, -1);
                this.updateWindow(listener, (r, l) -> 1, FetchDirection.UNKNOWN);
                if (listener.afterLast) {
                    this.cursorSize = 0;
                }
            }
            boolean bl = this.notifyRowChange(newLocalPosition);
            return bl;
        }
    }

    @Override
    public boolean last() throws SQLException {
        try (LockCloseable ignored = this.stmt.withLock();){
            int newLocalPosition;
            this.checkOpen();
            int cursorSize = this.cursorSize;
            if (cursorSize == 0) {
                newLocalPosition = 1;
            } else if (this.inWindow(cursorSize)) {
                newLocalPosition = cursorSize;
            } else {
                RowListener listener = this.maxRows != 0 && (cursorSize = this.requireCursorSize()) < this.requireServerCursorSize() ? this.fetchWithListener(FetchType.ABSOLUTE, -1, cursorSize) : this.fetchWithListener(FetchType.LAST, -1, -1);
                this.updateWindow(listener, this.lastServerPosition(), FetchDirection.UNKNOWN);
                newLocalPosition = this.serverPosition;
            }
            boolean bl = this.notifyRowChange(newLocalPosition);
            return bl;
        }
    }

    private ServerPositionCalculation lastServerPosition() {
        return (rowCount, listener) -> rowCount == 0 ? 1 : this.requireCursorSize();
    }

    @Override
    public boolean previous() throws SQLException {
        try (LockCloseable ignored = this.stmt.withLock();){
            this.checkOpen();
            int oldLocalPosition = this.localPosition;
            int newLocalPosition = Math.max(1, oldLocalPosition) - 1;
            if (!this.inWindow(newLocalPosition)) {
                this.synchronizeServerPosition(oldLocalPosition);
                RowListener listener = this.fetchWithListener(FetchType.PRIOR, this.actualFetchSize(), -1);
                this.updateWindow(listener, this.previousServerPosition(oldLocalPosition), FetchDirection.REVERSE);
                if (listener.beforeFirst) {
                    this.serverPosition = 0;
                }
            }
            boolean bl = this.notifyRowChange(newLocalPosition);
            return bl;
        }
    }

    private ServerPositionCalculation previousServerPosition(int initialServerPosition) {
        return (rowCount, listener) -> listener.beforeFirst ? 0 : initialServerPosition - rowCount;
    }

    @Override
    public boolean next() throws SQLException {
        try (LockCloseable ignored = this.stmt.withLock();){
            this.checkOpen();
            int oldLocalPosition = this.localPosition;
            boolean hasMaxRows = this.maxRows > 0;
            int cursorSize = hasMaxRows && oldLocalPosition != 0 ? this.requireCursorSize() : this.cursorSize;
            int newLocalPosition = (cursorSize != -1 ? Math.min(cursorSize, oldLocalPosition) : oldLocalPosition) + 1;
            if (!this.inWindow(newLocalPosition)) {
                int fetchSize = this.actualFetchSize();
                if (hasMaxRows) {
                    fetchSize = cursorSize == -1 ? Math.min(fetchSize, this.maxRows) : Math.min(fetchSize, cursorSize + 1 - oldLocalPosition);
                }
                if (fetchSize == 0) {
                    this.afterLast();
                    boolean bl = false;
                    return bl;
                }
                this.synchronizeServerPosition(oldLocalPosition);
                RowListener listener = this.fetchWithListener(FetchType.NEXT, fetchSize, -1);
                this.updateWindow(listener, this.nextServerPosition(oldLocalPosition), FetchDirection.FORWARD);
            }
            boolean bl = this.notifyRowChange(newLocalPosition);
            return bl;
        }
    }

    private ServerPositionCalculation nextServerPosition(int initialServerPosition) {
        return (rowCount, listener) -> listener.afterLast ? this.requireCursorSize() + 1 : initialServerPosition + rowCount;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        try (LockCloseable ignored = this.stmt.withLock();){
            int newLocalPosition;
            this.checkOpen();
            int n = newLocalPosition = row >= 0 ? row : Math.max(0, this.requireCursorSize() + 1 + row);
            if (!this.inWindow(row)) {
                if (this.maxRows != 0 && newLocalPosition > this.requireCursorSize()) {
                    this.afterLast();
                    boolean bl = false;
                    return bl;
                }
                RowListener listener = this.fetchWithListener(FetchType.ABSOLUTE, -1, newLocalPosition);
                FetchDirection fetchDirection = row < 0 ? FetchDirection.REVERSE : FetchDirection.FORWARD;
                this.updateWindow(listener, this.absoluteServerPosition(row), fetchDirection);
                newLocalPosition = this.serverPosition;
            }
            boolean bl = this.notifyRowChange(newLocalPosition);
            return bl;
        }
    }

    private ServerPositionCalculation absoluteServerPosition(int absoluteRow) {
        return (rowCount, listener) -> {
            if (listener.beforeFirst) {
                return 0;
            }
            if (listener.afterLast) {
                return this.requireCursorSize() + 1;
            }
            if (absoluteRow >= 0) {
                return absoluteRow;
            }
            return this.requireCursorSize() + absoluteRow + 1;
        };
    }

    @Override
    public boolean relative(int row) throws SQLException {
        try (LockCloseable ignored = this.stmt.withLock();){
            this.checkOpen();
            int oldLocalPosition = this.localPosition;
            int newLocalPosition = Math.max(0, oldLocalPosition + row);
            if (row != 0 && !this.inWindow(newLocalPosition)) {
                if (this.maxRows != 0 && newLocalPosition > this.requireCursorSize()) {
                    this.afterLast();
                    boolean bl = false;
                    return bl;
                }
                this.synchronizeServerPosition(oldLocalPosition);
                RowListener listener = this.fetchWithListener(FetchType.RELATIVE, -1, row);
                FetchDirection fetchDirection = row < 0 ? FetchDirection.REVERSE : FetchDirection.FORWARD;
                this.updateWindow(listener, this.relativeServerPosition(row), fetchDirection);
                newLocalPosition = this.serverPosition;
            }
            boolean bl = this.notifyRowChange(newLocalPosition);
            return bl;
        }
    }

    private ServerPositionCalculation relativeServerPosition(int relativeRow) {
        return (rowCount, listener) -> {
            if (listener.beforeFirst) {
                return 0;
            }
            if (listener.afterLast) {
                return this.requireCursorSize() + 1;
            }
            assert (rowCount == 1) : "expected rowCount == 1, was " + rowCount;
            return this.serverPosition + relativeRow;
        };
    }

    @Override
    public void beforeFirst() throws SQLException {
        try (LockCloseable ignored = this.stmt.withLock();){
            this.checkOpen();
            if (this.localPosition != 0) {
                this.stmt.fetchScroll(FetchType.ABSOLUTE, -1, 0);
                this.serverPosition = 0;
            }
            this.notifyRowChange(0);
        }
    }

    @Override
    public void afterLast() throws SQLException {
        try (LockCloseable ignored = this.stmt.withLock();){
            this.checkOpen();
            int afterLastPosition = this.requireCursorSize() + 1;
            if (this.localPosition != afterLastPosition) {
                this.stmt.fetchScroll(FetchType.ABSOLUTE, -1, afterLastPosition);
                this.serverPosition = afterLastPosition;
            }
            this.notifyRowChange(afterLastPosition);
        }
    }

    @Override
    public void close() throws SQLException {
        this.close(CompletionReason.OTHER);
    }

    @Override
    public void close(CompletionReason completionReason) throws SQLException {
        this.closed = true;
        try {
            this.stmt.closeCursor(completionReason.isTransactionEnd() || completionReason.isCompletesStatement());
        }
        finally {
            this.rows.clear();
            this.rowsOffset = 0;
            this.rows = Collections.emptyList();
            this.fetcherListener.fetcherClosed(this);
        }
    }

    private void checkOpen() throws SQLException {
        if (this.closed) {
            throw new FBSQLException("Result set is already closed.");
        }
    }

    @Override
    public int getRowNum() throws SQLException {
        try (LockCloseable ignored = this.stmt.withLock();){
            int n = this.isAfterLast() ? 0 : this.localPosition;
            return n;
        }
    }

    @Override
    public boolean isEmpty() throws SQLException {
        try (LockCloseable ignored = this.stmt.withLock();){
            int cursorSize = this.requireCursorSize();
            boolean bl = cursorSize == 0;
            return bl;
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        try (LockCloseable ignored = this.stmt.withLock();){
            this.checkOpen();
            boolean bl = this.localPosition == 0;
            return bl;
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        try (LockCloseable ignored = this.stmt.withLock();){
            this.checkOpen();
            boolean bl = this.localPosition == 1 && this.requireCursorSize() > 0;
            return bl;
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        try (LockCloseable ignored = this.stmt.withLock();){
            int cursorSize = this.requireCursorSize();
            boolean bl = this.localPosition == cursorSize && cursorSize > 0;
            return bl;
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        try (LockCloseable ignored = this.stmt.withLock();){
            if (this.localPosition == 0) {
                boolean bl = false;
                return bl;
            }
            int cursorSize = this.requireCursorSize();
            boolean bl = this.localPosition > cursorSize;
            return bl;
        }
    }

    @Override
    public void insertRow(RowValue data) throws SQLException {
        throw new UnsupportedOperationException("Implementation error: FBServerScrollFetcher should be decorated with FBUpdatableFetcher");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException("Implementation error: FBServerScrollFetcher should be decorated with FBUpdatableFetcher");
    }

    @Override
    public void updateRow(RowValue data) throws SQLException {
        throw new UnsupportedOperationException("Implementation error: FBServerScrollFetcher should be decorated with FBUpdatableFetcher");
    }

    private int actualFetchSize() {
        return this.fetchSize > 0 ? this.fetchSize : 400;
    }

    @Override
    public int getFetchSize() throws SQLException {
        try (LockCloseable ignored = this.stmt.withLock();){
            this.checkOpen();
            int n = this.fetchSize;
            return n;
        }
    }

    @Override
    public void setFetchSize(int fetchSize) {
        try (LockCloseable ignored = this.stmt.withLock();){
            this.fetchSize = fetchSize;
        }
    }

    @Override
    public int currentPosition() {
        return this.localPosition;
    }

    @Override
    public int size() throws SQLException {
        return this.requireCursorSize();
    }

    @Override
    public void setFetcherListener(FBObjectListener.FetcherListener fetcherListener) {
        this.fetcherListener = fetcherListener;
    }

    private int retrieveServerCursorSize() throws SQLException {
        return this.stmt.getCursorInfo(new byte[]{10, 1}, 10, buffer -> {
            if (buffer[0] != 10) {
                throw FbExceptionBuilder.forException(337248307).messageParameter("cursor").toSQLException();
            }
            int length = VaxEncoding.iscVaxInteger2(buffer, 1);
            return VaxEncoding.iscVaxInteger(buffer, 3, length);
        });
    }

    private int requireCursorSize() throws SQLException {
        this.checkOpen();
        int cursorSize = this.cursorSize;
        if (cursorSize == -1) {
            int serverCursorSize = this.requireServerCursorSize();
            this.cursorSize = this.maxRows == 0 ? serverCursorSize : Math.min(this.maxRows, serverCursorSize);
            cursorSize = this.cursorSize;
        }
        return cursorSize;
    }

    private int requireServerCursorSize() throws SQLException {
        int serverCursorSize = this.serverCursorSize;
        if (serverCursorSize == -1) {
            if (!this.stmt.hasFetched()) {
                this.stmt.fetchScroll(FetchType.RELATIVE, -1, 0);
            }
            serverCursorSize = this.serverCursorSize = this.retrieveServerCursorSize();
        }
        return serverCursorSize;
    }

    @FunctionalInterface
    private static interface ServerPositionCalculation {
        public int newServerPosition(int var1, RowListener var2) throws SQLException;
    }

    private static final class RowListener
    implements StatementListener {
        boolean beforeFirst;
        boolean afterLast;
        final List<RowValue> rowValues = new ArrayList<RowValue>();

        private RowListener() {
        }

        @Override
        public void beforeFirst(FbStatement sender) {
            this.beforeFirst = true;
        }

        @Override
        public void afterLast(FbStatement sender) {
            this.afterLast = true;
        }

        @Override
        public void receivedRow(FbStatement sender, RowValue rowValue) {
            this.rowValues.add(rowValue);
        }
    }
}

