/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagBase;
import promauto.jroboplc.core.tags.TagBool;
import promauto.jroboplc.core.tags.TagDouble;
import promauto.jroboplc.core.tags.TagInt;
import promauto.jroboplc.core.tags.TagLong;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.core.tags.TagRWBool;
import promauto.jroboplc.core.tags.TagRWDouble;
import promauto.jroboplc.core.tags.TagRWInt;
import promauto.jroboplc.core.tags.TagRWLong;
import promauto.jroboplc.core.tags.TagRWString;
import promauto.jroboplc.core.tags.TagString;

public class TagTable {
    final Logger logger = LoggerFactory.getLogger(TagTable.class);
    private final Map<String, Tag> tagmap = new ConcurrentHashMap<String, Tag>();

    public Tag get(String name) {
        return this.tagmap.get(name);
    }

    public Collection<Tag> values() {
        return this.tagmap.values();
    }

    public List<Tag> getTags(String filter, boolean sorted) {
        Pattern p1 = null;
        try {
            if (!filter.isEmpty()) {
                p1 = Pattern.compile(filter);
            }
        }
        catch (PatternSyntaxException e) {
            EnvironmentInst.get().printError(this.logger, e, "Pattern error:", filter);
        }
        Pattern p = p1;
        if (sorted) {
            TreeSet<String> tagnames = new TreeSet<String>(this.tagmap.keySet());
            return tagnames.stream().filter(tagname -> p == null || p.matcher((CharSequence)tagname).matches()).map(tagname -> this.tagmap.get(tagname)).collect(Collectors.toList());
        }
        List<Tag> res = this.tagmap.values().stream().filter(tag -> p == null || p.matcher(tag.getName()).matches()).collect(Collectors.toList());
        return res;
    }

    public Map<String, Tag> getMap() {
        return Collections.unmodifiableMap(this.tagmap);
    }

    public int getSize() {
        return this.tagmap.size();
    }

    public <T extends Tag> T add(T tag) {
        if (this.tagmap.put(tag.getName(), tag) != null) {
            EnvironmentInst.get().printError(this.logger, "Duplicate: " + tag.getName());
        }
        return tag;
    }

    public boolean remove(String tagname) {
        Tag tag = this.tagmap.get(tagname);
        if (tag == null) {
            return false;
        }
        tag.setStatus(Tag.Status.Deleted);
        this.tagmap.remove(tagname);
        return true;
    }

    public boolean remove(Tag tag) {
        return this.remove(tag.getName());
    }

    public void add(List<Tag> taglist) {
        taglist.forEach(tag -> this.add(tag));
    }

    public void remove(List<Tag> taglist) {
        taglist.forEach(tag -> this.remove((Tag)tag));
    }

    public void clear() {
        this.tagmap.clear();
    }

    public void removeAll() {
        this.tagmap.entrySet().stream().forEach(ent -> ((Tag)ent.getValue()).setStatus(Tag.Status.Deleted));
        this.tagmap.clear();
    }

    public Tag findByNameOrAddToList(Tag tag, List<Tag> list) {
        Tag found = this.get(tag.getName());
        if (found != null) {
            return found;
        }
        list.add(tag);
        return tag;
    }

    public void setTagState(Tag.Status status, int flags) {
        this.tagmap.values().stream().filter(tag -> tag.hasFlags(flags)).forEach(tag -> tag.setStatus(status));
    }

    public Tag createTag(String strTagtype, String name, String value, int flags) {
        try {
            Tag.Type tagtype = Tag.Type.valueOf(strTagtype.toUpperCase());
            Tag tag = this.createTag(tagtype, name, flags);
            if (!value.isEmpty()) {
                tag.setString(value);
            }
            return tag;
        }
        catch (Exception e) {
            EnvironmentInst.get().printError(this.logger, e, strTagtype, name, value);
            return null;
        }
    }

    public Tag createTag(String strTagtype, String name, String value) {
        return this.createTag(strTagtype, name, value, 0);
    }

    public Tag createTag(Tag.Type tagtype, String name, int flags) {
        return this.add(TagBase.create(tagtype, name, flags));
    }

    public Tag createBool(String name, boolean value, int flags) {
        return this.add(new TagBool(name, value, flags));
    }

    public Tag createInt(String name, int value, int flags) {
        return this.add(new TagInt(name, value, flags));
    }

    public Tag createLong(String name, long value, int flags) {
        return this.add(new TagLong(name, value, flags));
    }

    public Tag createDouble(String name, double value, int flags) {
        return this.add(new TagDouble(name, value, flags));
    }

    public Tag createString(String name, String value, int flags) {
        return this.add(new TagString(name, value, flags));
    }

    public Tag createTag(Tag.Type tagtype, String name) {
        return this.add(TagBase.create(tagtype, name, 0));
    }

    public Tag createBool(String name, boolean value) {
        return this.add(new TagBool(name, value, 0));
    }

    public Tag createInt(String name, int value) {
        return this.add(new TagInt(name, value, 0));
    }

    public Tag createLong(String name, long value) {
        return this.add(new TagLong(name, value, 0));
    }

    public Tag createDouble(String name, double value) {
        return this.add(new TagDouble(name, value, 0));
    }

    public Tag createString(String name, String value) {
        return this.add(new TagString(name, value, 0));
    }

    public TagRW createTagRW(Tag.Type tagtype, String name, int flags) {
        TagRW tag = TagRW.create(tagtype, name, flags);
        return this.add(tag);
    }

    public TagRW createRWBool(String name, boolean value, int flags) {
        return this.add(new TagRWBool(name, value, flags));
    }

    public TagRW createRWInt(String name, int value, int flags) {
        return this.add(new TagRWInt(name, value, flags));
    }

    public TagRW createRWLong(String name, long value, int flags) {
        return this.add(new TagRWLong(name, value, flags));
    }

    public TagRW createRWDouble(String name, double value, int flags) {
        return this.add(new TagRWDouble(name, value, flags));
    }

    public TagRW createRWString(String name, String value, int flags) {
        return this.add(new TagRWString(name, value, flags));
    }

    public TagRW createTagRW(Tag.Type tagtype, String name) {
        TagRW tag = TagRW.create(tagtype, name, 0);
        return this.add(tag);
    }

    public TagRW createRWBool(String name, boolean value) {
        return this.add(new TagRWBool(name, value, 0));
    }

    public TagRW createRWInt(String name, int value) {
        return this.add(new TagRWInt(name, value, 0));
    }

    public TagRW createRWLong(String name, long value) {
        return this.add(new TagRWLong(name, value, 0));
    }

    public TagRW createRWDouble(String name, double value) {
        return this.add(new TagRWDouble(name, value, 0));
    }

    public TagRW createRWString(String name, String value) {
        return this.add(new TagRWString(name, value, 0));
    }

    public Tag getOrCreateBool(String name, boolean value) {
        Tag tag = this.tagmap.get(name);
        return tag != null ? tag : this.createBool(name, value);
    }

    public Tag getOrCreateInt(String name, int value) {
        Tag tag = this.tagmap.get(name);
        return tag != null ? tag : this.createInt(name, value);
    }

    public Tag getOrCreateLong(String name, long value) {
        Tag tag = this.tagmap.get(name);
        return tag != null ? tag : this.createLong(name, value);
    }

    public Tag getOrCreateDouble(String name, double value) {
        Tag tag = this.tagmap.get(name);
        return tag != null ? tag : this.createDouble(name, value);
    }

    public Tag getOrCreateString(String name, String value) {
        Tag tag = this.tagmap.get(name);
        return tag != null ? tag : this.createString(name, value);
    }

    public void acceptWriteValues() {
        this.tagmap.values().stream().filter(tag -> tag instanceof TagRW).forEach(tag -> ((TagRW)tag).acceptWriteValue());
    }

    public void copyValuesTo(TagTable dst) {
        dst.values().forEach(tag -> {
            Tag found = this.get(tag.getName());
            if (found != null && found.getStatus() != Tag.Status.Deleted) {
                found.copyValueTo((Tag)tag);
            }
        });
    }

    public void moveTagsTo(TagTable dst) {
        this.values().forEach(tag -> dst.add(tag));
        this.clear();
    }
}

