/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.arcsvr;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Database;
import promauto.jroboplc.core.api.Environment;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.plugin.arcsvr.ArcsvrModule;
import promauto.jroboplc.plugin.arcsvr.MesHolder;
import promauto.jroboplc.plugin.arcsvr.MesRec;

public abstract class MesBase {
    private final Logger logger = LoggerFactory.getLogger(MesBase.class);
    private static Map<String, Integer> colortable = new HashMap<String, Integer>();
    protected static final int ALARM_NO_VISUAL = 2;
    protected static final int ALARM_NO_AFFIRM = 4;
    protected static final int ALARM_NO_OUT = 40;
    protected static final int ALARM_NO_IN = 16;
    protected static final int EVENTTYPE_BY_CHANGE = 7;
    protected final ArcsvrModule module;
    protected final MesHolder holder;
    protected Environment env;
    protected int idmsg;
    protected String mestext;
    protected int clb_inp = colortable.get("RED");
    protected int clf_inp = colortable.get("WHITE");
    protected int clb_out = colortable.get("MAROON");
    protected int clf_out = colortable.get("WHITE");
    protected int clb_ack = colortable.get("GRAY");
    protected int clf_ack = colortable.get("BLACK");
    protected int eventtype = 0;
    protected int eventval = 1;
    protected int alarm = 1;
    protected boolean noaffirm = false;
    protected Function<Integer, Boolean> eventfunc = x -> false;
    protected Map<String, MesRec> recs = new TreeMap<String, MesRec>();

    public MesBase(MesHolder holder, int idmsg) {
        this.module = holder.module;
        this.holder = holder;
        this.idmsg = idmsg;
        this.env = EnvironmentInst.get();
    }

    public boolean load(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.idmsg = cm.get(conf, "id", 0);
        this.mestext = cm.get(conf, "mestext", "");
        String colors = cm.get(conf, "colors", "").trim();
        if (colors.isEmpty()) {
            this.clb_inp = this.parseColor(cm.get(conf, "clb_inp", "" + this.clb_inp));
            this.clf_inp = this.parseColor(cm.get(conf, "clf_inp", "" + this.clf_inp));
            this.clb_out = this.parseColor(cm.get(conf, "clb_out", "" + this.clb_out));
            this.clf_out = this.parseColor(cm.get(conf, "clf_out", "" + this.clf_out));
            this.clb_ack = this.parseColor(cm.get(conf, "clb_ack", "" + this.clb_ack));
            this.clf_ack = this.parseColor(cm.get(conf, "clf_ack", "" + this.clf_ack));
        } else {
            String[] cc = colors.split(";");
            this.clb_inp = this.parseColor(cc.length > 0 ? cc[0].trim() : "" + this.clb_inp);
            this.clf_inp = this.parseColor(cc.length > 1 ? cc[1].trim() : "" + this.clf_inp);
            this.clb_out = this.parseColor(cc.length > 2 ? cc[2].trim() : "" + this.clb_out);
            this.clf_out = this.parseColor(cc.length > 3 ? cc[3].trim() : "" + this.clf_out);
            this.clb_ack = this.parseColor(cc.length > 4 ? cc[4].trim() : "" + this.clb_ack);
            this.clf_ack = this.parseColor(cc.length > 5 ? cc[5].trim() : "" + this.clf_ack);
        }
        this.alarm = 1;
        this.alarm |= cm.get(conf, "no_visual", false) ? 2 : 0;
        this.alarm |= cm.get(conf, "no_affirm", false) ? 4 : 0;
        this.alarm |= cm.get(conf, "no_out", false) ? 40 : 0;
        this.alarm |= cm.get(conf, "no_in", false) ? 16 : 0;
        this.noaffirm = cm.get(conf, "no_affirm", false);
        this.eventtype = cm.get(conf, "eventtype", 0);
        this.eventval = cm.get(conf, "eventval", 1);
        return this.initEventFunc();
    }

    protected int parseColor(String colorstr) {
        Integer color = colortable.get(colorstr.trim().toUpperCase());
        if (color == null) {
            color = 0;
            if (!(colorstr = colorstr.trim()).isEmpty()) {
                try {
                    color = colorstr.charAt(0) == '$' ? Integer.valueOf(Integer.parseInt(colorstr.substring(1), 16)) : Integer.valueOf(Integer.parseInt(colorstr, 10));
                }
                catch (NumberFormatException e) {
                    this.env.printError(this.logger, e, this.module.getName(), "colorstr=" + colorstr);
                }
            }
        }
        return color;
    }

    public boolean init() {
        boolean res = false;
        Database db = this.module.getDatabase();
        try (Statement st = db.getConnection().createStatement();){
            this.initMes(st);
            this.initPlaces(st);
            this.initTags(st);
            db.commit();
            res = true;
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.module.getName(), "id=" + this.idmsg, "Init error");
            db.rollback();
        }
        return res;
    }

    protected boolean initEventFunc() {
        switch (this.eventtype) {
            case 0: {
                this.eventfunc = x -> x == this.eventval;
                break;
            }
            case 1: {
                this.eventfunc = x -> x >= this.eventval;
                break;
            }
            case 2: {
                this.eventfunc = x -> x <= this.eventval;
                break;
            }
            case 3: {
                this.eventfunc = x -> (x & this.eventval) == this.eventval;
                break;
            }
            case 4: {
                this.eventfunc = x -> (x & this.eventval) == 0;
                break;
            }
            case 5: {
                this.eventfunc = x -> (x & this.eventval) > 0;
                break;
            }
            case 6: {
                this.eventfunc = x -> (x & this.eventval) > 0 && (x & this.eventval) != this.eventval;
                break;
            }
            case 7: {
                this.eventfunc = x -> true;
                break;
            }
            default: {
                this.env.printError(this.logger, this.module.getName(), "idmsg=" + this.idmsg, "Bad eventtype: " + this.eventtype);
                return false;
            }
        }
        return true;
    }

    protected void initTags(Statement st) throws SQLException {
    }

    protected void initMes(Statement st) throws SQLException {
        String sql = String.format("select name, alarm, clb_inp, clf_inp, clb_out, clf_out, clb_ack, clf_ack, eventtype, eventval from %s where idmsg=%d", this.module.makeTableName("meslist"), this.idmsg);
        try (ResultSet rs = st.executeQuery(sql);){
            if (rs.next()) {
                boolean flag = false;
                flag |= !rs.getString(1).equals(this.mestext);
                flag |= rs.getInt(2) != this.alarm;
                flag |= rs.getInt(3) != this.clb_inp;
                flag |= rs.getInt(4) != this.clf_inp;
                flag |= rs.getInt(5) != this.clb_out;
                flag |= rs.getInt(6) != this.clf_out;
                flag |= rs.getInt(7) != this.clb_ack;
                flag |= rs.getInt(8) != this.clf_ack;
                flag |= rs.getInt(9) != this.eventtype;
                if (flag |= rs.getInt(10) != this.eventval) {
                    this.updateMeslistRec(st);
                }
            } else {
                this.insertMeslistRec(st);
            }
        }
    }

    protected void insertMeslistRec(Statement st) throws SQLException {
        String sql = String.format("insert into %s (idmsg, name, alarm, clb_inp, clf_inp, clb_out, clf_out, clb_ack, clf_ack, eventtype, eventval) values (%d, '%s', %d, %d, %d,%d, %d, %d, %d, %d, %d)", this.module.makeTableName("meslist"), this.idmsg, this.mestext, this.alarm, this.clb_inp, this.clf_inp, this.clb_out, this.clf_out, this.clb_ack, this.clf_ack, this.eventtype, this.eventval);
        this.env.logInfo(this.logger, this.module.getName(), this.mestext, "Add message: " + this.idmsg);
        st.executeUpdate(sql);
    }

    protected void updateMeslistRec(Statement st) throws SQLException {
        String sql = String.format("update %s set name='%s', alarm=%d, clb_inp=%d, clf_inp=%d, clb_out=%d, clf_out=%d, clb_ack=%d, clf_ack=%d, eventtype=%d, eventval=%d where idmsg=%d", this.module.makeTableName("meslist"), this.mestext, this.alarm, this.clb_inp, this.clf_inp, this.clb_out, this.clf_out, this.clb_ack, this.clf_ack, this.eventtype, this.eventval, this.idmsg);
        this.env.logInfo(this.logger, this.module.getName(), this.mestext, "Update message: " + this.idmsg);
        st.executeUpdate(sql);
    }

    protected Map<String, DescrTagid> getTaglistMap(Statement st) throws SQLException {
        String sql = String.format("select idtag, tagname, descr, idplace from %s where idmsg=%d", this.module.makeTableName("mestags"), this.idmsg);
        HashMap<String, DescrTagid> map = new HashMap<String, DescrTagid>();
        try (ResultSet rs = st.executeQuery(sql);){
            while (rs.next()) {
                DescrTagid dti = new DescrTagid();
                dti.descr = rs.getString(3);
                dti.tagid = rs.getInt(1);
                dti.placeid = rs.getInt(4);
                map.put(rs.getString(2), dti);
            }
        }
        return map;
    }

    protected int createTaglistRec(Statement st, String tagname, String descr, int idplace) throws SQLException {
        String sql = String.format("insert into %s (idmsg, tagname, descr, idplace) values (%d, '%s', '%s', %d)", this.module.makeTableName("mestags"), this.idmsg, tagname, descr, idplace);
        int idtag = this.module.getDatabase().insertReturningId(st, sql, "idtag");
        this.env.logInfo(this.logger, this.module.getName(), "idmsg: " + this.idmsg, "Add tag: " + idtag, tagname);
        return idtag;
    }

    protected void updateTaglistRec(Statement st, int idtag, String descr, int idplace) throws SQLException {
        String sql = String.format("update %s set descr='%s', idplace=%d where idtag=%d", this.module.makeTableName("mestags"), descr, idplace, idtag);
        st.executeUpdate(sql);
        this.env.logInfo(this.logger, this.module.getName(), "idmsg: " + this.idmsg, "Update tag: " + idtag, descr, "" + idplace);
    }

    protected void deleteTaglistRec(Statement st, int idtag, String tagname) throws SQLException {
        String sql = String.format("delete from %s where idtag=%d", this.module.makeTableName("mestags"), idtag);
        st.executeUpdate(sql);
        this.env.logInfo(this.logger, this.module.getName(), "idmsg: " + this.idmsg, "Delete tag: " + idtag, tagname);
    }

    private void initPlaces(Statement st) throws SQLException {
        for (MesRec rec : this.recs.values()) {
            rec.placeid = this.getOrInsertPlace(st, rec.placename);
        }
    }

    private int getOrInsertPlace(Statement st, String thePlacename) throws SQLException {
        if ((thePlacename = thePlacename.trim()).isEmpty()) {
            return 0;
        }
        int resPlaceid = 0;
        resPlaceid = this.holder.getPlace(thePlacename);
        if (resPlaceid > 0) {
            return resPlaceid;
        }
        String sql = String.format("select id from %s where name='%s'", this.module.makeTableName("places"), thePlacename);
        try (ResultSet rs = st.executeQuery(sql);){
            if (rs.next()) {
                resPlaceid = rs.getInt(1);
            } else {
                sql = String.format("insert into %s (name) values ('%s')", this.module.makeTableName("places"), thePlacename);
                resPlaceid = this.module.getDatabase().insertReturningId(st, sql, new String[0]);
                this.env.logInfo(this.logger, this.module.getName(), "Add place: " + resPlaceid, thePlacename);
            }
            this.holder.addPlace(thePlacename, resPlaceid);
        }
        return resPlaceid;
    }

    protected void saveMes(MesRec rec, String datatext) throws SQLException {
        if (!this.holder.isVersion2() && (rec.active ? (this.alarm & 0x10) > 0 : (this.alarm & 0x28) > 0)) {
            return;
        }
        boolean inserting = rec.active || !this.holder.isVersion2();
        PreparedStatement pst = inserting ? this.holder.getPstInsert() : this.holder.getPstUpdateDtend();
        Timestamp ts = Timestamp.valueOf(LocalDateTime.now());
        pst.setTimestamp(1, ts);
        pst.setInt(2, this.idmsg);
        pst.setInt(3, rec.idtag);
        if (inserting) {
            pst.setInt(4, rec.placeid);
            if (rec.active) {
                pst.setString(5, "I");
                pst.setInt(6, this.clb_inp);
                pst.setInt(7, this.clf_inp);
            } else {
                pst.setString(5, "O");
                pst.setInt(6, this.clb_out);
                pst.setInt(7, this.clf_out);
            }
            pst.setString(8, datatext);
        }
        pst.executeUpdate();
        if (this.noaffirm && !inserting) {
            pst = this.holder.getPstUpdateDtack();
            pst.setTimestamp(1, ts);
            pst.setInt(2, this.idmsg);
            pst.setInt(3, rec.idtag);
            pst.executeUpdate();
        }
    }

    protected void perfomPostFactum(Statement st) throws SQLException {
        if (!this.holder.isVersion2()) {
            return;
        }
        String sql = String.format("select idtag from %s where idmsg=%d and dtend is null", this.module.makeTableName("messages"), this.idmsg);
        HashSet<Integer> idtags = new HashSet<Integer>();
        try (ResultSet rs = st.executeQuery(sql);){
            while (rs.next()) {
                idtags.add(rs.getInt(1));
            }
        }
        DateTimeFormatter formatter = this.module.getDatabase().getTimestampFormatter();
        String dt = LocalDateTime.now().format(formatter);
        if (idtags.size() > 0) {
            for (MesRec rec : this.recs.values()) {
                if (rec.active || !idtags.contains(rec.idtag)) continue;
                sql = String.format("update %s set dtend='%s' where idmsg=%d and idtag=%d and dtend is null", this.module.makeTableName("messages"), dt, this.idmsg, rec.idtag);
                st.executeUpdate(sql);
            }
        }
        if (this.eventtype != 7) {
            for (MesRec rec : this.recs.values()) {
                if (!rec.active || idtags.contains(rec.idtag)) continue;
                this.saveMes(rec, "");
            }
        }
    }

    public void link() {
    }

    public boolean execute() throws SQLException {
        for (MesRec rec : this.recs.values()) {
            if (rec.tag == null) continue;
            if (this.eventtype == 7) {
                if (rec.value == rec.tag.getInt()) continue;
                rec.value = rec.tag.getInt();
                rec.active = true;
                this.saveMes(rec, "" + rec.value);
                if (!this.holder.isVersion2()) continue;
                rec.active = false;
                this.saveMes(rec, "");
                continue;
            }
            if (rec.active == this.eventfunc.apply(rec.tag.getInt())) continue;
            rec.active = !rec.active;
            this.saveMes(rec, "");
        }
        return true;
    }

    public String getNolinks() {
        StringBuilder sb = new StringBuilder();
        this.recs.entrySet().stream().filter(rec -> ((MesRec)rec.getValue()).phantom).forEach(rec -> sb.append("  " + (String)rec.getKey() + "\r\n"));
        return sb.toString();
    }

    public String getInfo() {
        long not_linked_cnt = this.recs.entrySet().stream().filter(rec -> ((MesRec)rec.getValue()).phantom).count();
        if (this.recs.size() == 0) {
            return "";
        }
        return String.format("\r\n%d: %s, tags=%d%s", this.idmsg, this.mestext, this.recs.size(), not_linked_cnt == 0L ? "" : "/\u001b[31m" + not_linked_cnt + " nolink" + "\u001b[0m");
    }

    static {
        colortable.put("AQUA", 0xFFFF00);
        colortable.put("BLACK", 0);
        colortable.put("BLUE", 0xFF0000);
        colortable.put("CREAM", 0xF0FBFF);
        colortable.put("DARKGREY", 0x808080);
        colortable.put("FUCHSIA", 0xFF00FF);
        colortable.put("GRAY", 0x808080);
        colortable.put("GREEN", 32768);
        colortable.put("LIMEGREEN", 65280);
        colortable.put("LIGHTGRAY", 0xC0C0C0);
        colortable.put("MAROON", 128);
        colortable.put("MEDIUMGRAY", 0xA4A0A0);
        colortable.put("MINTGREEN", 0xC0DCC0);
        colortable.put("NAVYBLUE", 0x800000);
        colortable.put("OLIVEGREEN", 32896);
        colortable.put("PURPLE", 0x800080);
        colortable.put("RED", 255);
        colortable.put("SILVER", 0xC0C0C0);
        colortable.put("SKYBLUE", 15780518);
        colortable.put("TEAL", 0x808000);
        colortable.put("WHITE", 0xFFFFFF);
        colortable.put("YELLOW", 65535);
    }

    protected static class DescrTagid {
        String descr;
        int tagid;
        int placeid;

        protected DescrTagid() {
        }
    }
}

