/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.redisexp;

import io.lettuce.core.RedisFuture;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagPlain;
import promauto.jroboplc.plugin.redisexp.TagInfoCodec;

public class ExportTag {
    String encodedName;
    String encodedData;
    Tag tag;
    Tag curval;
    char type;
    RedisFuture<Boolean> future;
    long timeSet;
    boolean relevant;
    State state;

    public ExportTag(String tagname, Tag tag) {
        this.tag = tag;
        this.curval = TagPlain.create(tag);
        this.curval.setStatus(tag.getStatus());
        this.state = State.NEED_SET;
        this.type = tag.getType().toString().charAt(0);
        this.encodedName = TagInfoCodec.encodeName(tagname);
        this.prepareEncodedData();
    }

    private void prepareEncodedData() {
        this.encodedData = TagInfoCodec.encodeData(this.curval.getString(), System.currentTimeMillis(), this.type, this.curval.getStatus() == Tag.Status.Good);
    }

    public void update() {
        this.tag.copyValueTo(this.curval);
        this.curval.setStatus(this.tag.getStatus());
        this.prepareEncodedData();
    }

    public boolean isOutdated() {
        return !this.tag.equalsValue(this.curval) || this.tag.getStatus() != this.curval.getStatus();
    }

    public String getEncodedData() {
        return this.encodedData;
    }

    public String getEncodedMessageUpdate() {
        return TagInfoCodec.encodeMessageUpdate(this.encodedName, this.encodedData);
    }

    public static enum State {
        IDLE,
        NEED_SET,
        HAS_FUTURE;

    }
}

