/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import promauto.jroboplc.core.State;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Input;

public class DeviceDIFFC
extends Device {
    Input inpEnable;
    Input inpSusp;
    Input inpCurTmp;
    Input inpMaxTmp;
    Input inpMinTmp;
    Input inpAlrmTmpHigh;
    Input inpAlrmTmpLow;
    Input inpError;
    Tag tagOutVal;
    Tag tagState;
    Tag tagMinOut;
    Tag tagMaxOut;
    Tag tagStartPwr;
    Tag tagPwrStep;
    Tag tagPwrMult;
    Tag tagTimePreHeat;
    Tag tagTimeWrkHigh;
    Tag tagTimeWrkLow;
    Tag tagOldTmp;
    Tag tagFlSetHigh;
    Tag tagTimeWrkLowCnt;
    Tag tagTimeWrkHighCnt;
    Tag tagTimePreCnt;
    int enable;
    int time;
    int curTmp;
    int maxTmp;
    int minTmp;
    int alrmTmpHigh;
    int alrmTmpLow;
    int error;
    private int state;
    private int outval;
    private int minout;
    private int maxout;
    private int timePreCnt;
    private int pwrmult;

    @Override
    public void prepareTags(Device.RefBool res) {
        this.inpEnable = this.getInput("Enable", res);
        this.inpSusp = this.getInput("Susp", res);
        this.inpCurTmp = this.getInput("CurTmp", res);
        this.inpMaxTmp = this.getInput("MaxTmp", res);
        this.inpMinTmp = this.getInput("MinTmp", res);
        this.inpAlrmTmpHigh = this.getInput("AlrmTmpH", res);
        this.inpAlrmTmpLow = this.getInput("AlarmTmpL", res);
        this.inpError = this.getInput("Error", res);
        this.tagOutVal = this.getOutputTag("OutVal", res);
        this.tagState = this.getOutputTag("State", res);
        this.tagMinOut = this.getOutputTag("MinOut_mA", res);
        this.tagMaxOut = this.getOutputTag("MaxOut_mA", res);
        this.tagStartPwr = this.getOutputTag("StartPwr", res);
        this.tagPwrStep = this.getOutputTag("PwrStep", res);
        this.tagPwrMult = this.getOutputTag("PwrMult", res);
        this.tagTimePreHeat = this.getOutputTag("TimePreHeat", res);
        this.tagTimeWrkHigh = this.getOutputTag("TimeWrkHigh", res);
        this.tagTimeWrkLow = this.getOutputTag("TimeWrkLow", res);
        this.tagOldTmp = this.getOutputTag("OldTmp", res);
        this.tagFlSetHigh = this.getOutputTag("FlSetLow", res);
        this.tagTimeWrkLowCnt = this.getOutputTag("TimeWorkLowCnt", res);
        this.tagTimeWrkHighCnt = this.getOutputTag("TimeWorkHighCnt", res);
        this.tagTimePreCnt = this.getOutputTag("TimePreCnt", res);
        if (res.value) {
            this.resetState();
        }
    }

    protected void resetState() {
        this.enable = 0;
        this.time = 0;
        this.curTmp = 0;
        this.maxTmp = 0;
        this.minTmp = 0;
        this.alrmTmpHigh = 0;
        this.alrmTmpLow = 0;
        this.error = 0;
        this.tagPwrMult.setInt(1);
        this.tagTimePreCnt.setInt(this.tagTimePreHeat.getInt());
    }

    @Override
    public boolean execute() {
        int susp = this.inpSusp.getInt();
        this.enable = this.inpEnable.getInt();
        this.curTmp = this.inpCurTmp.getInt();
        this.maxTmp = this.inpMaxTmp.getInt();
        this.minTmp = this.inpMinTmp.getInt();
        this.alrmTmpHigh = this.inpAlrmTmpHigh.getInt();
        this.alrmTmpLow = this.inpAlrmTmpLow.getInt();
        this.error = this.inpError.getInt();
        this.state = this.tagState.getInt();
        this.outval = this.tagOutVal.getInt();
        this.minout = this.tagMinOut.getInt();
        this.maxout = this.tagMaxOut.getInt();
        this.timePreCnt = this.tagTimePreCnt.getInt();
        this.pwrmult = this.tagPwrMult.getInt();
        if (this.error != 0) {
            this.state = this.enable == 1 ? 3 : 4;
            this.outval = this.minout;
            this.timePreCnt = this.tagTimePreHeat.getInt();
        } else if (this.enable == 0) {
            this.outval = this.minout;
            this.state = 0;
            this.timePreCnt = this.tagTimePreHeat.getInt();
        } else if (susp != 0) {
            this.state = 8;
        } else {
            if (this.curTmp < this.minTmp && this.timePreCnt > 0) {
                this.state = 1;
                this.outval = this.minout + (int)((float)((this.maxout - this.minout) * this.tagStartPwr.getInt()) / 100.0f);
                --this.timePreCnt;
            } else {
                this.timePreCnt = 0;
                if (this.curTmp < this.minTmp) {
                    this.setPwrUp(this.curTmp < this.alrmTmpLow ? 1 : 0);
                    this.state = 5;
                } else if (this.curTmp > this.maxTmp) {
                    this.setPwrDown(this.curTmp > this.alrmTmpHigh ? 1 : 0);
                    this.state = 6;
                } else {
                    this.state = 7;
                    this.tagTimeWrkHighCnt.setInt(0);
                    this.tagTimeWrkLowCnt.setInt(0);
                    this.timePreCnt = 0;
                }
                this.tagOldTmp.setInt(this.curTmp);
            }
            if (this.outval < this.minout) {
                this.outval = this.minout;
            } else if (this.outval > this.maxout) {
                this.outval = this.maxout;
            }
        }
        this.tagState.setInt(this.state);
        this.tagOutVal.setInt(this.outval);
        this.tagTimePreCnt.setInt(this.timePreCnt);
        this.tagPwrMult.setInt(this.pwrmult);
        return true;
    }

    private void setPwrUp(int isAlarm) {
        if (this.tagTimeWrkHighCnt.getInt() == 0) {
            if (this.tagFlSetHigh.getInt() == 0) {
                this.tagFlSetHigh.setInt(1);
                this.pwrmult = 1;
                this.outval += (int)((float)((this.pwrmult + isAlarm) * this.tagPwrStep.getInt() * (this.maxout - this.minout)) / 100.0f);
            } else if (this.tagOldTmp.getInt() >= this.curTmp) {
                this.outval += (int)((float)((this.pwrmult + isAlarm & 3) * this.tagPwrStep.getInt() * (this.maxout - this.minout)) / 100.0f);
                this.pwrmult = this.pwrmult + 1 & 3;
            } else {
                this.pwrmult = 1;
            }
            this.tagTimeWrkHighCnt.setInt(this.tagTimeWrkHigh.getInt());
        } else {
            this.tagTimeWrkHighCnt.setInt(this.tagTimeWrkHighCnt.getInt() - 1);
        }
    }

    private void setPwrDown(int isAlarm) {
        if (this.tagTimeWrkLowCnt.getInt() == 0) {
            if (this.tagFlSetHigh.getInt() == 1) {
                this.tagFlSetHigh.setInt(0);
                this.pwrmult = 1;
                this.outval -= (int)((float)((this.pwrmult + isAlarm) * this.tagPwrStep.getInt() * (this.maxout - this.minout)) / 100.0f);
            } else if (this.tagOldTmp.getInt() <= this.curTmp) {
                this.outval -= (int)((float)((this.pwrmult + isAlarm) * this.tagPwrStep.getInt() * (this.maxout - this.minout)) / 100.0f);
            }
            this.tagTimeWrkLowCnt.setInt(this.tagTimeWrkLow.getInt());
        } else {
            this.tagTimeWrkLowCnt.setInt(this.tagTimeWrkLowCnt.getInt() - 1);
        }
    }

    @Override
    public void saveStateExtra(State _state) {
        _state.saveVar("enable", this.enable);
        _state.saveVar("time", this.time);
        _state.saveVar("curTmp", this.curTmp);
        _state.saveVar("maxTmp", this.maxTmp);
        _state.saveVar("minTmp", this.minTmp);
        _state.saveVar("alrmTmpHigh", this.alrmTmpHigh);
        _state.saveVar("alrmTmpLow", this.alrmTmpLow);
        _state.saveVar("error", this.error);
    }

    @Override
    public void loadStateExtra(State _state) {
        this.enable = _state.loadVar("enable", this.enable);
        this.time = _state.loadVar("time", this.time);
        this.curTmp = _state.loadVar("curTmp", this.curTmp);
        this.maxTmp = _state.loadVar("maxTmp", this.maxTmp);
        this.minTmp = _state.loadVar("minTmp", this.minTmp);
        this.alrmTmpHigh = _state.loadVar("alrmTmpHigh", this.alrmTmpHigh);
        this.alrmTmpLow = _state.loadVar("alrmTmpLow", this.alrmTmpLow);
        this.error = _state.loadVar("error", this.error);
    }
}

