/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptorBuilder;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jdbc.metadata.AbstractMetadataMethod;
import org.firebirdsql.jdbc.metadata.Clause;
import org.firebirdsql.jdbc.metadata.DbMetadataMediator;
import org.firebirdsql.jdbc.metadata.RowValueBuilder;

public final class GetIndexInfo
extends AbstractMetadataMethod {
    private static final RowDescriptor ROW_DESCRIPTOR = new RowDescriptorBuilder(13, DbMetadataMediator.datatypeCoder).at(0).simple(449, 63, "TABLE_CAT", "INDEXINFO").addField().at(1).simple(449, 63, "TABLE_SCHEM", "INDEXINFO").addField().at(2).simple(448, 63, "TABLE_NAME", "INDEXINFO").addField().at(3).simple(452, 1, "NON_UNIQUE", "INDEXINFO").addField().at(4).simple(448, 63, "INDEX_QUALIFIER", "INDEXINFO").addField().at(5).simple(448, 63, "INDEX_NAME", "INDEXINFO").addField().at(6).simple(500, 0, "TYPE", "INDEXINFO").addField().at(7).simple(500, 0, "ORDINAL_POSITION", "INDEXINFO").addField().at(8).simple(448, Integer.MAX_VALUE, "COLUMN_NAME", "INDEXINFO").addField().at(9).simple(453, 1, "ASC_OR_DESC", "INDEXINFO").addField().at(10).simple(496, 0, "CARDINALITY", "INDEXINFO").addField().at(11).simple(496, 0, "PAGES", "INDEXINFO").addField().at(12).simple(449, 31, "FILTER_CONDITION", "INDEXINFO").addField().toRowDescriptor();
    private static final String GET_INDEX_INFO_START = "select\n  IND.RDB$RELATION_NAME as TABLE_NAME,\n  IND.RDB$UNIQUE_FLAG as UNIQUE_FLAG,\n  IND.RDB$INDEX_NAME as INDEX_NAME,\n  ISE.RDB$FIELD_POSITION + 1 as ORDINAL_POSITION,\n  ISE.RDB$FIELD_NAME as COLUMN_NAME,\n  IND.RDB$EXPRESSION_SOURCE as EXPRESSION_SOURCE,\n  IND.RDB$INDEX_TYPE as ASC_OR_DESC\nfrom RDB$INDICES IND\nleft join RDB$INDEX_SEGMENTS ISE on IND.RDB$INDEX_NAME = ISE.RDB$INDEX_NAME where ";
    private static final String GET_INDEX_INFO_END = "\norder by IND.RDB$UNIQUE_FLAG, IND.RDB$INDEX_NAME, ISE.RDB$FIELD_POSITION";

    private GetIndexInfo(DbMetadataMediator mediator) {
        super(ROW_DESCRIPTOR, mediator);
    }

    public ResultSet getIndexInfo(String table, boolean unique, boolean approximate) throws SQLException {
        if (table == null || "".equals(table)) {
            return this.createEmpty();
        }
        Clause tableClause = Clause.equalsClause("IND.RDB$RELATION_NAME", table);
        String sql = GET_INDEX_INFO_START + tableClause.getCondition(unique) + (unique ? "IND.RDB$UNIQUE_FLAG = 1" : "") + GET_INDEX_INFO_END;
        DbMetadataMediator.MetadataQuery metadataQuery = new DbMetadataMediator.MetadataQuery(sql, Clause.parameters(tableClause));
        return this.createMetaDataResultSet(metadataQuery);
    }

    @Override
    RowValue createMetadataRow(ResultSet rs, RowValueBuilder valueBuilder) throws SQLException {
        valueBuilder.at(0).set(null).at(1).set(null).at(2).setString(rs.getString("TABLE_NAME")).at(3).setString(rs.getInt("UNIQUE_FLAG") == 0 ? "T" : "F").at(4).set(null).at(5).setString(rs.getString("INDEX_NAME")).at(6).setShort((short)3);
        String columnName = rs.getString("COLUMN_NAME");
        if (columnName == null) {
            valueBuilder.at(7).setShort(1).at(8).setString(rs.getString("EXPRESSION_SOURCE"));
        } else {
            valueBuilder.at(7).setShort(rs.getShort("ORDINAL_POSITION")).at(8).setString(columnName);
        }
        switch (rs.getInt("ASC_OR_DESC")) {
            case 0: {
                valueBuilder.at(9).setString("A");
                break;
            }
            case 1: {
                valueBuilder.at(9).setString("D");
                break;
            }
            default: {
                valueBuilder.at(9).set(null);
            }
        }
        valueBuilder.at(10).set(null).at(11).set(null).at(12).set(null);
        return valueBuilder.toRowValue(false);
    }

    public static GetIndexInfo create(DbMetadataMediator mediator) {
        return new GetIndexInfo(mediator);
    }
}

