/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.util;

import java.util.Base64;

public final class ByteArrayHelper {
    private static final char[] BYTE_2_HEX = "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F202122232425262728292A2B2C2D2E2F303132333435363738393A3B3C3D3E3F404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F707172737475767778797A7B7C7D7E7F808182838485868788898A8B8C8D8E8F909192939495969798999A9B9C9D9E9FA0A1A2A3A4A5A6A7A8A9AAABACADAEAFB0B1B2B3B4B5B6B7B8B9BABBBCBDBEBFC0C1C2C3C4C5C6C7C8C9CACBCCCDCECFD0D1D2D3D4D5D6D7D8D9DADBDCDDDEDFE0E1E2E3E4E5E6E7E8E9EAEBECEDEEEFF0F1F2F3F4F5F6F7F8F9FAFBFCFDFEFF".toCharArray();

    private ByteArrayHelper() {
    }

    public static String toHexString(byte[] bytes) {
        int length = bytes.length;
        char[] chars = new char[length << 1];
        char[] byte2Hex = BYTE_2_HEX;
        int index = 0;
        int offset = 0;
        while (offset < length) {
            int hexIndex = (bytes[offset++] & 0xFF) << 1;
            chars[index++] = byte2Hex[hexIndex++];
            chars[index++] = byte2Hex[hexIndex];
        }
        return new String(chars);
    }

    public static byte[] fromHexString(String hexString) {
        int length = hexString.length() / 2;
        byte[] bytes = new byte[length];
        for (int byteIdx = 0; byteIdx < length; ++byteIdx) {
            bytes[byteIdx] = (byte)((Character.digit(hexString.charAt(2 * byteIdx), 16) << 4) + Character.digit(hexString.charAt(2 * byteIdx + 1), 16));
        }
        return bytes;
    }

    public static byte[] fromBase64String(String base64) {
        return Base64.getDecoder().decode(base64);
    }

    public static byte[] fromBase64urlString(String base64url) {
        return Base64.getUrlDecoder().decode(base64url);
    }

    public static int indexOf(byte[] array, byte b) {
        for (int idx = 0; idx < array.length; ++idx) {
            if (array[idx] != b) continue;
            return idx;
        }
        return -1;
    }
}

