/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperProcess;
import org.tanukisoftware.wrapper.test.Main;
import org.tanukisoftware.wrapper.test.RuntimeExec;

public class ExecAvailable {
    static final String c_encoding;
    static int c_testsFailed;
    static boolean c_currentTestFailed;
    static int c_testsPerformed;
    private static long c_start;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleCommonProcessInner(String testId, Object process, InputStream is, InputStream es) throws IOException {
        int exitCode2;
        block15: {
            boolean exited = false;
            try {
                long now;
                InputStreamReader iir = new InputStreamReader(is, c_encoding);
                InputStreamReader eir = new InputStreamReader(es, c_encoding);
                BufferedReader ir = new BufferedReader(iir);
                BufferedReader er = new BufferedReader(eir);
                long start = now = System.currentTimeMillis();
                long lastOutput = now;
                boolean timeout = false;
                boolean hadErrors = false;
                boolean haveStdout = false;
                boolean haveStderr = false;
                while (!(exited && now - lastOutput >= 500L || timeout)) {
                    String line;
                    boolean ready;
                    int avail;
                    boolean sleep = true;
                    if (ir.ready()) {
                        do {
                            avail = is.available();
                            ready = ir.ready();
                            line = ir.readLine();
                            if (line == null) continue;
                            System.out.println(testId + "stdout:" + ready + "(" + avail + "):" + line);
                            sleep = false;
                            lastOutput = System.currentTimeMillis();
                        } while (ir.ready());
                    }
                    if (er.ready()) {
                        do {
                            avail = es.available();
                            ready = er.ready();
                            line = er.readLine();
                            if (line == null) continue;
                            System.out.println(testId + "stderr:" + ready + "(" + avail + "):" + line);
                            sleep = false;
                            lastOutput = System.currentTimeMillis();
                        } while (er.ready());
                    }
                    if (sleep) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    now = System.currentTimeMillis();
                    if (exited) continue;
                    try {
                        exitCode2 = process instanceof WrapperProcess ? ((WrapperProcess)process).exitValue() : ((Process)process).exitValue();
                        exited = true;
                        lastOutput = now;
                    }
                    catch (IllegalThreadStateException e) {}
                }
                Object var25_24 = null;
            }
            catch (Throwable throwable) {
                int exitCode2;
                Object var25_25 = null;
                try {
                    exitCode2 = process instanceof WrapperProcess ? ((WrapperProcess)process).waitFor() : ((Process)process).waitFor();
                }
                catch (InterruptedException e) {
                    exitCode2 = -999;
                }
                System.out.println(Main.getRes().getString("{0}exitCode: {1}", (Object)testId, (Object)new Integer(exitCode2)));
                throw throwable;
            }
            try {
                exitCode2 = process instanceof WrapperProcess ? ((WrapperProcess)process).waitFor() : ((Process)process).waitFor();
                break block15;
            }
            catch (InterruptedException e) {
                exitCode2 = -999;
            }
            {
            }
        }
        System.out.println(Main.getRes().getString("{0}exitCode: {1}", (Object)testId, (Object)new Integer(exitCode2)));
    }

    private static void handleJavaProcessInner(String testId, Process process) throws IOException, InterruptedException {
        ExecAvailable.handleCommonProcessInner(testId, process, process.getInputStream(), process.getErrorStream());
    }

    private static void handleJavaProcess(String testId, String command) throws IOException, InterruptedException {
        System.out.println(Main.getRes().getString("{0}Runtime.exec command: {1}", (Object)testId, (Object)command));
        ExecAvailable.handleJavaProcessInner(testId, Runtime.getRuntime().exec(command));
    }

    private static void handleJavaProcess(String testId, String[] command) throws IOException, InterruptedException {
        System.out.println(Main.getRes().getString("{0}Runtime.exec command: {1}", (Object)testId, (Object)ExecAvailable.toString(command)));
        ExecAvailable.handleJavaProcessInner(testId, Runtime.getRuntime().exec(command));
    }

    private static void handlWrapperProcessInner(String testId, WrapperProcess process) throws IOException, InterruptedException {
        ExecAvailable.handleCommonProcessInner(testId, process, process.getInputStream(), process.getErrorStream());
    }

    private static void handleWrapperProcess(String testId, String command) throws IOException, InterruptedException {
        System.out.println(Main.getRes().getString("{0}WrapperMaanger.exec command: {1}", (Object)testId, (Object)command));
        ExecAvailable.handlWrapperProcessInner(testId, WrapperManager.exec((String)command));
    }

    private static void handleWrapperProcess(String testId, String[] command) throws IOException, InterruptedException {
        System.out.println(Main.getRes().getString("{0}WrapperMaanger.exec command: {1}", (Object)testId, (Object)ExecAvailable.toString(command)));
        ExecAvailable.handlWrapperProcessInner(testId, WrapperManager.exec((String[])command));
    }

    static void beginCase(String testId) {
        ++c_testsPerformed;
        c_currentTestFailed = false;
        c_start = System.currentTimeMillis();
        System.out.println();
        System.out.println(Main.getRes().getString("{0}BEGIN ----------------------------------------", (Object)testId));
    }

    static void endCase(String testId, long expectedTimeMs) {
        String result;
        long time = System.currentTimeMillis() - c_start;
        if (expectedTimeMs >= 0L) {
            long minTime = expectedTimeMs;
            long maxTime = expectedTimeMs + 999L;
            if (time < minTime || time > maxTime) {
                result = " " + Main.getRes().getString("FAILED! Expected time to be in range of {0} ~ {1}ms.", (Object)Long.toString(minTime), (Object)Long.toString(maxTime));
                c_currentTestFailed = true;
            } else {
                result = " " + Main.getRes().getString("OK.");
            }
        } else {
            result = "";
        }
        if (c_currentTestFailed) {
            ++c_testsFailed;
        }
        System.out.println(Main.getRes().getString("{0}END   ---------------------------------------- {1}ms.{2}", (Object)testId, (Object)Long.toString(time), (Object)result));
    }

    static void endCase(String testId) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ExecAvailable.endCase(testId, -1L);
    }

    private static String toString(String[] command) {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        for (int i = 0; i < command.length; ++i) {
            String arg = command[i];
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("\"");
            sb.append(arg);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseSimpleTestJava(String simplewaiter) {
        String testId = "Simple Java : ";
        ExecAvailable.beginCase(testId);
        try {
            try {
                String command = simplewaiter + " -v \"test 123\" test 123 \"\\\"test\\\"";
                ExecAvailable.handleJavaProcess(testId, command);
            }
            catch (Exception e) {
                System.out.println(Main.getRes().getString("{0}ERROR - Unexpected error:", (Object)testId));
                e.printStackTrace();
                c_currentTestFailed = true;
            }
        }
        finally {
            ExecAvailable.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseSimpleTestWrapper(String simplewaiter) {
        String testId = "Simple Wrapper : ";
        ExecAvailable.beginCase(testId);
        try {
            try {
                String command = simplewaiter + " -v \"test 123\" test 123 \"\\\"test\\\"";
                ExecAvailable.handleWrapperProcess(testId, command);
            }
            catch (Exception e) {
                System.out.println(Main.getRes().getString("{0}ERROR - Unexpected error:", (Object)testId));
                e.printStackTrace();
                c_currentTestFailed = true;
            }
        }
        finally {
            ExecAvailable.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseSimpleTestJavaAry(String simplewaiter) {
        String testId = "Simple Java (Array) : ";
        ExecAvailable.beginCase(testId);
        try {
            try {
                String[] command = new String[]{simplewaiter, "-v", "\"test 123\"", "test 123", "\"\\\"test\\\"\""};
                ExecAvailable.handleJavaProcess(testId, command);
            }
            catch (Exception e) {
                System.out.println(Main.getRes().getString("{0}ERROR - Unexpected error:", (Object)testId));
                e.printStackTrace();
                c_currentTestFailed = true;
            }
        }
        finally {
            ExecAvailable.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseSimpleTestWrapperAry(String simplewaiter) {
        String testId = "Simple Wrapper (Array) : ";
        ExecAvailable.beginCase(testId);
        try {
            try {
                String[] command = new String[]{simplewaiter, "-v", "\"test 123\"", "test 123", "\"\\\"test\\\"\""};
                ExecAvailable.handleWrapperProcess(testId, command);
            }
            catch (Exception e) {
                System.out.println(Main.getRes().getString("{0}ERROR - Unexpected error:", (Object)testId));
                e.printStackTrace();
                c_currentTestFailed = true;
            }
        }
        finally {
            ExecAvailable.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseSleepTestJava(String simplewaiter) {
        String testId = "Sleep Java : ";
        ExecAvailable.beginCase(testId);
        try {
            try {
                String command = simplewaiter + " -message TestString -messageinterval 2000 0 5";
                ExecAvailable.handleJavaProcess(testId, command);
            }
            catch (Exception e) {
                System.out.println(Main.getRes().getString("{0}ERROR - Unexpected error:", (Object)testId));
                e.printStackTrace();
                c_currentTestFailed = true;
            }
        }
        finally {
            ExecAvailable.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseSleepTestWrapper(String simplewaiter) {
        String testId = "Sleep Wrapper : ";
        ExecAvailable.beginCase(testId);
        try {
            try {
                String command = simplewaiter + " -message TestString -messageinterval 2000 0 5";
                ExecAvailable.handleWrapperProcess(testId, command);
            }
            catch (Exception e) {
                System.out.println(Main.getRes().getString("{0}ERROR - Unexpected error:", (Object)testId));
                e.printStackTrace();
                c_currentTestFailed = true;
            }
        }
        finally {
            ExecAvailable.endCase(testId);
        }
    }

    public static void main(String[] args) {
        RuntimeExec.c_testsPerformed = 0;
        RuntimeExec.c_testsFailed = 0;
        String simplewaiter = WrapperManager.isWindows() ? "../test/simplewaiter.exe" : "../test/simplewaiter";
        ExecAvailable.caseSimpleTestJava(simplewaiter);
        ExecAvailable.caseSimpleTestWrapper(simplewaiter);
        ExecAvailable.caseSimpleTestJavaAry(simplewaiter);
        ExecAvailable.caseSimpleTestWrapperAry(simplewaiter);
        ExecAvailable.caseSleepTestJava(simplewaiter);
        ExecAvailable.caseSleepTestWrapper(simplewaiter);
        int nbTestsPassed = c_testsPerformed - c_testsFailed;
        System.out.println("");
        System.out.println("(Test results for current JVM #" + WrapperManager.getJVMId() + ")");
        System.out.println(Main.getRes().getString("[PASSED] {0}", (Object)Integer.toString(nbTestsPassed)));
        System.out.println(Main.getRes().getString("[FAILED] {0}", (Object)Integer.toString(c_testsFailed)));
        if (c_testsFailed > 0) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }

    static {
        c_testsFailed = 0;
        c_currentTestFailed = false;
        c_testsPerformed = 0;
        String encoding = System.getProperty("sun.jnu.encoding");
        if (encoding == null && (encoding = System.getProperty("file.encoding")) == null) {
            encoding = "Cp1252";
        }
        c_encoding = encoding;
    }
}

