/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.database;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Environment;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Signal;
import promauto.jroboplc.plugin.database.DatabaseModule;
import promauto.jroboplc.plugin.database.Tabletag;

public class Tabletags {
    private final Logger logger = LoggerFactory.getLogger(Tabletags.class);
    private final DatabaseModule module;
    private List<Tabletag> tabletags = new ArrayList<Tabletag>();
    private Environment env = EnvironmentInst.get();

    public Tabletags(DatabaseModule module) {
        this.module = module;
    }

    public void load(Object conf) {
        Configuration cm = this.env.getConfiguration();
        List<Object> conf_tabletags = cm.toList(cm.get(conf, "tabletags"));
        Iterator<Object> iterator = conf_tabletags.iterator();
        while (iterator.hasNext()) {
            Tabletag tbtg = new Tabletag(this.module);
            Object conf_tabletag = iterator.next();
            if (!tbtg.load(conf_tabletag)) continue;
            this.tabletags.add(tbtg);
        }
    }

    public void connect() {
        boolean hasChanges = false;
        try (Statement st = this.module.getConnection().createStatement();){
            for (Tabletag tbtg : this.tabletags) {
                hasChanges &= tbtg.connect(st);
            }
        }
        catch (SQLException e) {
            this.env.logError(this.logger, e, this.module.getName());
        }
        if (this.env.isRunning() && hasChanges) {
            this.module.postSignal(Signal.SignalType.RELOADED);
        }
    }

    public void execute() {
        boolean needReconnect = false;
        try (Statement st = this.module.getConnection().createStatement();){
            for (Tabletag tbtg : this.tabletags) {
                needReconnect |= tbtg.execute(st);
            }
            this.module.getConnection().commit();
        }
        catch (SQLException e) {
            this.env.logError(this.logger, e, this.module.getName());
        }
        if (needReconnect) {
            this.connect();
        }
    }
}

