/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolModbus;

public class IdsDriveEczModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(IdsDriveEczModule.class);
    protected ProtocolModbus protocol = new ProtocolModbus(this);
    protected Tag tagFreqReq;
    protected Tag tagFreqOut;
    protected Tag tagCurrOut;
    protected Tag tagRotSpd;
    protected Tag tagVoltage;
    protected Tag tagTemper;
    protected Tag tagError1;
    protected Tag tagError2;
    protected Tag tagError3;
    protected Tag tagError4;
    protected TagRW tagControl;
    protected TagRW tagFreqSet;

    public IdsDriveEczModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        this.tagFreqReq = this.tagtable.createInt("FreqReq", 0, 8);
        this.tagFreqOut = this.tagtable.createInt("FreqOut", 0, 8);
        this.tagCurrOut = this.tagtable.createInt("CurrOut", 0, 8);
        this.tagRotSpd = this.tagtable.createInt("RotSpd", 0, 8);
        this.tagVoltage = this.tagtable.createInt("Voltage", 0, 8);
        this.tagTemper = this.tagtable.createInt("Temper", 0, 8);
        this.tagError1 = this.tagtable.createInt("Error1", 0, 8);
        this.tagError2 = this.tagtable.createInt("Error2", 0, 8);
        this.tagError3 = this.tagtable.createInt("Error3", 0, 8);
        this.tagError4 = this.tagtable.createInt("Error4", 0, 8);
        this.tagControl = this.protocol.addWriteTag(8192, this.tagtable.createRWInt("Control", 0, 8));
        this.tagFreqSet = this.protocol.addWriteTag(8193, this.tagtable.createRWInt("FreqSet", 0, 8));
        return true;
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            this.tagFreqSet.acceptWriteValue();
            return true;
        }
        boolean result = true;
        try {
            if (result) {
                result = this.protocol.sendWriteTags(6);
            }
            if (result && (result = this.protocol.requestCmd3(1, 13))) {
                this.tagFreqReq.setInt(this.protocol.getAnswerWord(0));
                this.tagFreqOut.setInt(this.protocol.getAnswerWord(1));
                this.tagCurrOut.setInt(this.protocol.getAnswerWord(2));
                this.tagRotSpd.setInt(this.protocol.getAnswerWord(3));
                this.tagVoltage.setInt(this.protocol.getAnswerWord(4));
                this.tagTemper.setInt(this.protocol.getAnswerWord(5));
                this.tagError1.setInt(this.protocol.getAnswerWord(9));
                this.tagError2.setInt(this.protocol.getAnswerWord(10));
                this.tagError3.setInt(this.protocol.getAnswerWord(11));
                this.tagError4.setInt(this.protocol.getAnswerWord(12));
                this.tagFreqSet.setReadValInt(this.tagFreqReq.getInt());
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            result = false;
        }
        return result;
    }
}

