/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.raduga;

import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import promauto.jroboplc.core.TagTable;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.raduga.Context;
import promauto.jroboplc.plugin.raduga.DataService;
import promauto.jroboplc.plugin.raduga.Line;
import promauto.jroboplc.plugin.raduga.Periods;
import promauto.jroboplc.plugin.raduga.Task;

public class Dispenser {
    private static final int SUM_WEIGHT_SIZE = 65536000;
    private final Context ctx;
    public final Line line;
    private int id;
    private String name;
    private String descr;
    protected TagRW tagDescr;
    protected TagRW tagProductId;
    protected TagRW tagProductName;
    protected Tag tagPercentage;
    protected TagRW tagSumWeight;
    private int lastSaveHour;

    public Dispenser(Context ctx, Line line) {
        this.ctx = ctx;
        this.line = line;
        this.lastSaveHour = this.getHour(ctx.now());
    }

    private int getHour(LocalDateTime dt) {
        return dt.getHour();
    }

    public boolean load(Object conf) {
        Configuration cm = this.ctx.env.getConfiguration();
        cm.toMap(conf).forEach((k, v) -> {
            this.name = k;
            this.descr = (String)v;
        });
        TagTable tt = this.ctx.tagtable;
        Tag[] tagArray = new Tag[4];
        this.tagProductId = tt.createRWInt(this.makeTagName("ProductId"), 0);
        tagArray[0] = this.tagProductId;
        this.tagProductName = tt.createRWString(this.makeTagName("ProductName"), "");
        tagArray[1] = this.tagProductName;
        this.tagSumWeight = tt.createRWLong(this.makeTagName("SumWeight"), 0L);
        tagArray[2] = this.tagSumWeight;
        tagArray[3] = this.tagPercentage = tt.createInt(this.makeTagName("Percentage"), 0);
        this.ctx.addRepoTags(tagArray);
        this.tagDescr = tt.createRWString(this.makeTagName("Descr"), "");
        return true;
    }

    private String makeTagName(String tagname) {
        return "dsp." + this.line.makeTagName(this.name + '_' + tagname);
    }

    public void init() throws SQLException {
        this.id = this.ctx.service.syncDispenser(this.line.getId(), this.name, this.descr);
    }

    public int getId() {
        return this.id;
    }

    public void reset() {
        this.tagProductId.setReadValInt(0);
        this.tagProductName.setReadValString("");
        this.tagPercentage.setInt(0);
    }

    public String getName() {
        return this.name;
    }

    public boolean isInUse() {
        return this.tagProductId.getInt() > 0;
    }

    public void installTask(Task task) {
        this.reset();
        for (Task.Dispenser td : task.dispensers) {
            if (!td.dispenserName.equals(this.name)) continue;
            this.tagProductId.setReadValInt(td.productId);
            this.tagProductName.setReadValString(td.productName);
            this.tagPercentage.setInt(td.percentage);
            break;
        }
    }

    public void execute() throws SQLException {
        LocalDateTime dt;
        int hour;
        if (this.tagProductId.hasWriteValue()) {
            int productId = this.tagProductId.getWriteValInt();
            String productName = this.ctx.service.getProductName(productId);
            if (productName.isEmpty()) {
                this.tagProductId.setReadValInt(0);
                this.tagProductName.setReadValString(productName);
            } else {
                this.tagProductId.setReadValInt(productId);
                this.tagProductName.setReadValString(productName);
            }
        }
        if (this.lastSaveHour == (hour = this.getHour(dt = this.ctx.now()))) {
            return;
        }
        this.lastSaveHour = hour;
        if (!this.tagSumWeight.hasWriteValue()) {
            return;
        }
        long weightBeg = this.tagSumWeight.getLong();
        if (weightBeg == 0L) {
            return;
        }
        long weightEnd = this.tagSumWeight.getWriteValLong();
        this.tagSumWeight.setReadValLong(weightEnd);
        long weight = weightEnd - weightBeg;
        if (weight == 0L) {
            return;
        }
        if (weight < 0L) {
            weight += 65536000L;
        }
        DataService svc = this.ctx.service;
        Task.ExecDsp te = new Task.ExecDsp();
        te.dt = dt;
        LocalDateTime dtPeriod = dt.minus(1L, ChronoUnit.HOURS);
        te.periodShift = this.ctx.periods.calcPeriodShift(dtPeriod);
        te.periodHour = Periods.calcPeriodHour(dtPeriod);
        te.dispenserId = this.id;
        te.lineId = this.line.getId();
        te.taskId = this.line.getTaskId();
        te.recipeId = this.line.getRecipeId();
        te.inputProductId = this.tagProductId.getInt();
        te.outputProductId = this.line.getDstProductId();
        te.weight = weight;
        te.sumWeightBeg = weightBeg;
        te.sumWeightEnd = weightEnd;
        svc.saveTaskExecDsp(te);
    }
}

