/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.serial;

import java.nio.charset.Charset;
import java.util.Arrays;
import jssc.SerialPortException;
import jssc.SerialPortTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.SerialPort;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.serial.SerialManagerModule;

public class SerialPortJSSC
implements SerialPort {
    final Logger logger = LoggerFactory.getLogger(SerialPortJSSC.class);
    private static final Charset charset = Charset.forName("windows-1251");
    private volatile boolean valid = true;
    private static final int BUFFIN_SIZE = 2048;
    private byte[] buffin = new byte[2048];
    private int id;
    private int baud;
    private int databits;
    private int parity;
    private int stopbits;
    private int timeout_ms;
    private boolean opened = false;
    private jssc.SerialPort port = null;
    private String portname = "";
    private SerialManagerModule module;
    private TagRW tagOpened;

    public SerialPortJSSC(SerialManagerModule module) {
        this.module = module;
    }

    public synchronized boolean load(Object conf) {
        Configuration cm = EnvironmentInst.get().getConfiguration();
        this.id = cm.get(conf, "id", 0);
        this.baud = cm.get(conf, "baud", 9600);
        this.timeout_ms = cm.get(conf, "timeout", 200);
        this.tagOpened = this.module.getTagOpened(this.id);
        this.portname = cm.get(conf, "sysname", "");
        this.port = new jssc.SerialPort(this.portname);
        String[] bits = cm.get(conf, "bits", "8/0/1").split("/");
        if (bits.length == 3) {
            this.databits = Integer.parseInt(bits[0]);
            this.parity = Integer.parseInt(bits[1]);
            this.stopbits = Integer.parseInt(bits[2]);
        } else {
            this.databits = 8;
            this.parity = 0;
            this.stopbits = 1;
        }
        return true;
    }

    @Override
    public synchronized boolean setParams(int baud, int databits, int parity, int stopbits, int timeout) {
        boolean reopen = false;
        reopen |= baud != this.baud;
        reopen |= databits != this.databits;
        reopen |= parity != this.parity;
        reopen |= stopbits != this.stopbits;
        reopen &= this.opened;
        this.baud = baud;
        this.databits = databits;
        this.parity = parity;
        this.stopbits = stopbits;
        this.timeout_ms = timeout;
        boolean res = true;
        if (reopen) {
            this.close();
            res = this.open();
        }
        return res;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean isOpened() {
        return this.opened;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setInvalid() {
        this.valid = false;
    }

    @Override
    public synchronized boolean open() {
        if (this.opened) {
            return true;
        }
        boolean setup = false;
        try {
            this.opened = this.port.openPort();
            if (!this.opened) {
                EnvironmentInst.get().printError(this.logger, this.module.getName(), "Port not opened", this.portname);
            } else {
                setup = this.port.setParams(this.baud, this.databits, this.stopbits, this.parity);
                if (!setup) {
                    EnvironmentInst.get().printError(this.logger, this.module.getName(), "Error on setParams", this.portname);
                }
            }
        }
        catch (Exception e) {
            EnvironmentInst.get().printError(this.logger, e, this.module.getName(), "Open port:", this.portname);
            this.opened = false;
        }
        if (this.opened && !setup) {
            try {
                this.port.closePort();
            }
            catch (Exception e) {
                EnvironmentInst.get().printError(this.logger, e, this.module.getName(), "Error on closePort", this.portname);
            }
        }
        if (this.opened) {
            this.tagOpened.setReadValInt(1);
        }
        return this.opened;
    }

    @Override
    public synchronized void close() {
        if (!this.opened) {
            return;
        }
        try {
            this.port.closePort();
        }
        catch (Exception e) {
            EnvironmentInst.get().printError(this.logger, e, this.module.getName(), "Close port:", this.portname);
        }
        this.opened = false;
        this.tagOpened.setReadValInt(0);
    }

    @Override
    public int getAvailable() throws Exception {
        return this.port.getInputBufferBytesCount();
    }

    @Override
    public synchronized int readByte() {
        if (!this.opened) {
            return -1;
        }
        try {
            return this.port.readBytes(1, this.timeout_ms)[0] & 0xFF;
        }
        catch (SerialPortException | SerialPortTimeoutException throwable) {
            return -1;
        }
    }

    @Override
    public synchronized int readBytes(int[] buff, int size) {
        if (!this.opened) {
            return 0;
        }
        try {
            byte[] bufftmp = this.port.readBytes(size, this.timeout_ms);
            for (int i = 0; i < size; ++i) {
                buff[i] = bufftmp[i] & 0xFF;
            }
            return size;
        }
        catch (SerialPortException | SerialPortTimeoutException throwable) {
            return 0;
        }
    }

    @Override
    public synchronized int readBytesDelim(int[] buff, int delim) {
        int size;
        block6: {
            if (!this.opened) {
                return 0;
            }
            long time = System.currentTimeMillis();
            int sizemax = buff.length;
            size = 0;
            try {
                block5: {
                    int b;
                    do {
                        if (System.currentTimeMillis() - time >= (long)this.timeout_ms) {
                            return -size;
                        }
                        b = this.port.readBytes(1, this.timeout_ms)[0] & 0xFF;
                        if (size >= sizemax) break block5;
                        buff[size++] = b;
                    } while (b != delim);
                    break block6;
                }
                return -size;
            }
            catch (SerialPortException | SerialPortTimeoutException e) {
                return -size;
            }
        }
        return size;
    }

    @Override
    public synchronized String readString(int size) {
        if (!this.opened) {
            return "";
        }
        try {
            return this.port.readString(size, this.timeout_ms);
        }
        catch (SerialPortException | SerialPortTimeoutException throwable) {
            return "";
        }
    }

    @Override
    public synchronized String readStringDelim(int delim) {
        if (!this.opened) {
            return "";
        }
        long time = System.currentTimeMillis();
        StringBuilder sb = null;
        int i = 0;
        int b = -1;
        try {
            while (true) {
                if (System.currentTimeMillis() - time >= (long)this.timeout_ms) {
                    return "";
                }
                b = this.port.readIntArray(1, this.timeout_ms)[0];
                this.buffin[i++] = (byte)(b & 0xFF);
                if (b != delim) {
                    if (i < 2048) continue;
                    i = 0;
                    if (sb == null) {
                        sb = new StringBuilder();
                    }
                    sb.append(new String(Arrays.copyOf(this.buffin, i), charset));
                    continue;
                }
                break;
            }
        }
        catch (SerialPortException | SerialPortTimeoutException throwable) {
            // empty catch block
        }
        if (sb == null) {
            return new String(Arrays.copyOf(this.buffin, i), charset);
        }
        sb.append(new String(Arrays.copyOf(this.buffin, i)));
        return sb.toString();
    }

    @Override
    public synchronized boolean writeByte(int data) throws Exception {
        if (!this.opened) {
            return false;
        }
        return this.port.writeInt(data);
    }

    @Override
    public synchronized boolean writeBytes(int[] data, int size) throws Exception {
        if (!this.opened) {
            return false;
        }
        if (data.length == size) {
            return this.port.writeIntArray(data);
        }
        return this.port.writeIntArray(Arrays.copyOf(data, size));
    }

    @Override
    public synchronized boolean writeString(String data) throws Exception {
        if (!this.opened) {
            return false;
        }
        return this.port.writeString(data);
    }

    @Override
    public synchronized boolean discard() {
        if (!this.opened) {
            return false;
        }
        try {
            if (this.port.getInputBufferBytesCount() > 0) {
                this.port.readIntArray();
            }
            return true;
        }
        catch (SerialPortException serialPortException) {
            return false;
        }
    }

    @Override
    public String getInfo() {
        return String.format("%d: jssc  %s %d %d/%d/%d %d %s", this.id, this.portname, this.baud, this.databits, this.parity, this.stopbits, this.timeout_ms, this.opened ? "opened" : "closed");
    }
}

