/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.motohr;

import java.sql.SQLException;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.motohr.Context;

public class CounterType {
    public static final int COUNTERTYPE_TOTAL_ID = 1;
    public static final String COUNTERTYPE_TOTAL_DESCR = "\u0412\u0441\u0435\u0433\u043e";
    private final Context ctx;
    public final int id;
    public final String descr;
    public final boolean timer;
    public final TagRW tagDescr;
    public final TagRW tagTimer;

    public CounterType(Context ctx, int id, String descr, boolean timer) {
        this.ctx = ctx;
        this.id = id;
        this.descr = descr;
        this.timer = timer;
        this.tagDescr = ctx.tagtable.createRWString("cnttype." + id + ".descr", descr);
        this.tagTimer = ctx.tagtable.createRWBool("cnttype." + id + ".timer", timer);
    }

    public static void loadAll(Context ctx) throws SQLException {
        ctx.counterTypes.values().forEach(CounterType::remove);
        ctx.counterTypes.clear();
        for (DTO dto : ctx.service.loadCounterTypes()) {
            ctx.counterTypes.put(dto.id, new CounterType(ctx, dto.id, dto.descr, dto.timer));
        }
        if (ctx.counterTypes.keySet().stream().noneMatch(id -> id == 1)) {
            CounterType ct = new CounterType(ctx, 1, COUNTERTYPE_TOTAL_DESCR, false);
            ctx.counterTypes.put(ct.id, ct);
            ctx.service.createCounterType(ct.id, ct.descr, ct.timer);
        }
    }

    public void remove() {
        this.ctx.tagtable.remove(this.tagDescr);
        this.ctx.tagtable.remove(this.tagTimer);
    }

    public static class DTO {
        int id;
        String descr;
        boolean timer;

        public DTO(int id, String descr, boolean timer) {
            this.id = id;
            this.descr = descr;
            this.timer = timer;
        }
    }
}

