/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.motohr;

import java.sql.SQLException;
import java.time.LocalDateTime;
import promauto.jroboplc.core.TagTable;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.motohr.Context;
import promauto.jroboplc.plugin.motohr.Mach;

public class Stat {
    private final Context ctx;
    private TagRW tagPeriod;

    public Stat(Context ctx) {
        this.ctx = ctx;
    }

    public void load() {
        TagTable tt = this.ctx.tagtable;
        Tag[] tagArray = new Tag[1];
        this.tagPeriod = tt.createRWInt("Period", 0);
        tagArray[0] = this.tagPeriod;
        this.ctx.addRepoTags(tagArray);
    }

    public void init() {
    }

    public void execute() throws SQLException {
        int curPeriod = this.getPeriod();
        if (curPeriod != this.tagPeriod.getInt()) {
            for (Mach mach : this.ctx.machs) {
                mach.saveStat(this.tagPeriod.getInt());
            }
        }
        this.tagPeriod.setReadValInt(curPeriod);
    }

    private int getPeriod() {
        LocalDateTime dt = this.ctx.now();
        return dt.getYear() * 10000 + dt.getMonthValue() * 100 + dt.getDayOfMonth();
    }
}

