/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.nio.charset.Charset;
import java.util.function.Function;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.utils.Numbers;

public class ProtocolAscii {
    private static final Charset CHARSET_WIN1251 = Charset.forName("windows-1251");
    private PeripherialModule module;
    protected int[] buffin = null;
    protected int[] buffout = null;
    private final CheckAnswerFunc checkAnswerCenta = size -> {
        boolean res = Numbers.asciiByteToInt(this.buffin, 1) == this.module.netaddr;
        int crc1 = this.calcCrcCenta(this.buffin, (size - 5) / 2);
        int crc2 = Numbers.asciiByteToInt(this.buffin, size - 4);
        res &= crc1 == crc2;
        return res &= this.buffin[size - 2] == 13 && this.buffin[size - 1] == 10;
    };

    public ProtocolAscii(PeripherialModule module) {
        this.module = module;
    }

    public long getAnswerDWord(int idx) {
        return Numbers.asciiDWordToLong(this.buffin, idx);
    }

    public void adjustBuffers(int sizeout, int sizein) {
        if (this.buffout == null || this.buffout.length < sizeout) {
            this.buffout = new int[sizeout];
        }
        if (this.buffin == null || this.buffin.length < sizein) {
            this.buffin = new int[sizein];
        }
    }

    public boolean request(int sizeout, int sizein, CheckAnswerFunc checkAnswer) throws Exception {
        int b = 0;
        for (int trynum = 0; trynum < this.module.retrial; ++trynum) {
            this.module.port.discard();
            this.module.delayBeforeWrite();
            this.module.port.writeBytes(this.buffout, sizeout);
            int cntRead = 0;
            boolean badcrc = false;
            for (int i = 0; i < sizein && (b = this.module.port.readByte()) >= 0; ++i) {
                this.buffin[i] = b;
                ++cntRead;
            }
            if (cntRead == sizein) {
                if (checkAnswer == null || ((Boolean)checkAnswer.apply(sizein)).booleanValue()) {
                    return true;
                }
                badcrc = true;
            }
            if (this.module.canLogError()) {
                byte[] bb = new byte[cntRead];
                for (int i = 0; i < cntRead; ++i) {
                    bb[i] = (byte)(this.buffin[i] & 0xFF);
                }
                String text = new String(bb, CHARSET_WIN1251);
                this.module.logError(trynum, badcrc, this.buffout, sizeout, this.buffin, cntRead, text);
            }
            this.module.delayAfterError();
        }
        this.module.tagErrorCnt.setInt(this.module.tagErrorCnt.getInt() + 1);
        return false;
    }

    private int calcCrcCenta(int[] buff, int size) {
        int sum = 0;
        for (int i = 0; i < size; ++i) {
            sum += Numbers.asciiByteToInt(buff, i * 2 + 1);
        }
        return 256 - (sum & 0xFF);
    }

    public boolean requestCentaRead(int addr) throws Exception {
        int sizeout = 9;
        int sizein = 15;
        this.adjustBuffers(9, 15);
        this.buffout[0] = 35;
        Numbers.intToAsciiByte(this.module.netaddr, this.buffout, 1);
        this.buffout[3] = 48;
        this.buffout[4] = 53;
        Numbers.intToAsciiByte(addr, this.buffout, 5);
        this.buffout[7] = 13;
        this.buffout[8] = 10;
        return this.request(9, 15, this.checkAnswerCenta);
    }

    public boolean requestCentaWrite(int addr, long value) throws Exception {
        int sizeout = 19;
        int sizein = 7;
        this.adjustBuffers(19, 7);
        this.buffout[0] = 35;
        Numbers.intToAsciiByte(this.module.netaddr, this.buffout, 1);
        this.buffout[3] = 48;
        this.buffout[4] = 54;
        Numbers.intToAsciiByte(addr, this.buffout, 5);
        Numbers.longToAsciiDWord(value, this.buffout, 7);
        int crc = this.calcCrcCenta(this.buffout, 7);
        Numbers.intToAsciiByte(crc, this.buffout, 15);
        this.buffout[17] = 13;
        this.buffout[18] = 10;
        return this.request(19, 7, this.checkAnswerCenta);
    }

    public static interface CheckAnswerFunc
    extends Function<Integer, Boolean> {
    }
}

