/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core.tags;

import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagBase;

public class TagCallableInt
extends TagBase {
    private final Callback callback;

    public TagCallableInt(Callback callback, String name, int value) {
        super(name, value);
        this.callback = callback;
    }

    @Override
    public Tag.Type getType() {
        return Tag.Type.INT;
    }

    @Override
    public boolean getBool() {
        return this.callback.getInt() > 0;
    }

    @Override
    public int getInt() {
        return this.callback.getInt();
    }

    @Override
    public long getLong() {
        return this.callback.getInt();
    }

    @Override
    public double getDouble() {
        return this.callback.getInt();
    }

    @Override
    public String getString() {
        return "" + this.callback.getInt();
    }

    @Override
    public String toString() {
        return this.getString();
    }

    @Override
    public void setBool(boolean value) {
        this.callback.setInt(value ? 1 : 0);
    }

    @Override
    public void setOn() {
        this.setInt(1);
    }

    @Override
    public void setOff() {
        this.setInt(0);
    }

    @Override
    public void setInt(int value) {
        this.callback.setInt(value);
    }

    @Override
    public void setLong(long value) {
        this.callback.setInt((int)value);
    }

    @Override
    public void setDouble(double value) {
        this.callback.setInt((int)value);
    }

    @Override
    public void setString(String value) {
        int parsed;
        try {
            parsed = Integer.parseInt(value.trim());
        }
        catch (NumberFormatException e) {
            parsed = 0;
        }
        this.callback.setInt(parsed);
    }

    @Override
    public boolean equalsValue(Tag tag) {
        return tag.getInt() == this.getInt();
    }

    @Override
    public void copyValueTo(Tag tag) {
        tag.setInt(this.getInt());
    }

    public static interface Callback {
        public int getInt();

        public void setInt(int var1);
    }
}

