/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.utils.CRC;
import promauto.utils.Numbers;

public class ProtocolAA55 {
    public static final int CrcAA55 = 0;
    public static final int Crc8 = 1;
    public static final int Crc16 = 2;
    public static final int CrcAA55Word = 3;
    private static final int MULTIREQ_ATTEMPTS_MAX = 10;
    private PeripherialModule module = null;
    private int[] multiBufinp = null;
    public int[] bufinp = null;
    public int bufinpCount = 0;
    private int[] bufout = null;
    private int cntAA;
    private int cntRead;
    private long lastTimeResetCnt = 0L;
    static final int[] pRksDatConv = new int[]{24, 0, 8, 16, 48, 32, 56, 40, 26, 2, 10, 18, 50, 34, 58, 42, 25, 1, 9, 17, 49, 33, 57, 41, 28, 4, 12, 20, 52, 36, 60, 44, 27, 3, 11, 19, 51, 35, 59, 43, 29, 5, 13, 21, 53, 37, 61, 45, 30, 6, 14, 22, 54, 38, 62, 46, 31, 7, 15, 23, 55, 39, 63, 47};

    public ProtocolAA55(PeripherialModule module) {
        this.module = module;
    }

    private void adjustBufinp(int size) {
        if (this.bufinp == null) {
            this.bufinp = new int[size];
        } else if (this.bufinp.length < size) {
            int[] newbufinp = new int[size];
            System.arraycopy(this.bufinp, 0, newbufinp, 0, this.bufinp.length);
            this.bufinp = newbufinp;
        }
    }

    private void adjustBufout(int size) {
        if (this.bufout == null || this.bufout.length < size) {
            this.bufout = new int[size];
        }
    }

    public void writeBytes(int[] data, int size) throws Exception {
        this.writeBytes1(data, size);
        if (this.module.isDebugLogging()) {
            this.module.logDebug(data, size, "");
        }
    }

    private void writeBytes1(int[] data, int size) throws Exception {
        this.adjustBufout(data.length * 2);
        int b = 0;
        int k = 0;
        for (int i = 0; i < size; ++i) {
            b = data[i];
            if (i > 0) {
                if (b == 85) {
                    b = 0;
                    this.bufout[k++] = 170;
                } else if (b == 170) {
                    b = 1;
                    this.bufout[k++] = 170;
                }
            }
            this.bufout[k++] = b;
        }
        this.module.port.writeBytes(this.bufout, k);
    }

    public boolean readBytes(int[] data, int size) throws Exception {
        return this.readBytes(data, 0, size);
    }

    public boolean readBytes(int[] data, int offset, int size) throws Exception {
        int b = 0;
        int i = 0;
        this.cntAA = 0;
        boolean fl = false;
        for (i = 0; i < size && (b = this.module.port.readByte()) >= 0; ++i) {
            if (b == 170) {
                fl = true;
                --i;
                ++this.cntAA;
                continue;
            }
            if (fl) {
                if (b == 0) {
                    b = 85;
                } else if (b == 1) {
                    b = 170;
                }
                fl = false;
            }
            data[offset + i] = b;
        }
        this.cntRead = i;
        return b >= 0;
    }

    public boolean checkCrcAA55(int[] data, int size) {
        int last = size - 1;
        int sum = 0;
        for (int i = 0; i < last; ++i) {
            sum += data[i];
        }
        int a1 = sum + this.module.netaddr & 0xFF;
        int a2 = data[last] & 0xFF;
        return a1 == a2;
    }

    public boolean checkCrcAA55Word(int[] data, int size) {
        int last = size - 2;
        int sum = 0;
        for (int i = 0; i < last; ++i) {
            sum += data[i];
        }
        int a1 = sum + this.module.netaddr & 0xFFFF;
        int a2 = Numbers.bytesToWord(data, last);
        return a1 == a2;
    }

    public boolean checkCrc8(int[] data, int size) {
        int a2;
        int a1 = CRC.getCrc8(data, 0, size - 2);
        return a1 == (a2 = data[size - 1] & 0xFF);
    }

    public boolean checkCrc16(int[] data, int size) {
        int a2;
        int a1 = CRC.getCrc16(data, 0, size - 3);
        return a1 == (a2 = Numbers.bytesToWord(data, size - 2));
    }

    public void setCrcAA55(int[] data, int size) {
        int last = size - 1;
        int sum = 0;
        for (int i = 2; i < last; ++i) {
            sum += data[i];
        }
        data[last] = sum + this.module.netaddr & 0xFF;
    }

    public boolean multiRequest(int[] dataout, int sizeout, int[] datain, int sizein, int sizeMultiReq, int crctype) throws Exception {
        sizeMultiReq = Math.min(sizeMultiReq, sizein);
        if (this.multiBufinp == null || this.multiBufinp.length < sizeMultiReq) {
            this.multiBufinp = new int[sizeMultiReq];
        }
        for (int i = 0; i < 10 && this.request(dataout, sizeout, datain, sizein, crctype); ++i) {
            if (i > 0) {
                if (Numbers.compareIntArrays(datain, this.multiBufinp, sizeMultiReq)) {
                    return true;
                }
                if (this.module.canLogError()) {
                    this.module.logError(i, false, dataout, sizeout, datain, this.cntRead, "multiReq Error");
                }
            }
            System.arraycopy(datain, 0, this.multiBufinp, 0, sizeMultiReq);
        }
        return false;
    }

    public boolean multiRequest(int[] dataout, int sizeout) throws Exception {
        for (int i = 0; i < 10 && this.request(dataout, sizeout); ++i) {
            if (i > 0) {
                if (Numbers.compareIntArrays(this.bufinp, this.multiBufinp, this.bufinpCount)) {
                    return true;
                }
                if (this.module.canLogError()) {
                    this.module.logError(i, false, dataout, sizeout, this.bufinp, this.bufinpCount, "multiReq Error");
                }
            }
            if (this.multiBufinp == null || this.multiBufinp.length < this.bufinpCount) {
                this.multiBufinp = new int[this.bufinpCount];
            }
            System.arraycopy(this.bufinp, 0, this.multiBufinp, 0, this.bufinpCount);
        }
        return false;
    }

    public boolean request(int[] dataout, int sizeout, int[] datain, int sizein, int crctype) throws Exception {
        for (int trynum = 0; trynum < this.module.retrial; ++trynum) {
            boolean badcrc = false;
            this.module.port.discard();
            this.module.delayBeforeWrite();
            this.writeBytes(dataout, sizeout);
            boolean res = this.readBytes(datain, sizein);
            if (res) {
                if (crctype == 0) {
                    res = this.checkCrcAA55(datain, sizein);
                } else if (crctype == 1) {
                    res = this.checkCrc8(datain, sizein);
                } else if (crctype == 2) {
                    res = this.checkCrc16(datain, sizein);
                } else if (crctype == 3) {
                    res = this.checkCrcAA55Word(datain, sizein);
                }
                boolean bl = badcrc = !res;
            }
            if (this.module.isDebugLogging()) {
                this.module.logDebug(dataout, sizeout, datain, this.cntRead, (!res ? " err" : "") + (badcrc ? " crc" : ""));
            }
            if (res) {
                return true;
            }
            if (this.module.canLogError()) {
                this.module.logError(trynum, badcrc, dataout, sizeout, datain, this.cntRead, "cntAA=" + this.cntAA);
            }
            this.module.delayAfterError();
        }
        this.module.tagErrorCnt.setInt(this.module.tagErrorCnt.getInt() + 1);
        return false;
    }

    public boolean request(int[] dataout, int sizeout) throws Exception {
        for (int trynum = 0; trynum < this.module.retrial; ++trynum) {
            boolean badcrc = false;
            this.module.port.discard();
            this.module.delayBeforeWrite();
            this.writeBytes(dataout, sizeout);
            this.module.port.discard();
            this.bufinpCount = 0;
            this.adjustBufinp(2);
            boolean res = this.readBytes(this.bufinp, 2);
            if (res) {
                int size = this.bufinp[1];
                this.bufinpCount = size + 2;
                this.adjustBufinp(this.bufinpCount);
                res = this.readBytes(this.bufinp, 2, size);
                if (res) {
                    res = this.checkCrc16(this.bufinp, this.bufinpCount);
                    boolean bl = badcrc = !res;
                }
            }
            if (this.module.isDebugLogging()) {
                this.module.logDebug(dataout, sizeout, this.bufinp, this.cntRead, (!res ? " err" : "") + (badcrc ? " crc" : ""));
            }
            if (res) {
                return true;
            }
            if (this.module.canLogError()) {
                this.module.logError(trynum, badcrc, dataout, sizeout, this.bufinp, this.cntRead, "cntAA=" + this.cntAA);
            }
            this.module.delayAfterError();
        }
        this.module.tagErrorCnt.setInt(this.module.tagErrorCnt.getInt() + 1);
        return false;
    }

    public String requestString(int cmd) throws Exception {
        this.adjustBufout(6);
        this.bufout[0] = 85;
        this.bufout[1] = 239;
        this.bufout[2] = Numbers.hexDigit[this.module.netaddr >> 4 & 0xF];
        this.bufout[3] = Numbers.hexDigit[this.module.netaddr & 0xF];
        this.bufout[4] = cmd;
        this.bufout[5] = 13;
        for (int trynum = 0; trynum < this.module.retrial; ++trynum) {
            boolean res;
            this.module.port.discard();
            this.module.delayBeforeWrite();
            this.module.port.writeBytes(this.bufout, 6);
            this.module.port.discard();
            String answer = this.module.port.readStringDelim(13);
            boolean bl = res = !answer.isEmpty();
            if (this.module.isDebugLogging()) {
                this.module.logDebug(this.bufout, 6, '\"' + answer + '\"' + (!res ? " err" : ""));
            }
            if (res) {
                return answer;
            }
            if (this.module.canLogError()) {
                this.module.logError(trynum, false, this.bufout, 6, this.bufinp, 0, "requestString: " + answer);
            }
            this.module.delayAfterError();
        }
        this.module.tagErrorCnt.setInt(this.module.tagErrorCnt.getInt() + 1);
        return "";
    }

    public boolean requestFirmware(TagRW tag) throws Exception {
        String answer = this.requestString(77);
        if (answer.length() < 3) {
            if (this.module.canLogError()) {
                this.module.logError(0, false, this.bufout, 0, this.bufinp, 0, "requestFirmware error0: " + answer);
            }
            this.module.tagErrorCnt.setInt(this.module.tagErrorCnt.getInt() + 1);
            return false;
        }
        try {
            int netaddr = Integer.parseInt(answer.substring(1, 3), 16);
            if (answer.charAt(0) != '!' || netaddr != this.module.netaddr) {
                if (this.module.canLogError()) {
                    this.module.logError(0, false, this.bufout, 0, this.bufinp, 0, "requestFirmware error1: " + answer);
                }
                this.module.tagErrorCnt.setInt(this.module.tagErrorCnt.getInt() + 1);
                return false;
            }
        }
        catch (NumberFormatException e) {
            if (this.module.canLogError()) {
                this.module.logError(0, false, this.bufout, 0, this.bufinp, 0, "requestFirmware error2: " + answer);
            }
            this.module.tagErrorCnt.setInt(this.module.tagErrorCnt.getInt() + 1);
            return false;
        }
        tag.setReadValString(answer.substring(3, answer.length() - 1));
        return true;
    }

    public boolean requestResetCnt(Tag tag, int resetCntPeriod) throws Exception {
        if (resetCntPeriod == 0 || System.currentTimeMillis() - this.lastTimeResetCnt < (long)resetCntPeriod) {
            return true;
        }
        String answer = this.requestString(82);
        if (answer.length() < 3) {
            if (this.module.canLogError()) {
                this.module.logError(0, false, this.bufout, 0, this.bufinp, 0, "requestResetCnt error1: " + answer);
            }
            this.module.tagErrorCnt.setInt(this.module.tagErrorCnt.getInt() + 1);
            return false;
        }
        try {
            tag.setInt(Integer.parseInt(answer.substring(2, answer.length() - 1), 16));
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            if (this.module.canLogError()) {
                this.module.logError(0, false, this.bufout, 0, this.bufinp, 0, "requestResetCnt error2: " + answer);
            }
            this.module.tagErrorCnt.setInt(this.module.tagErrorCnt.getInt() + 1);
            return false;
        }
        this.lastTimeResetCnt = System.currentTimeMillis();
        return true;
    }
}

