/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.utils.CRC;

public class ProtocolMercury {
    private final PeripherialModule module;
    protected int[] buffin = null;
    protected int[] buffout = null;

    public ProtocolMercury(PeripherialModule module) {
        this.module = module;
    }

    public boolean requestAuthOpen(int password) throws Exception {
        this.adjustBuffers(11, 4);
        this.buffout[0] = this.module.netaddr;
        this.buffout[1] = 1;
        this.buffout[2] = 2;
        for (int i = 0; i < 6; ++i) {
            this.buffout[8 - i] = password % 10;
            password /= 10;
        }
        return this.request(11, 4);
    }

    public boolean requestAuthClose() throws Exception {
        this.adjustBuffers(4, 4);
        this.buffout[0] = this.module.netaddr;
        this.buffout[1] = 2;
        return this.request(4, 4);
    }

    public boolean requestInfo() throws Exception {
        this.adjustBuffers(5, 19);
        this.buffout[0] = this.module.netaddr;
        this.buffout[1] = 8;
        this.buffout[2] = 1;
        return this.request(5, 19);
    }

    public boolean requestEnergy() throws Exception {
        this.adjustBuffers(6, 19);
        this.buffout[0] = this.module.netaddr;
        this.buffout[1] = 5;
        this.buffout[2] = 0;
        this.buffout[3] = 0;
        return this.request(6, 19);
    }

    public long getUInt32(int pos) {
        return ((long)this.buffin[pos] << 16) + ((long)this.buffin[pos + 1] << 24) + (long)this.buffin[pos + 2] + ((long)this.buffin[pos + 3] << 8);
    }

    public int getByte(int pos) {
        return this.buffin[pos];
    }

    public void adjustBuffers(int sizeout, int sizein) {
        if (this.buffout == null || this.buffout.length < sizeout) {
            this.buffout = new int[sizeout];
        }
        if (this.buffin == null || this.buffin.length < sizein) {
            this.buffin = new int[sizein];
        }
    }

    private boolean request(int sizeout, int sizein) throws Exception {
        int crc = CRC.getCrc16(this.buffout, sizeout - 2);
        this.buffout[sizeout - 2] = crc & 0xFF;
        this.buffout[sizeout - 1] = crc >> 8 & 0xFF;
        boolean b = false;
        for (int trynum = 0; trynum < this.module.retrial; ++trynum) {
            this.module.port.discard();
            this.module.delayBeforeWrite();
            this.module.port.writeBytes(this.buffout, sizeout);
            boolean badcrc = false;
            int cntRead = this.module.port.readBytes(this.buffin, sizein);
            if (cntRead == sizein) {
                int crc2;
                int crc1 = CRC.getCrc16(this.buffin, sizein - 2);
                boolean bl = badcrc = crc1 != (crc2 = this.buffin[sizein - 1] << 8 | this.buffin[sizein - 2]);
                if (!badcrc && this.buffout[0] == this.buffin[0]) {
                    if (this.module.canLogReq()) {
                        this.module.logReq(this.buffout, sizeout, this.buffin, sizein);
                    }
                    return true;
                }
            }
            if (this.module.canLogError()) {
                this.module.logError(trynum, badcrc, this.buffout, sizeout, this.buffin, cntRead, "");
            }
            this.module.delayAfterError();
        }
        this.module.tagErrorCnt.setInt(this.module.tagErrorCnt.getInt() + 1);
        return false;
    }
}

