/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.rpsvrtcp;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Environment;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Module;
import promauto.jroboplc.core.api.Signal;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.api.TcpServerChannel;
import promauto.jroboplc.plugin.rpsvrtcp.RpsvrtcpModule;
import promauto.utils.CRC;
import promauto.utils.Numbers;
import promauto.utils.Strings;

public class RpsvrtcpClient
implements Signal.Listener {
    private final Logger logger = LoggerFactory.getLogger(RpsvrtcpClient.class);
    private static final Charset charset = Charset.forName("UTF-8");
    private Environment env;
    private static final int ANSWER_LENGTH_MAX = 8000;
    private static final int ANSWER_LENGTH_MAX_32 = 7968;
    protected String tagFilter = "*";
    private List<ClientTag> cltags = new ArrayList<ClientTag>();
    private int cltagcount;
    protected RpsvrtcpModule module;
    private String crcTagValues;
    private int[] buffCrcTagValuesH;
    private int[] buffCrcTagValuesL;
    private StringBuilder sb = new StringBuilder();
    private String clientAddress;
    private volatile boolean hasMessageReload = false;

    public RpsvrtcpClient(RpsvrtcpModule module, String clientAddress) {
        this.env = EnvironmentInst.get();
        this.module = module;
        this.clientAddress = clientAddress;
    }

    public String cmdSETFILTER(String reqbody) {
        this.tagFilter = reqbody.replace('\'', ' ').trim();
        return "101 OK\r\n";
    }

    public String cmdGETFILTER() {
        return "102 '" + this.tagFilter + "'\r\n";
    }

    public String cmdCREATETAGLIST() {
        this.cltags = new ArrayList<ClientTag>(this.collectClientTags());
        this.cltagcount = this.cltags.size();
        this.addAsSignalListerToAllOthers();
        this.hasMessageReload = false;
        return "103 " + Numbers.toHexString(this.cltags.size()) + "\r\n";
    }

    private List<ClientTag> collectClientTags() {
        Pattern filter = Strings.getFilterPattern(this.tagFilter, ";");
        LinkedList<ClientTag> list = new LinkedList<ClientTag>();
        for (Module m : this.env.getModuleManager().getModules()) {
            boolean hasCompatibilityFlagHidden = this.module.isFlagCompatibleWith("HIDDEN", m);
            boolean hasCompatibilityFlagExternal = this.module.isFlagCompatibleWith("EXTERNAL", m);
            boolean transparent = this.module.transparentModules.contains(m.getName()) && hasCompatibilityFlagExternal;
            String flagSkipModName = m.getFlag("RPSVRTCP.SKIPMODNAME");
            boolean modeSkipModNameAll = flagSkipModName.equals("ALL");
            boolean modeSkipModNameExternal = flagSkipModName.equals("EXTERNAL");
            for (Tag tag : m.getTagTable().values()) {
                if (tag.getType() == Tag.Type.STRING || !this.module.hiddentags && hasCompatibilityFlagHidden && tag.hasFlags(2)) continue;
                boolean skipModuleName = false;
                if (transparent && tag.hasFlags(4)) {
                    skipModuleName = true;
                } else if (modeSkipModNameAll || modeSkipModNameExternal && tag.hasFlags(4)) {
                    skipModuleName = true;
                }
                String tagname = this.getTagname(m, skipModuleName, tag);
                if (filter != null && !filter.matcher(tagname).matches() || this.module.incl != null && !this.module.incl.matcher(tagname).matches() || this.module.excl != null && this.module.excl.matcher(tagname).matches()) continue;
                list.add(new ClientTag(m, skipModuleName, tag));
            }
        }
        return list;
    }

    private String getTagname(ClientTag cltag) {
        return this.getTagname(cltag.module, cltag.skipModuleName, cltag.tag);
    }

    private String getTagname(Module m, boolean skipModuleName, Tag tag) {
        return (skipModuleName ? "" : m.getName() + ".") + tag.getName();
    }

    public String cmdGETTAGLIST(String reqbody) {
        this.sb.setLength(0);
        try {
            int i;
            int offset = Integer.parseInt(reqbody, 16);
            int size = this.cltags.size();
            int n = 0;
            this.sb.append('#');
            this.sb.append(Numbers.toHexString(offset));
            this.sb.append('!');
            boolean flag = false;
            for (i = offset; i < size && this.sb.length() <= 7968; ++i) {
                if (flag) {
                    this.sb.append(';');
                } else {
                    flag = true;
                }
                this.sb.append(this.getTagname(this.cltags.get(i)));
                ++n;
            }
            this.sb.insert(0, Numbers.toHexString(n));
            int crc = CRC.getCrc16(this.sb.toString().getBytes(charset));
            this.sb.append(i == size ? (char)'=' : '~');
            this.sb.append(Numbers.toHexString(crc));
            this.sb.append("\r\n");
            this.sb.insert(0, "104 ");
        }
        catch (NumberFormatException e) {
            return "?\r\n";
        }
        return this.sb.toString();
    }

    public String cmdFIXALL() {
        if (this.buffCrcTagValuesH == null || this.buffCrcTagValuesH.length != this.cltags.size()) {
            this.buffCrcTagValuesH = new int[this.cltags.size()];
            this.buffCrcTagValuesL = new int[this.cltags.size()];
        }
        int n = 0;
        int i = 0;
        for (ClientTag cltag : this.cltags) {
            int v = cltag.tag.getInt();
            if (cltag.fixval != v) {
                cltag.fixval = v;
                cltag.state = 1;
            }
            if (cltag.state == 1) {
                ++n;
            } else if (cltag.state == 2) {
                cltag.state = 0;
            }
            this.buffCrcTagValuesH[i] = v >> 8 & 0xFF;
            this.buffCrcTagValuesL[i] = v & 0xFF;
            ++i;
        }
        long crcH = CRC.getCrc16(this.buffCrcTagValuesH, this.cltags.size());
        long crcL = CRC.getCrc16(this.buffCrcTagValuesL, this.cltags.size());
        long crc = (crcH << 16) + crcL;
        this.sb.setLength(0);
        for (int j = 0; j < 8; ++j) {
            this.sb.insert(0, Numbers.hexDigitChar[(int)(crc & 0xFL)]);
            crc >>>= 4;
        }
        this.crcTagValues = this.sb.toString();
        return "105 " + Numbers.toHexString(n) + "\r\n";
    }

    public String cmdGETCRC() {
        return "118 " + this.crcTagValues + "\r\n";
    }

    public String cmdGETMSG() {
        this.sb.setLength(0);
        this.sb.append("119 ");
        if (this.hasMessageReload) {
            this.sb.append("RELOAD");
        }
        this.sb.append("\r\n");
        return this.sb.toString();
    }

    public String cmdGETALL(String reqbody) {
        this.sb.setLength(0);
        try {
            int i;
            int offset = Integer.parseInt(reqbody, 16);
            int size = this.cltags.size();
            int n = 0;
            this.sb.append('#');
            this.sb.append(Numbers.toHexString(offset));
            this.sb.append('!');
            boolean flag = false;
            for (i = offset; i < size && this.sb.length() <= 7968; ++i) {
                if (flag) {
                    this.sb.append(';');
                } else {
                    flag = true;
                }
                if (this.cltags.get((int)i).fixval != 0) {
                    if (this.cltags.get((int)i).fixval < 0) {
                        this.sb.append('-');
                        this.sb.append(Numbers.toHexString(Math.abs(this.cltags.get((int)i).fixval)));
                    } else {
                        this.sb.append(Numbers.toHexString(this.cltags.get((int)i).fixval));
                    }
                }
                ++n;
            }
            this.sb.insert(0, Numbers.toHexString(n));
            int crc = CRC.getCrc16(this.sb.toString().getBytes(charset));
            this.sb.append(i == size ? (char)'=' : '~');
            this.sb.append(Numbers.toHexString(crc));
            this.sb.append("\r\n");
            this.sb.insert(0, "106 ");
        }
        catch (NumberFormatException e) {
            return "?\r\n";
        }
        return this.sb.toString();
    }

    public String cmdGETCHG(String reqbody) {
        this.sb.setLength(0);
        try {
            int i;
            int offset = Integer.parseInt(reqbody, 16);
            int size = this.cltags.size();
            int n = 0;
            StringBuilder ssb = null;
            boolean flag = false;
            for (i = offset; i < size; ++i) {
                if (this.cltags.get((int)i).state == 0) {
                    if (ssb == null) continue;
                    this.sb.append((CharSequence)ssb);
                    ssb = null;
                    continue;
                }
                if (this.sb.length() + (ssb == null ? 0 : ssb.length()) > 7968) break;
                if (ssb == null) {
                    ssb = new StringBuilder();
                    ssb.append('#');
                    ssb.append(Numbers.toHexString(i));
                    ssb.append('!');
                    flag = false;
                }
                if (flag) {
                    ssb.append(';');
                } else {
                    flag = true;
                }
                this.cltags.get((int)i).state = 2;
                if (this.cltags.get((int)i).fixval != 0) {
                    if (this.cltags.get((int)i).fixval < 0) {
                        ssb.append('-');
                        ssb.append(Numbers.toHexString(Math.abs(this.cltags.get((int)i).fixval)));
                    } else {
                        ssb.append(Numbers.toHexString(this.cltags.get((int)i).fixval));
                    }
                }
                ++n;
            }
            if (ssb != null) {
                this.sb.append((CharSequence)ssb);
            }
            this.sb.insert(0, Numbers.toHexString(n));
            int crc = CRC.getCrc16(this.sb.toString().getBytes(charset));
            this.sb.append(i == size ? (char)'=' : '~');
            this.sb.append(Numbers.toHexString(crc));
            this.sb.append("\r\n");
            this.sb.insert(0, "107 ");
        }
        catch (NumberFormatException e) {
            return "?\r\n";
        }
        return this.sb.toString();
    }

    public String cmdWNM(String reqbody) {
        try {
            int k1 = reqbody.indexOf(32);
            int k2 = reqbody.indexOf(32, k1 + 1);
            int crc1 = CRC.getCrc16(reqbody.substring(0, k2).getBytes(charset));
            String crcstr = reqbody.substring(k2 + 1);
            int crc2 = crcstr.equals("****") ? crc1 : Integer.parseInt(crcstr, 16);
            int index = Integer.parseInt(reqbody.substring(0, k1), 16);
            Integer value = Integer.parseInt(reqbody.substring(k1 + 1, k2), 16);
            if (crc1 != crc2) {
                throw new NumberFormatException();
            }
            if (index >= 0 && index < this.cltagcount) {
                if (this.module.debugInfoWrite && this.module.debugConsole != null) {
                    Tag tag = this.cltags.get((int)index).tag;
                    this.module.debugConsole.print(this.module.getName() + " write: " + this.cltags.get((int)index).module.getName() + ":" + tag.getName() + " = " + tag.getInt() + " -> " + value + "\r\n");
                }
                this.cltags.get((int)index).tag.setInt(value);
            }
            return "109 !\r\n";
        }
        catch (NumberFormatException e) {
            return "109 ?\r\n";
        }
    }

    public String cmdGETPROPS(String reqbody) {
        this.sb.setLength(0);
        try {
            int i;
            int offset = Integer.parseInt(reqbody, 16);
            int size = this.cltags.size();
            int n = 0;
            this.sb.append('#');
            this.sb.append(Numbers.toHexString(offset));
            this.sb.append('!');
            boolean flag = false;
            for (i = offset; i < size && this.sb.length() <= 7968; ++i) {
                if (flag) {
                    this.sb.append(';');
                } else {
                    flag = true;
                }
                Tag auxtag = (Tag)this.cltags.get((int)i).tag.getObject();
                if (auxtag != null && auxtag.getName().equals("IRR")) {
                    this.sb.append('1');
                }
                ++n;
            }
            this.sb.insert(0, Numbers.toHexString(n));
            int crc = CRC.getCrc16(this.sb.toString().getBytes(charset));
            this.sb.append(i == size ? (char)'=' : '~');
            this.sb.append(Numbers.toHexString(crc));
            this.sb.append("\r\n");
            this.sb.insert(0, "116 ");
        }
        catch (NumberFormatException e) {
            return "?\r\n";
        }
        return this.sb.toString();
    }

    public String cmdSETFLAG(String reqbody) {
        try {
            Tag auxtag;
            int k1 = reqbody.indexOf(32);
            int k2 = reqbody.indexOf(32, k1 + 1);
            int crc1 = CRC.getCrc16(reqbody.substring(0, k2).getBytes(charset));
            String crcstr = reqbody.substring(k2 + 1);
            int crc2 = crcstr.equals("****") ? crc1 : Integer.parseInt(crcstr, 16);
            int index = Integer.parseInt(reqbody.substring(0, k1), 16);
            Integer value = Integer.parseInt(reqbody.substring(k1 + 1, k2), 16);
            if (crc1 != crc2) {
                throw new NumberFormatException();
            }
            if (index >= 0 && index < this.cltagcount && (auxtag = (Tag)this.cltags.get((int)index).tag.getObject()) != null && auxtag.getName().equals("IRR")) {
                auxtag.setInt(value);
                if (this.module.infoSetFlag) {
                    this.env.printInfo(this.logger, this.module.getName(), "SETFLAG " + this.cltags.get((int)index).tag.getName() + " " + value);
                }
                return "117 !\r\n";
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return "117 ?\r\n";
    }

    public void onRequest(TcpServerChannel channel, String request) {
        String reqcmd = "";
        String reqbody = "";
        String answer = null;
        int k = request.indexOf(32);
        int l = request.length();
        if (k > 0) {
            reqcmd = request.substring(0, k);
            if (k < l) {
                reqbody = request.substring(k + 1, l);
            }
        } else {
            reqcmd = request;
        }
        switch (reqcmd) {
            case "FIXALL": {
                answer = this.cmdFIXALL();
                break;
            }
            case "GETCHG": {
                answer = this.cmdGETCHG(reqbody);
                break;
            }
            case "WNM": {
                answer = this.cmdWNM(reqbody);
                break;
            }
            case "GETALL": {
                answer = this.cmdGETALL(reqbody);
                break;
            }
            case "CREATETAGLIST": {
                answer = this.cmdCREATETAGLIST();
                break;
            }
            case "GETTAGLIST": {
                answer = this.cmdGETTAGLIST(reqbody);
                break;
            }
            case "SETFILTER": {
                answer = this.cmdSETFILTER(reqbody);
                break;
            }
            case "GETFILTER": {
                answer = this.cmdGETFILTER();
                break;
            }
            case "GETPROPS": {
                answer = this.cmdGETPROPS(reqbody);
                break;
            }
            case "SETFLAG": {
                answer = this.cmdSETFLAG(reqbody);
                break;
            }
            case "GETCRC": {
                answer = this.cmdGETCRC();
                break;
            }
            case "GETMSG": {
                answer = this.cmdGETMSG();
                break;
            }
            default: {
                answer = "400 NOT SUPPORTED\r\n";
            }
        }
        channel.write(answer);
    }

    public String getInfo() {
        return this.clientAddress + " tags=" + this.cltagcount + " filter=" + this.tagFilter;
    }

    @Override
    public void onSignal(Module sender, Signal signal) {
        if (signal.type == Signal.SignalType.RELOADED) {
            List<ClientTag> list = this.collectClientTags();
            if (this.cltags.size() != list.size()) {
                this.hasMessageReload = true;
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    if (list.get((int)i).tag == this.cltags.get((int)i).tag) continue;
                    this.hasMessageReload = true;
                    break;
                }
            }
        }
    }

    public void release() {
        this.removeAsSignalListerFromAllOthers();
    }

    List<ClientTag> getCltags() {
        return this.cltags;
    }

    void addCltag(ClientTag cltag) {
        this.cltags.add(cltag);
        this.cltagcount = this.cltags.size();
    }

    public static class ClientTag {
        public Module module;
        public Tag tag;
        public Integer fixval;
        public boolean skipModuleName;
        public int state;

        public ClientTag(Module module, boolean skipModuleName, Tag tag) {
            this.module = module;
            this.tag = tag;
            this.fixval = 0;
            this.state = 1;
            this.skipModuleName = skipModuleName;
        }
    }
}

