/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.script.utils;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import promauto.jroboplc.core.api.Database;
import promauto.jroboplc.core.tags.Ref;
import promauto.jroboplc.plugin.script.ScriptJava;

public class SqlToCsvExportScript
extends ScriptJava {
    private static final int MAX_FILES_IN_DIR = 256;
    private static final DateTimeFormatter dtFormatter = DateTimeFormatter.ofPattern("_yyyyMMdd_HHmmss");
    Ref tagPeriod;
    Ref tagStart;
    Ref tagSchedule;
    Database db;
    String dbname;
    String sql;
    String filename;
    String table;
    String tableExp;
    int fieldId;
    boolean connected;
    private final List<Integer> times = new ArrayList<Integer>();

    @Override
    public boolean load() {
        this.tagStart = this.createTag("start", 0);
        this.tagPeriod = this.createTag("period", 0, 1);
        this.table = this.getArg("table", "");
        this.tableExp = this.getArg("tableExp", this.table + "_EXP");
        this.dbname = this.getArg("db", "db");
        this.db = null;
        this.sql = this.getArg("sql", "");
        this.filename = this.getArg("filename", "export");
        this.fieldId = this.getArg("fieldId", 1);
        this.times.clear();
        Matcher m = Pattern.compile("\\s*(\\d+)\\s*").matcher(this.getArg("schedule", ""));
        while (m.find()) {
            this.times.add(Integer.parseInt(m.group(1)));
        }
        this.tagSchedule = this.createRWTag("schedule", this.times.stream().map(String::valueOf).collect(Collectors.joining(";")));
        return true;
    }

    @Override
    public boolean prepare() {
        this.connected = false;
        this.db = this.getDatabase(this.dbname);
        if (this.db == null) {
            this.printError("Database module is not found: " + this.dbname);
            return false;
        }
        return true;
    }

    public int calcPeriod(LocalDateTime dt) {
        int j;
        int hhmm = dt.getHour() * 100 + dt.getMinute();
        int i = this.times.size();
        for (j = 0; j < this.times.size() && hhmm >= this.times.get(j); ++j) {
            i = j + 1;
        }
        if (j < i) {
            dt = dt.minusDays(1L);
        }
        return dt.getYear() * 100000 + dt.getMonthValue() * 1000 + dt.getDayOfMonth() * 10 + i;
    }

    @Override
    public void execute() {
        if (!this.db.isConnected()) {
            return;
        }
        if (!this.connected) {
            this.connected = true;
            try (Statement st = this.db.getConnection().createStatement();){
                if (!this.db.hasTable(st, "", this.tableExp)) {
                    String sql = String.format("create table %s (id integer constraint fk_%s references %s on delete cascade on update cascade, period integer)", this.tableExp, this.tableExp, this.table);
                    st.executeUpdate(sql);
                    this.printInfo(String.format("Table %s has been created", this.tableExp));
                }
                this.db.getConnection().commit();
            }
            catch (SQLException e) {
                this.printError(e, "Table create error");
            }
        }
        LocalDateTime dt = LocalDateTime.now();
        int period = this.calcPeriod(dt);
        if (this.tagStart.getInt() == 0 && period == this.tagPeriod.getInt()) {
            return;
        }
        this.tagStart.setInt(0);
        this.tagPeriod.setInt(period);
        String filenameCsv = this.filename + dt.format(dtFormatter) + ".csv";
        String filenameTmp = filenameCsv + ".tmp";
        filenameCsv = this.makeFilenameNotExists(filenameCsv);
        filenameTmp = this.makeFilenameNotExists(filenameTmp);
        if (this.hasTooManyFiles()) {
            this.printInfo("Too many files in the directory!");
            return;
        }
        int n = 0;
        boolean res = false;
        try (Statement st = this.db.getConnection().createStatement();
             FileOutputStream os = new FileOutputStream(filenameTmp);){
            TreeSet<Long> ids = null;
            try (ResultSet rs = st.executeQuery(this.sql);){
                while (rs.next()) {
                    if (ids == null) {
                        ids = new TreeSet<Long>();
                    }
                    ids.add(rs.getLong(this.fieldId));
                    StringBuilder sb = new StringBuilder();
                    for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                        if (i > 1) {
                            sb.append(';');
                        }
                        sb.append(rs.getString(i));
                    }
                    sb.append("\r\n");
                    os.write(sb.toString().getBytes(StandardCharsets.UTF_8));
                    ++n;
                }
            }
            if (ids != null) {
                for (Long id : ids) {
                    st.executeUpdate(String.format("insert into %s (id, period) values (%d, %d)", this.tableExp, id, period));
                }
            }
            this.db.getConnection().commit();
            this.printInfo(String.format("%d: Exported %d records into %s", period, n, filenameCsv));
            res = true;
        }
        catch (Exception e) {
            this.printError(e, "Request error");
        }
        try {
            Path tmp = Paths.get(filenameTmp, new String[0]);
            Path csv = Paths.get(filenameCsv, new String[0]);
            if (res) {
                Files.move(tmp, csv, new CopyOption[0]);
            } else {
                Files.delete(tmp);
            }
        }
        catch (IOException e) {
            this.printError(e, "File error");
        }
    }

    private boolean hasTooManyFiles() {
        Path p = Paths.get(this.filename, new String[0]).getParent();
        if (p == null) {
            return false;
        }
        int cnt = 0;
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(p);){
            for (Path ignored : ds) {
                ++cnt;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return cnt >= 256;
    }

    private String makeFilenameNotExists(String filename) {
        int i = 1;
        while (Files.exists(Paths.get(filename, new String[0]), new LinkOption[0])) {
            filename = filename + i;
        }
        return filename;
    }
}

