/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.serial;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.plugin.serial.SerialManagerModule;
import promauto.jroboplc.plugin.serial.SerialPortUsriot;

public class SerialPortRfc2217
extends SerialPortUsriot {
    private static final int IAC = 255;
    private static final int SB = 250;
    private static final int SE = 240;
    private static final int COM_PORT_OPTION = 44;
    private static final int SET_BAUDRATE = 1;
    private static final int SET_DATASIZE = 2;
    private static final int SET_PARITY = 3;
    private static final int SET_STOPSIZE = 4;

    public SerialPortRfc2217(SerialManagerModule module) {
        super(module);
    }

    public void setBaudRate(int baud) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(ByteOrder.BIG_ENDIAN);
        buf.putInt(baud);
        this.sendSubnegotiation(1, buf.array());
    }

    public void setDataBits(int dataBits) throws IOException {
        this.sendSubnegotiation(2, new byte[]{(byte)dataBits});
    }

    public void setParity(int parity) throws IOException {
        this.sendSubnegotiation(3, new byte[]{(byte)parity});
    }

    public void setStopBits(int stopBits) throws IOException {
        this.sendSubnegotiation(4, new byte[]{(byte)stopBits});
    }

    private void sendSubnegotiation(int command, byte[] payload) throws IOException {
        ByteArrayOutputStream frame = new ByteArrayOutputStream();
        frame.write(255);
        frame.write(250);
        frame.write(44);
        frame.write(command);
        frame.write(payload);
        frame.write(255);
        frame.write(240);
        this.outputData.write(frame.toByteArray());
        this.outputData.flush();
    }

    @Override
    protected boolean applyParams() {
        try {
            this.setBaudRate(this.baud);
            this.setDataBits(this.databits);
            this.setParity(this.parity + 1);
            this.setStopBits(this.stopbits);
        }
        catch (Exception e) {
            EnvironmentInst.get().printError(this.logger, e, this.module.getName(), "Apply params:", this.getDescr());
            return false;
        }
        return true;
    }

    @Override
    public synchronized int readByte() {
        if (!this.restoreConnectionIfLost() || !this.opened) {
            return -1;
        }
        try {
            int b = this.inputData.read();
            if (b == 255) {
                b = this.inputData.read();
            }
            this.affirmLiveness();
            return b;
        }
        catch (IOException e) {
            this.checkLiveness();
            return -1;
        }
    }

    @Override
    public synchronized int readBytes(int[] buff, int size) {
        if (!this.restoreConnectionIfLost() || !this.opened) {
            return 0;
        }
        long time = System.currentTimeMillis();
        int n = 0;
        try {
            do {
                if (System.currentTimeMillis() - time >= (long)this.timeout_ms) {
                    throw new IOException("timeout");
                }
                int b = this.inputData.read();
                if (b == 255) {
                    b = this.inputData.read();
                }
                buff[n++] = b;
            } while (n != size);
        }
        catch (IOException e) {
            this.checkLiveness();
            return -n;
        }
        this.affirmLiveness();
        return n;
    }

    @Override
    public synchronized int readBytesDelim(int[] buff, int delim) {
        int n;
        block7: {
            if (!this.restoreConnectionIfLost() || !this.opened) {
                return 0;
            }
            long time = System.currentTimeMillis();
            int size = buff.length;
            n = 0;
            try {
                block6: {
                    int b;
                    do {
                        if (System.currentTimeMillis() - time >= (long)this.timeout_ms) {
                            throw new IOException("timeout");
                        }
                        b = this.inputData.read();
                        if (b == 255) {
                            b = this.inputData.read();
                        }
                        if (n >= size) break block6;
                        buff[n++] = b;
                    } while (b != delim);
                    break block7;
                }
                return -n;
            }
            catch (IOException e) {
                this.checkLiveness();
                return -n;
            }
        }
        this.affirmLiveness();
        return n;
    }

    @Override
    public synchronized String readString(int size) {
        if (!this.restoreConnectionIfLost() || !this.opened) {
            return "";
        }
        long time = System.currentTimeMillis();
        byte[] buff = new byte[size];
        int n = 0;
        try {
            while (n < size) {
                if (System.currentTimeMillis() - time >= (long)this.timeout_ms) {
                    throw new IOException("timeout");
                }
                int b = this.inputData.read();
                if (b == 255) {
                    b = this.inputData.read();
                }
                buff[n++] = (byte)(b & 0xFF);
            }
        }
        catch (IOException e) {
            this.checkLiveness();
            return "";
        }
        this.affirmLiveness();
        return new String(buff, charset);
    }

    @Override
    public synchronized String readStringDelim(int delim) {
        if (!this.restoreConnectionIfLost() || !this.opened) {
            return "";
        }
        long time = System.currentTimeMillis();
        int i = 0;
        int b = -1;
        try {
            while (b != delim) {
                if (System.currentTimeMillis() - time >= (long)this.timeout_ms) {
                    throw new IOException("timeout");
                }
                if (i == 2048) {
                    throw new IOException("overflow");
                }
                b = this.inputData.read();
                if (b == 255) {
                    b = this.inputData.read();
                }
                this.buffin[i++] = (byte)(b & 0xFF);
            }
        }
        catch (IOException e) {
            this.checkLiveness();
            return "";
        }
        this.affirmLiveness();
        return new String(Arrays.copyOf(this.buffin, i), charset);
    }

    @Override
    public synchronized boolean writeByte(int data) {
        if (!this.restoreConnectionIfLost() || !this.opened) {
            return false;
        }
        try {
            this.outputData.write(data);
            if (data == 255) {
                this.outputData.write(data);
            }
        }
        catch (IOException e) {
            this.loseConnection();
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean writeBytes(int[] data, int size) {
        if (!this.restoreConnectionIfLost() || !this.opened) {
            return false;
        }
        try {
            for (int i = 0; i < size; ++i) {
                this.outputData.write(data[i]);
                if (data[i] != 255) continue;
                this.outputData.write(255);
            }
        }
        catch (IOException e) {
            this.loseConnection();
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean writeString(String str) {
        if (!this.restoreConnectionIfLost() || !this.opened) {
            return false;
        }
        try {
            for (byte b : str.getBytes(charset)) {
                int v = b & 0xFF;
                this.outputData.write(v);
                if (v != 255) continue;
                this.outputData.write(255);
            }
        }
        catch (IOException e) {
            this.loseConnection();
            return false;
        }
        return true;
    }
}

