/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.wessvr;

import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractCommand;
import promauto.jroboplc.core.DatabaseUtils;
import promauto.jroboplc.core.api.Console;
import promauto.jroboplc.core.api.Database;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Module;
import promauto.jroboplc.plugin.wessvr.WessvrModule;

public class CmdImport
extends AbstractCommand {
    private final Logger logger = LoggerFactory.getLogger(CmdImport.class);

    @Override
    public String getName() {
        return "import";
    }

    @Override
    public String getUsage() {
        return "db";
    }

    @Override
    public String getDescription() {
        return "imports wessvr data from database db";
    }

    @Override
    public String execute(Console console, Module module, String args) {
        module.postCommand(this, console, module, args);
        return "";
    }

    @Override
    public void executePosted(Console console, Module module, String args) {
        WessvrModule w = (WessvrModule)module;
        Database dbdst = w.getDatabase();
        if (!dbdst.isConnected()) {
            console.print("Database " + dbdst.getName() + " is not connected\n");
            return;
        }
        String[] ss = args.split("\\s+");
        Module m = EnvironmentInst.get().getModuleManager().getModule(ss[0]);
        if (!(m instanceof Database)) {
            console.print("Module " + args + " is not a database\n");
            return;
        }
        Database dbsrc = (Database)m;
        if (!dbsrc.isConnected()) {
            console.print("Database " + dbsrc.getName() + " is not connected\n");
            return;
        }
        if (ss.length == 3 && ss[1].equals("uvkrec_stat")) {
            DatabaseUtils.copytbl(console, dbsrc, dbdst, ss[2], "IDR, IDM, PERTYPE, PERIOD, DTBEG, DTEND, WES, SWBEG, SWEND");
            return;
        }
        boolean hasModulesOutcalcmode = false;
        boolean hasMainIdbatch = false;
        try (Statement st = dbsrc.getConnection().createStatement();){
            hasModulesOutcalcmode = dbsrc.hasColumn(st, "", "modules", "outcalcmode");
            hasMainIdbatch = dbsrc.hasColumn(st, "", "main", "idbatch");
        }
        catch (SQLException e) {
            EnvironmentInst.get().printError(this.logger, e, new String[0]);
        }
        DatabaseUtils.clear(console, dbdst, "arcout, arcstatus, arcval, main, mainhr, stat, stathr, usermdl, userprev, userrep, usertrd, modules, producttags, brigada, extradatabases, previlegs, product, reports, trends, users, mgroup, mgroupmod, smenalist, smenas, modtypes ");
        DatabaseUtils.copytbl(console, dbsrc, dbdst, "brigada", "*");
        DatabaseUtils.copytbl(console, dbsrc, dbdst, "extradatabases", "*");
        DatabaseUtils.copytbl(console, dbsrc, dbdst, "modtypes", "*");
        DatabaseUtils.copytbl(console, dbsrc, dbdst, "previlegs", "*");
        DatabaseUtils.copytbl(console, dbsrc, dbdst, "product", "*");
        DatabaseUtils.copytbl(console, dbsrc, dbdst, "reports", "*");
        DatabaseUtils.copytbl(console, dbsrc, dbdst, "smenalist", "*");
        DatabaseUtils.copytbl(console, dbsrc, dbdst, "smenas", "*");
        DatabaseUtils.copytbl(console, dbsrc, dbdst, "trends", "*");
        DatabaseUtils.copytbl(console, dbsrc, dbdst, "users", "*");
        DatabaseUtils.copytbl(console, dbsrc, dbdst, "modules", "IDM, IDMT, IDSL, NAME, DESCR, ENABLED, SVRNAME, ARCVALSIZE, ARCOUTSIZE, ARCOUTPER, ARCOUTTIME, WMUL, PROTOCOLVERSION, ARCSTATUS_OFF " + (hasModulesOutcalcmode ? ", OUTCALCMODE" : ""));
        DatabaseUtils.copytbl(console, dbsrc, dbdst, "arcout", "*", "idm", "modules");
        DatabaseUtils.copytbl(console, dbsrc, dbdst, "arcstatus", "*", "idm", "modules");
        DatabaseUtils.copytbl(console, dbsrc, dbdst, "arcval", "*", "idm", "modules");
        DatabaseUtils.copytbl(console, dbsrc, dbdst, "mgroup", "*");
        DatabaseUtils.copytbl(console, dbsrc, dbdst, "mgroupmod", "*", "idm", "modules");
        DatabaseUtils.copytbl(console, dbsrc, dbdst, "producttags", "*", "idm", "modules");
        DatabaseUtils.copytbl(console, dbsrc, dbdst, "usermdl", "*", "idm", "modules");
        DatabaseUtils.copytbl(console, dbsrc, dbdst, "userprev", "*");
        DatabaseUtils.copytbl(console, dbsrc, dbdst, "userrep", "*");
        DatabaseUtils.copytbl(console, dbsrc, dbdst, "usertrd", "*");
        DatabaseUtils.copytbl(console, dbsrc, dbdst, "main", "IDM, PERTYPE, DTBEG, WES, SWBEG, SWEND, WNUM, WNBEG, WNEND, OUTWES, OUTNUM, IDPROD, IDBRIG" + (hasMainIdbatch ? ", IDBATCH" : ""));
        DatabaseUtils.copytbl(console, dbsrc, dbdst, "mainhr", "IDM, PERTYPE, DTBEG, WES, SWBEG, SWEND, WNUM, WNBEG, WNEND, OUTWES, OUTNUM, IDPROD, IDBRIG" + (hasMainIdbatch ? ", IDBATCH" : ""));
        DatabaseUtils.copytbl(console, dbsrc, dbdst, "stat", "IDR, IDM, PERTYPE, PERIOD, DTBEG, DTEND, WES, SWBEG, SWEND, WNUM, WNBEG, WNEND, OUTWES, OUTNUM, IDPROD, IDBRIG" + (hasMainIdbatch ? ", IDBATCH" : ""));
        DatabaseUtils.copytbl(console, dbsrc, dbdst, "stathr", "IDR, IDM, PERTYPE, PERIOD, DTBEG, DTEND, WES, SWBEG, SWEND, WNUM, WNBEG, WNEND, OUTWES, OUTNUM, IDPROD, IDBRIG" + (hasMainIdbatch ? ", IDBATCH" : ""));
        DatabaseUtils.copygen(console, dbdst, "modules", "gen_modules_id", "idm");
        DatabaseUtils.copygen(console, dbdst, "brigada", "gen_brigada_id", "idbrig");
        DatabaseUtils.copygen(console, dbdst, "extradatabases", "gen_extradatabases_id", "id");
        DatabaseUtils.copygen(console, dbdst, "product", "gen_product_id", "idprod");
        DatabaseUtils.copygen(console, dbdst, "reports", "gen_reports_id", "idrep");
        DatabaseUtils.copygen(console, dbdst, "smenalist", "gen_smenalist_id", "idsl");
        DatabaseUtils.copygen(console, dbdst, "smenas", "gen_smenas_id", "idsmena");
        DatabaseUtils.copygen(console, dbdst, "trends", "gen_trends_id", "idtrd");
        DatabaseUtils.copygen(console, dbdst, "users", "gen_users_id", "iduser");
        DatabaseUtils.copygen(console, dbdst, "mgroup", "gen_mgroup_id", "idgroup");
        DatabaseUtils.copygen(console, dbdst, "producttags", "gen_producttags_id", "id");
        DatabaseUtils.copygen(console, dbdst, "stat", "gen_stat_id", "idr");
        DatabaseUtils.copygen(console, dbdst, "stathr", "gen_stathr_id", "idr");
        console.print("Done\n");
    }
}

