unit AdminMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ComCtrls, Buttons, Menus, StdCtrls, Mask;

const
  LISTTAGS_TYPE   = 0;
  LISTTAGS_STATUS = 1;
  LISTTAGS_VALUE  = 2;
  
type
  TAdminMainForm = class(TForm)
    AdminPageControl: TPageControl;
    TabSheetTagsBrowser: TTabSheet;
    Splitter1: TSplitter;
    Panel1: TPanel;
    btHex: TSpeedButton;
    btEquCheck: TSpeedButton;
    Timer: TTimer;
    SaveDialog: TSaveDialog;
    TabSheetSetup: TTabSheet;
    PopupMenu2: TPopupMenu;
    N5: TMenuItem;
    Panel6: TPanel;
    btUsers: TBitBtn;
    TabSheet1: TTabSheet;
    memoInfo: TMemo;
    btAddr: TSpeedButton;
    tbSystem: TTabSheet;
    BitBtn1: TBitBtn;
    btReports: TButton;
    Panel2: TPanel;
    listTags: TListView;
    Panel4: TPanel;
    btCustomFilter: TBitBtn;
    edTagFilter: TEdit;
    ParamsTabSheet: TTabSheet;
    Label1: TLabel;
    listApps: TListBox;
    btStartApp: TButton;
    CriticalAlertTabSheet: TTabSheet;
    StatusBar: TStatusBar;
    Panel3: TPanel;
    edCommand: TEdit;
    btSendCommand: TButton;
    edAndFilter: TEdit;
    Label2: TLabel;
    btShowCmdLineParamList: TBitBtn;
    listTaglistFilter: TListBox;
    btTaglistFilterDelete: TButton;
    btTaglistFilterClear: TButton;
    Label8: TLabel;
    Label9: TLabel;
    Label6: TLabel;
    Label16: TLabel;
    edDBarc: TEdit;
    edDBmes: TEdit;
    edUser: TEdit;
    edPass: TMaskEdit;
    cbDatabaseDisabled: TCheckBox;
    Label3: TLabel;
    edVisImagesPath: TEdit;
    cbSuperMaster: TCheckBox;
    cbUseMesloggingV2: TCheckBox;
    cbMessageBarFlashingEnabled: TCheckBox;
    Label18: TLabel;
    cmbBorderStyle: TComboBox;
    cmbWindowState: TComboBox;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    cbScrollbarEnable: TCheckBox;
    cbScrollbarHint: TCheckBox;
    edScrollbarHoriz: TEdit;
    edScrollbarVert: TEdit;
    udScrollbarHoriz: TUpDown;
    udScrollbarVert: TUpDown;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    edDataClientAddr: TEdit;
    edDataClientFilter: TEdit;
    edDataClient: TButton;
    cbReadOnly: TCheckBox;
    rgProtocol: TRadioGroup;
    Label4: TLabel;
    edPlaceName: TEdit;
    edFilterPlaceNames: TEdit;
    Label5: TLabel;
    Label7: TLabel;
    lbExistingPlaceNames: TLabel;
    Label11: TLabel;
    edMainLeft: TEdit;
    edMainTop: TEdit;
    edMainHeight: TEdit;
    edMainWidth: TEdit;
    Label10: TLabel;
    Label15: TLabel;
    Label17: TLabel;
    Label19: TLabel;
    btMesFilterSetup: TButton;
    Label23: TLabel;
    edPageFilterStr: TEdit;
    rgPageFilterMode: TRadioGroup;
    cbCanMessagePlaySound: TCheckBox;
    edMessageSoundFileName: TEdit;
    cbBlinkingBadStatus: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure TimerTimer(Sender: TObject);
    procedure listTagsDblClick(Sender: TObject);
    procedure listTagsColumnClick(Sender: TObject; Column: TListColumn);
    procedure btEquCheckClick(Sender: TObject);
    procedure btUsersClick(Sender: TObject);
    procedure btSystemSaveClick(Sender: TObject);
    procedure btReportsClick(Sender: TObject);
    procedure btCustomFilterClick(Sender: TObject);
    procedure setupDataClient(Sender: TObject);
    procedure listAppsDblClick(Sender: TObject);
    procedure cbSuperMasterClick(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure addFilterToHistory(text: string);
    procedure btTaglistFilterDeleteClick(Sender: TObject);
    procedure btTaglistFilterClearClick(Sender: TObject);
    procedure edTagFilterKeyPress(Sender: TObject; var Key: Char);
    procedure listTaglistFilterDblClick(Sender: TObject);
    procedure rgProtocolClick(Sender: TObject);
    procedure cbDatabaseDisabledClick(Sender: TObject);
    procedure btSendCommandClick(Sender: TObject);
    procedure btAddrClick(Sender: TObject);
    procedure btShowCmdLineParamListClick(Sender: TObject);
    procedure btMesFilterSetupClick(Sender: TObject);
  private
    firstPass: Boolean;
    appcmd: array of string;

    procedure BuildTagList;
    procedure addLineIntoMemoInfo(line: string);
    procedure loadAppList;
  end;

var
  AdminMainForm: TAdminMainForm;

  AdminMainFormValueSortMode: integer;

implementation
uses
  InputDialog,
  MesFilterSetup,
  MesLogging,
  ChannelInput,
  ChannelMap,
  _PrjProcs,
  DebugCommands,
  DataClientBase,
  DataClientRpsvrtcp,
  DataClientJrbustcp,
  CriticalAlertSetup,
  UserControlEx,
  HyperStr,
  RpVisualGlobal,
  main,
  TagStorage,
  VisNumbers,
  RpVisualUtils,
  DataMod,
  IniFiles,
  users,
  ReportsEditor,
  RpVisualMain,
  rpVisualParams,
  RpVisualIni,
  rpTcpClientBase,
  rpTcpClient;


{$R *.DFM}


procedure TAdminMainForm.FormCreate(Sender: TObject);
begin
  FirstPass := True;
end;


procedure TAdminMainForm.FormActivate(Sender: TObject);
begin
  if not FirstPass then
    exit;
  FirstPass := False;

  RpVisualParamsForm := TRpVisualParamsForm.Create(ParamsTabSheet);
  with RpVisualParamsForm do begin
    Parent := ParamsTabSheet;
    BorderStyle := bsNone;
    Align := alClient;
    LoadFromIni;
    Show;
  end;

  CriticalAlertSetupForm := TCriticalAlertSetupForm.Create(CriticalAlertTabSheet);
  with CriticalAlertSetupForm do begin
    Parent := CriticalAlertTabSheet;
    BorderStyle := bsNone;
    Align := alClient;
    LoadFromIni;
    Show;
  end;

  cbScrollbarEnable.Checked := scrollBarEnable;
  cbScrollbarHint.Checked := scrollBarHint;
  udScrollbarVert.Position := scrollBarPositionVert;
  udScrollbarHoriz.Position := scrollBarPositionHoriz;
  cbSuperMaster.Checked := SuperMasterMode;
  rgProtocol.ItemIndex := DataClientProtocol;
  edDBarc.Text := DBNameTag;
  edDBmes.Text := DBNameMes;
  edUser.Text := DBUser;
  edPass.Text := DBPass;
  cbDatabaseDisabled.checked := databaseDisabled;
  cbMessageBarFlashingEnabled.Checked := MessageBarFlashingEnabled;
  cmbBorderStyle.ItemIndex := Integer(Form1.BorderStyle);
  cmbWindowState.ItemIndex := Integer(Form1.WindowState);
  edMainLeft.Text := inttostr(Form1.Left);
  edMainTop.Text := inttostr(Form1.Top);
  edMainWidth.Text := inttostr(Form1.Width);
  edMainHeight.Text := inttostr(Form1.Height);
  cbReadOnly.checked := ReadOnlyMode;
  edTagFilter.Text := adminTagFilter;
  edAndFilter.Text := adminAndFilter;
  edVisImagesPath.Text := VisImagesPath;
  cbUseMesloggingV2.Checked := useMesloggingV2;
  edPlaceName.Text := CurPlaceName;
  edFilterPlaceNames.Text := filterPlaceNames;
  edPageFilterStr.Text := pageFilterStr;
  rgPageFilterMode.ItemIndex := pageFilterMode;
  cbCanMessagePlaySound.Checked := canMessagePlaySound;
  edMessageSoundFileName.Text := messageSoundFileName;
  cbBlinkingBadStatus.Checked := blinkingBadStatus;

  lbExistingPlaceNames.Caption := getExistingPlaceNames();

  Timer.Enabled := true;
  AdminPageControl.ActivePageIndex := 0;
  
  setupDataClient(nil);

  loadAppList();

  if FileExists('rpvisual.flh') then
    listTaglistFilter.Items.LoadFromFile('rpvisual.flh');

  edTagFilter.SetFocus;

  btSendCommandClick(nil);

  cbDatabaseDisabledClick(nil);
end;


procedure TAdminMainForm.btSystemSaveClick(Sender: TObject);
var
  tmpUseMesloggingV2: boolean;
  tmpCurPlaceName: string;
  tmpFilterPlaceNames: string;
begin
  tmpUseMesloggingV2 := useMesloggingV2;
  tmpCurPlaceName := CurPlaceName;
  tmpFilterPlaceNames := filterPlaceNames;

  scrollBarEnable := cbScrollbarEnable.Checked;
  scrollBarHint := cbScrollbarHint.Checked;
  scrollBarPositionVert := udScrollbarVert.Position;
  scrollBarPositionHoriz := udScrollbarHoriz.Position;
  SuperMasterMode := cbSuperMaster.Checked;
  DataClientProtocol := rgProtocol.ItemIndex;
  DBNameTag := edDBarc.Text;
  DBNameMes := edDBmes.Text;
  DBUser := edUser.Text;
  DBPass := edPass.Text;
  databaseDisabled := cbDatabaseDisabled.checked;
  MessageBarFlashingEnabled := cbMessageBarFlashingEnabled.Checked;
  Form1.BorderStyle := TFormBorderStyle(cmbBorderStyle.ItemIndex);
  Form1.WindowState := TWindowState(cmbWindowState.ItemIndex);

  Form1.Left   := StrToIntDef(edMainLeft.Text,   Form1.Left);
  Form1.Top    := StrToIntDef(edMainTop.Text,    Form1.Top);
  Form1.Width  := StrToIntDef(edMainWidth.Text,  Form1.Width);
  Form1.Height := StrToIntDef(edMainHeight.Text, Form1.Height);

  ReadOnlyMode := cbReadOnly.checked;
  VisImagesPath := edVisImagesPath.Text;
  useMesloggingV2 := cbUseMesloggingV2.Checked;
  CurPlaceName := edPlaceName.Text;
  filterPlaceNames := edFilterPlaceNames.Text;

  pageFilterStr := edPageFilterStr.Text;
  pageFilterMode := rgPageFilterMode.ItemIndex;

  canMessagePlaySound := cbCanMessagePlaySound.Checked;
  messageSoundFileName := edMessageSoundFileName.Text;

  blinkingBadStatus := cbBlinkingBadStatus.Checked;


  saveRpVisualIni;

  useMesloggingV2 := tmpUseMesloggingV2;

  if tmpCurPlaceName <> CurPlaceName then
    setupCurPlaceId;

  if tmpFilterPlaceNames <> filterPlaceNames then
    setupFilterPlaces;

end;



procedure TAdminMainForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Timer.Enabled := false;

  adminTagFilter := edTagFilter.Text;
  adminAndFilter := edAndFilter.Text;
  saveAdminIni;
  listTaglistFilter.Items.SaveToFile('rpvisual.flh');

  AdminMainForm := nil;
  Release;
end;


procedure TAdminMainForm.BuildTagList;
var
  s, filter1, filter2: string;
  i: integer;
begin
  filter1 := Trim(edTagFilter.Text);
  filter2 := Trim(edAndFilter.Text);

  if (filter2 <> '') and (Pos('*', filter2)=0) then
    filter2 := '*' + filter2 + '*';

  listTags.Items.BeginUpdate;
  listTags.Items.Clear;

  i := 0;
  repeat
    s := GetTagName(i);
    if not(s='') then
      if CheckFilter(s, filter1) then
        if (filter2 = '') or (CheckFilter(s, filter2)) then
          with listTags.Items.Add do begin
            Caption := s;
            SubItems.Add( tagtypeToStr( getTagType(i) ) );
            SubItems.Add('');
            SubItems.Add('');
            Data := pointer(i);
          end;
    inc(i);
  until s='';
  listTags.Items.EndUpdate;

  StatusBar.Panels[0].Text :=
      ' : ' + IntToStr(listTags.Items.Count);
end;


procedure TAdminMainForm.btCustomFilterClick(Sender: TObject);
begin
  BuildTagList();
  addFilterToHistory(edTagFilter.Text);
end;


procedure TAdminMainForm.TimerTimer(Sender: TObject);
var
  i,index: integer;
  s: string;
begin
  if AdminPageControl.ActivePageIndex = 0 then
    for i:=0 to listTags.Items.Count-1 do begin
      index := integer(listTags.Items[i].Data);

      if btAddr.Down then begin
        // get addr as string
        if getTagType(index) = TAGTYPE_STRING then
          s := chmapGetPrettyChannelStr( GetTagValueString(index) )
        else
          s := GetStringChannelName( GetTagValue(index) );

      end
      else if (btHex.Down)
            and ((getTagType(index) = TAGTYPE_INT)
                  or (getTagType(index) = TAGTYPE_LONG))
      then begin
          s := UpperCase(IntToHex(GetTagValueLong(index), 2));
      end
      else begin
        s := GetTagValueString(index);
      end;

      if listTags.Items[i].SubItems[LISTTAGS_VALUE] <> s then
        listTags.Items[i].SubItems[LISTTAGS_VALUE] := s;

      // status
      if IsTagStatusGood(index) then
        s := ''
      else
        s := 'BAD';

      if listTags.Items[i].SubItems[LISTTAGS_STATUS] <> s then
        listTags.Items[i].SubItems[LISTTAGS_STATUS] := s;

    end;
end;


procedure TAdminMainForm.listTagsDblClick(Sender: TObject);
var
  s: string;
  b: boolean;
  index: integer;
begin
  if listTags.Selected <> nil then begin
    s := listTags.Selected.SubItems[LISTTAGS_VALUE];
    index := integer(listTags.Selected.Data);

    // addr
    if btAddr.Down then begin
      showChannelInput( GetTagName(index), GetTagName(index));
    end

    else if getTagType(index) = TAGTYPE_BOOL then begin
      b := not GetTagValueBool(index);
      SetTagValueBool( index, b);
      s := iif(b, 'on', 'off');
    end

    else begin
      if not ShowInputDialog('', ':', s) then Exit;

      // hex
      if (btHex.Down)
            and ((getTagType(index) = TAGTYPE_INT)
                  or (getTagType(index) = TAGTYPE_LONG))
      then begin
        SetTagValueLong(index, HexDecLong(s));
      end

      // default
      else begin
        SetTagValueString(index, s);
      end;

    end;

    _WritelnAdminLog(listTags.Selected.Caption + ' = ' + s);
  end;
end;


function ValueSortProc(Item1, Item2: TListItem; ParamSort: integer): integer; stdcall;

  type
    TAddrRec = record
      addr: integer;
      num: integer;
      head: integer;
      tail: integer;
    end;

  function parseAddrNum(s: string; var rec: TAddrRec): boolean;
  var
    k1,k2,k3,len: integer;
  begin
    result := false;
    len := length(s);
    if len = 0 then exit;

    k2 := pos('-', s);
    if k2 = 0 then exit;

    if s[1] in ['0'..'9'] then begin
      rec.head := 0;
      k1 := 1;
    end else begin
      rec.head := ord(s[1]);
      k1 := 2;
    end;

    if s[len] in ['0'..'9'] then begin
      rec.tail := 0;
      k3 := len;
    end else begin
      rec.tail := ord(s[len]);
      k3 := len-1;
    end;

    rec.addr := StrToIntDef( copy(s, k1, k2-k1), -1);
    rec.num := StrToIntDef( copy(s, k2+1, k3-k2), -1);
    result := (rec.addr >= 0) and (rec.num >= 0);
  end;

var
  col, idx1, idx2, tt: integer;
  reslong: int64;
  resdouble: Double;
  ar1, ar2: TAddrRec;
begin
  col := ParamSort;
  Result := 0;

  if (AdminMainForm.btAddr.Down) and (col = LISTTAGS_VALUE) then
    if parseAddrNum(Item1.SubItems[col], ar1) then
      if parseAddrNum(Item2.SubItems[col], ar2) then begin
        result := ar1.addr - ar2.addr;
        if result = 0 then
          result := ar1.num - ar2.num;
        if result = 0 then
          result := ar1.head - ar2.head;
        if result = 0 then
          result := ar1.tail - ar2.tail;
      end;

  if (Result = 0) and ((col = LISTTAGS_TYPE) or (col = LISTTAGS_STATUS)) then begin
    Result := CompareText( Item1.SubItems[col], Item2.SubItems[col]);
  end;

  if (Result = 0) and (col = LISTTAGS_VALUE) then begin
    Result := CompareText( Item1.SubItems[LISTTAGS_TYPE], Item2.SubItems[LISTTAGS_TYPE]);
    if Result = 0 then begin
      idx1 := integer(Item1.Data);
      idx2 := integer(Item2.Data);
      tt := getTagType(idx1);

      case tt of
        TAGTYPE_BOOL:  Result := iif(GetTagValueBool(idx1), 1, 0) + iif(GetTagValueBool(idx2), -1, 0);
        TAGTYPE_INT:   Result := GetTagValueInt(idx1) - GetTagValueInt(idx2);
        TAGTYPE_LONG:
          begin
            reslong := GetTagValueLong(idx1) - GetTagValueLong(idx2);
            result := iif(reslong > 0, 1, 0) + iif(reslong < 0, -1, 0);
          end;
        TAGTYPE_DOUBLE:
          begin
            resdouble := GetTagValueDouble(idx1) - GetTagValueDouble(idx2);
            result := iif(resdouble > 0, 1, 0) + iif(resdouble < 0, -1, 0);
          end;
        TAGTYPE_STRING:
          Result := CompareText( GetTagValueString(idx1), GetTagValueString(idx2));
      end;

    end;
  end;

  if Result = 0 then
    Result := CompareText( Item1.Caption, Item2.Caption)
end;


procedure TAdminMainForm.listTagsColumnClick(Sender: TObject;
  Column: TListColumn);
begin
  if Column.Index = 0 then
    listTags.AlphaSort
  else
    listTags.CustomSort(@ValueSortProc, Column.Index-1);
end;


procedure TAdminMainForm.btEquCheckClick(Sender: TObject);
var
  i,j: integer;
begin
  for i:=0 to listTags.Items.Count-1 do
    listTags.Items[i].Selected := false;

  for i:=0 to listTags.Items.Count-2 do
    for j:=i+1 to listTags.Items.Count-1 do
      if listTags.Items[i].SubItems[LISTTAGS_VALUE] = listTags.Items[j].SubItems[LISTTAGS_VALUE] then begin
        listTags.Items[i].Selected := true;
        listTags.Items[j].Selected := true;
      end;

  for i:=0 to listTags.Items.Count-1 do
    with listTags.Items[i] do begin
      if (not Selected) and (copy(Caption,1,2) = '* ') then
        Caption := copy(Caption, 3, length(Caption)-2);

      if (Selected) and (not(copy(Caption,1,2) = '* ')) then
        Caption := '* ' + Caption;
    end;
end;


procedure TAdminMainForm.btUsersClick(Sender: TObject);
begin
  ShowUsersControl(self);
end;



procedure TAdminMainForm.btReportsClick(Sender: TObject);
begin
  if ReportsEditorForm = nil then
    ReportsEditorForm := TReportsEditorForm.Create(self);
  ReportsEditorForm.MakeFileList;
  ReportsEditorForm.ShowModal;
  ReportsEditorForm.Free;
  ReportsEditorForm := nil;
end;


procedure TAdminMainForm.setupDataClient(Sender: TObject);
var
  clnt: TDataClient;
begin
  case rgProtocol.ItemIndex of
    PROTOCOL_RPSVRTCP: clnt := TDataClientRpsvrtcp.Create;
    PROTOCOL_JRBUSTCP: clnt := TDataClientJrbustcp.Create;
  else
    Exit;
  end;
  try
    clnt.load(CurDir + RpVisualIniFile, 'RPVISUAL');
    if Sender <> nil then
      if clnt.showSettingsDialog then
        clnt.save(CurDir + RpVisualIniFile, 'RPVISUAL');
      
    edDataClientAddr.Text := clnt.Host + ':' + inttostr(clnt.Port);
    edDataClientFilter.Text := clnt.Filter;
  finally
    clnt.Free;
  end;
end;


procedure TAdminMainForm.listAppsDblClick(Sender: TObject);
var
  s: string;
begin
  if listApps.ItemIndex < 0 then exit;
  s := appcmd[listApps.itemindex];
  ReplaceS(s, '%PRJCODENAME%', _PrjCodeName);
  WinExec( PChar(s), SW_SHOW );
  Close;
end;


procedure TAdminMainForm.cbSuperMasterClick(Sender: TObject);
begin
  if cbSuperMaster.Checked then begin
    cbSuperMaster.Font.Color := clRed;
    cbSuperMaster.Font.Style := [fsBold];
  end else begin
    cbSuperMaster.Font.Color := clBlack;
    cbSuperMaster.Font.Style := [];
  end;
end;


procedure TAdminMainForm.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if ord(key) = 27 then
    close;
end;


procedure TAdminMainForm.addFilterToHistory(text: string);
var
  i: integer;
begin
  i := listTaglistFilter.Items.IndexOf(text);
  if i = 0 then
    exit;

  if i <> -1 then
    listTaglistFilter.Items.Delete(i);

  listTaglistFilter.Items.Insert(0, text);
end;


procedure TAdminMainForm.btTaglistFilterDeleteClick(Sender: TObject);
var
  i: integer;
begin
  i := listTaglistFilter.ItemIndex;
  if i <> -1 then begin
    listTaglistFilter.Items.Delete( i );
    if i < listTaglistFilter.Count then
      listTaglistFilter.ItemIndex := i;
  end;
end;


procedure TAdminMainForm.btTaglistFilterClearClick(Sender: TObject);
begin
  listTaglistFilter.Clear;
end;


procedure TAdminMainForm.edTagFilterKeyPress(Sender: TObject;
  var Key: Char);
begin
  if ord(key) = 13 then begin
    btCustomFilterClick(nil);
    listTags.SetFocus;
    if listTags.Items.Count > 0 then begin
      listTags.Selected := listTags.Items[0];
      listTags.Items[0].Selected := true;
      listTags.Items[0].Focused := true;
    end;
  end;
end;


procedure TAdminMainForm.listTaglistFilterDblClick(Sender: TObject);
begin
  if listTaglistFilter.ItemIndex <> -1 then begin
    edTagFilter.Text := listTaglistFilter.Items[ listTaglistFilter.ItemIndex ];
    BuildTagList();
  end;
end;


procedure TAdminMainForm.rgProtocolClick(Sender: TObject);
begin
  setupDataClient(nil);
end;


procedure TAdminMainForm.cbDatabaseDisabledClick(Sender: TObject);
var
  en: boolean;
begin
  en := not cbDatabaseDisabled.Checked;
  edDBarc.Enabled := en;
  edDBmes.Enabled := en;
  edUser.Enabled := en;
  edPass.Enabled := en;
end;


procedure TAdminMainForm.btSendCommandClick(Sender: TObject);
begin
  if (CurUserId <> USER_SUPERVISOR) and (not cbSuperMaster.Checked) then
    addLineIntoMemoInfo('     Supervisor!')
  else
    addLineIntoMemoInfo( executeDebugCommand(edCommand.Text) );
  edCommand.SelectAll;
end;


procedure TAdminMainForm.addLineIntoMemoInfo(line: string);
begin
  while memoInfo.Lines.Count > 1000 do
    memoInfo.Lines.Delete(0);

  memoInfo.Lines.Add(line)
end;

procedure TAdminMainForm.btAddrClick(Sender: TObject);
begin
  if btAddr.Down then
    chmapUpdate;
end;

procedure TAdminMainForm.btShowCmdLineParamListClick(Sender: TObject);
begin
  AdminPageControl.ActivePageIndex := 5;
  memoInfo.Lines.Clear;
  edCommand.Text := 'cmdline';
  btSendCommandClick(nil);
  edCommand.Text := '';
end;


procedure TAdminMainForm.loadAppList;
var
  i,k: Integer;
  s: string;
begin
  try
    listApps.Items.LoadFromFile('rpvisual.app');
  except
    listApps.Items.Add(' ~taskmgr');
    listApps.Items.Add('~explorer.exe');
    listApps.Items.SaveToFile('rpvisual.app');
  end;

  SetLength(appcmd, listApps.Items.Count);
  for i:=0 to listApps.Items.Count-1 do begin
    s := listApps.Items[i];
    k := Pos('~', s);
    if k>=0 then begin
      listApps.Items[i] := Copy(s, 1, k-1);
      s := Copy(s, k+1, length(s)-k+1);
    end;
    appcmd[i] := s;
  end;
end;

procedure TAdminMainForm.btMesFilterSetupClick(Sender: TObject);
begin
  if useMesloggingV2 then begin
    ShowMessage('        V1');
    Exit;
  end;
  MesFilterSetupForm := TMesFilterSetupForm.Create(self);
  MesFilterSetupForm.ShowModal;
  MesFilterSetupForm.Free;
end;

end.
