unit avColumnProp;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, ComCtrls, avBase;

type
  TavColumnPropForm = class(TForm)
    edName: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Bevel1: TBevel;
    btOk: TBitBtn;
    btCancel: TBitBtn;
    edWidth: TEdit;
    Label5: TLabel;
    udWidth: TUpDown;
    cbSetDefault: TCheckBox;
    cmbAlignment: TComboBox;
    procedure FormActivate(Sender: TObject);
    procedure btOkClick(Sender: TObject);
  private
    { Private declarations }
  public
    newflag: boolean;
  end;

var
  _ColName      : string;
  _ColWidth     : integer = 80;
  _ColAlign     : integer = 1;

implementation

{$R *.dfm}

procedure TavColumnPropForm.FormActivate(Sender: TObject);
begin
  if newflag then begin
    edName.Text := _ColName;
    udWidth.Position := _ColWidth;
    cmbAlignment.ItemIndex := _ColAlign;
  end;
end;

procedure TavColumnPropForm.btOkClick(Sender: TObject);
begin
  if cbSetDefault.Checked then begin
    _ColName := edName.Text;
    _ColWidth := udWidth.Position;
    _ColAlign := cmbAlignment.ItemIndex;
  end;

  ModalResult := mrOk; 
end;

end.
