unit avGroupProp;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ComCtrls, ExtCtrls, avBase;

type
  TavGroupPropForm = class(TForm)
    Label1: TLabel;
    edName: TEdit;
    btAdd: TSpeedButton;
    btDel: TSpeedButton;
    btUp: TSpeedButton;
    btDown: TSpeedButton;
    btOk: TButton;
    btCancel: TButton;
    list: TListView;
    btEdit: TSpeedButton;
    Bevel1: TBevel;
    Label2: TLabel;
    Label3: TLabel;
    edColWidthName: TEdit;
    udColWidthName: TUpDown;
    Label4: TLabel;
    edColWidthDescr: TEdit;
    udColWidthDescr: TUpDown;
    procedure FormActivate(Sender: TObject);
    procedure btOkClick(Sender: TObject);
    procedure btAddClick(Sender: TObject);
    procedure btDelClick(Sender: TObject);
    procedure btUpClick(Sender: TObject);
  private
    { Private declarations }
  public
    M: TavGroup;
  end;

implementation
uses
//  tvTagList,
//  tvTagProp,
  avColumnProp,
  numbers;

{$R *.dfm}

function _aligment_to_str(a: TAlignment): string;
begin
  case a of
    taLeftJustify  : result := '';
    taRightJustify : result := '';
    taCenter       : result := ' ';
  end;
end;

// ACTIVATE
procedure TavGroupPropForm.FormActivate(Sender: TObject);
var
  i: integer;
begin
  if M=nil then begin
    edName.Text := '';
    udColWidthName.Position := 65;
    udColWidthDescr.Position := 150;
    list.items.Clear;
  end else begin
    edName.Text := M.Name;
    udColWidthName.Position := M.ColWidthName;
    udColWidthDescr.Position := M.ColWidthDescr;
    list.items.Clear;
    for i:=0 to length(M.Columns)-1 do
      with list.Items.Add do begin
        Caption := M.Columns[i].Name;
        SubItems.Add(inttostr(M.Columns[i].Width));
        SubItems.Add( _aligment_to_str(M.Columns[i].Alignment) );
        SubItems.Add( inttostr(ord(M.Columns[i].Alignment)) );
      end;
  end;
end;

// OK
procedure TavGroupPropForm.btOkClick(Sender: TObject);
var
  i,j,k: integer;
begin

  edName.Text := trim(edName.Text);
  if edName.Text='' then exit;

  if M=nil then M := TavGroup.Create;

  M.Name := edName.Text;
  Val(edColWidthName.Text, M.ColWidthName, i);
  Val(edColWidthDescr.Text, M.ColWidthDescr, i);

  M.ClearColumns;
  SetLength(M.Columns, list.Items.Count);
  for i:=0 to list.Items.Count-1 do begin
    M.Columns[i] := TavColumn.Create;
    M.Columns[i].Name := list.Items[i].Caption;
    val(list.Items[i].SubItems[0], M.Columns[i].Width, j);
    val(list.Items[i].SubItems[2], k, j);
    M.Columns[i].Alignment := TAlignment(k)
  end;

  ModalResult := mrOk;
end;

// ADD COLUMNS
procedure TavGroupPropForm.btAddClick(Sender: TObject);
var
  i,j: integer;
  newflag: boolean;
  w: TavColumnPropForm;
begin
  newflag := sender = btAdd;
  if not newflag then
    if list.Selected = nil then exit;

  w := TavColumnPropForm.Create(self);
  try
    w.newflag := newflag;
    if not newflag then begin
      w.edName.Text := list.Selected.Caption;
      val(list.Selected.SubItems[0], i, j);
      w.udWidth.Position := i;
      val(list.Selected.SubItems[2], i, j);
      w.cmbAlignment.ItemIndex := i;
    end;

    if w.ShowModal = mrOk then begin
      if newflag then begin
        list.Selected := list.items.Add;
        list.Selected.SubItems.Add('');
        list.Selected.SubItems.Add('');
        list.Selected.SubItems.Add('');
      end;

      with list.Selected do begin
        Caption := w.edName.Text;
        SubItems[0] := w.edWidth.Text;
        SubItems[1] := w.cmbAlignment.Text;
        SubItems[2] := inttostr(w.cmbAlignment.ItemIndex);
      end;
    end;

  finally
    w.free;
  end;
end;

procedure TavGroupPropForm.btDelClick(Sender: TObject);
begin
  if list.ItemFocused = nil then exit;
  list.ItemFocused.Delete;
end;

procedure TavGroupPropForm.btUpClick(Sender: TObject);
var
  s: string;
  ss: array of string;
  i1,i2,i,n: integer;
begin
  if list.Selected = nil then exit;
  i1 := list.Selected.Index;
  if sender = btDown then begin
    i2 := i1 + 1;
    if i2 = list.Items.Count then exit;
  end else begin
    i2 := i1 - 1;
    if i2 < 0 then exit;
  end;


  with list.Items[i1] do begin
    n := list.Items[i1].SubItems.Count;
    SetLength(ss, n);

    s:=Caption;
    for i:=0 to n-1 do ss[i] := Subitems[i];

    Caption := list.Items[i2].Caption;
    for i:=0 to n-1 do Subitems[i] := list.Items[i2].SubItems[i];
  end;

  with list.Items[i2] do begin
    Caption := s;
    for i:=0 to n-1 do Subitems[i] := ss[i];
  end;

  list.Selected := list.Items[i2];
  list.Selected.Focused := true;
end;

end.
