unit avPrint;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, frxClass, frxPreview, StdCtrls, ExtCtrls, ComCtrls,
  Printers;


type
  TavPrintForm = class(TForm)
    frxUserDataSet1: TfrxUserDataSet;
    Button1: TButton;
    Button2: TButton;
    frxPreview1: TfrxPreview;
    Panel1: TPanel;
    Button3: TButton;
    Button4: TButton;
    frxReport1: TfrxReport;
    procedure BuildReport;
    procedure FormCreate(Sender: TObject);
    procedure frxUserDataSet1CheckEOF(Sender: TObject; var Eof: Boolean);
    procedure frxUserDataSet1First(Sender: TObject);
    procedure frxUserDataSet1Next(Sender: TObject);
    procedure frxUserDataSet1Prior(Sender: TObject);
    procedure frxUserDataSet1GetValue(const VarName: String;
      var Value: Variant);
    procedure FormActivate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    index: integer;
    L: TListView;

    colcount, rowcount: integer;
  end;

var
  avPrintForm: TavPrintForm;

implementation
uses
  arcviewer, numbers;

{$R *.dfm}

procedure TavPrintForm.FormCreate(Sender: TObject);
begin
  index := 0;
  WindowState := wsMaximized;
end;

procedure TavPrintForm.frxUserDataSet1CheckEOF(Sender: TObject;
  var Eof: Boolean);
begin
  eof := index >= rowcount;
end;

procedure TavPrintForm.frxUserDataSet1First(Sender: TObject);
begin
  index := 0;
end;

procedure TavPrintForm.frxUserDataSet1Next(Sender: TObject);
begin
  inc(index)
end;

procedure TavPrintForm.frxUserDataSet1Prior(Sender: TObject);
begin
  dec(index);
  if index<0 then index:=0;
end;

procedure TavPrintForm.frxUserDataSet1GetValue(const VarName: String;
  var Value: Variant);
var
  x,i: integer;
begin
  if (index<0) or (index>=rowcount) then begin
    Value := '';
    exit;
  end;

  if SameText(VarName,'Name') then
    value := L.Items[index].Caption
  else

  if SameText(VarName,'Descr') then
    value := L.Items[index].SubItems[0]
  else

  if SameText(VarName,'DT') then
    value := L.Items[index].SubItems[1]
  else

  if SameText(copy(VarName,1,3),'Col') then begin
    val(copy(VarName,4,2), x, i);
    if x < L.Items[index].SubItems.Count then
      value := L.Items[index].SubItems[x]
    else
      value := '';  
  end;
end;

////////////////////////////////////////////////////////////////////////////////
//  
////////////////////////////////////////////////////////////////////////////////
procedure TavPrintForm.BuildReport;
var
  Page: TfrxReportPage;
  Header: TfrxHeader;
  DataBand: TfrxMasterData;
  MemoLastX: integer;

    procedure _set_memo(Column: TListColumn; fname: string);
    var
      M1, M2: TfrxMemoView;
    begin
      M1 := TfrxMemoView.Create(DataBand);
      M1.CreateUniqueName;
      M1.DataSet := frxUserDataSet1;
      M1.DataField := fname;
      M1.SetBounds(MemoLastX, 0, Column.WidthType, 20);
      M1.Frame.Typ := [ftLeft, ftRight, ftTop, ftBottom];
      M1.Font.Assign(L.Font);
      M1.HAlign := TfrxHAlign(Column.Alignment);
      M1.VAlign := vaCenter;
      M1.WordWrap := false;

//      M1.Text := '[frxUserDataSet1."Col02"]

      M2 := TfrxMemoView.Create(Header);
      M2.CreateUniqueName;
      M2.Text := Column.Caption;
      M2.SetBounds(MemoLastX, 0, Column.WidthType, 20);
      M2.Frame.Typ := M1.Frame.Typ;
      M2.Font.Assign(L.Font);
      M2.HAlign := haCenter;
      M2.VAlign := vaCenter;
      M2.WordWrap := false;
      M2.Color := clBtnFace;

      MemoLastX := MemoLastX + Column.WidthType;
    end;


var
  i: integer;
begin
  MemoLastX := 0;

  frxReport1.Clear;
  frxReport1.DataSets.Add(frxUserDataSet1);

  Page := TfrxReportPage.Create(frxReport1);
  Page.CreateUniqueName;
  Page.SetDefaults;
  Page.Orientation := poLandscape;

  Header := TfrxHeader.Create(Page);
  Header.CreateUniqueName;
  Header.Top := 100;
  Header.Height := 20;

  DataBand := TfrxMasterData.Create(Page);
  DataBand.CreateUniqueName;
  DataBand.DataSet := frxUserDataSet1;
  DataBand.Top := 200;
  DataBand.Height := 20;

  _set_memo(L.Columns[0], 'Name');
  _set_memo(L.Columns[1], 'Descr');
  _set_memo(L.Columns[2], 'DT');

  for i:=3 to L.Columns.Count-1 do
    _set_memo(L.Columns[i], 'Col' + iif(i-1<10, '0', '') + inttostr(i-1) );

  frxReport1.ShowReport;
end;


procedure TavPrintForm.FormActivate(Sender: TObject);
begin
  rowcount := L.Items.Count;
  colcount := L.Columns.Count;

  BuildReport;
end;

procedure TavPrintForm.Button1Click(Sender: TObject);
begin
  frxReport1.Print;
end;

procedure TavPrintForm.Button3Click(Sender: TObject);
begin
  frxReport1.PrepareReport(false);
  frxReport1.ShowPreparedReport;
end;

procedure TavPrintForm.Button4Click(Sender: TObject);
begin
  BuildReport;
end;

end.
