unit avStrokaProp;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ComCtrls, ExtCtrls, avBase;

type
  TavStrokaPropForm = class(TForm)
    Label1: TLabel;
    edName: TEdit;
    btAdd: TSpeedButton;
    btDel: TSpeedButton;
    btUp: TSpeedButton;
    btDown: TSpeedButton;
    Label3: TLabel;
    btOk: TButton;
    btCancel: TButton;
    Bevel1: TBevel;
    list: TListView;
    btEdit: TSpeedButton;
    edDescr: TEdit;
    Label2: TLabel;
    btAddEmpty: TSpeedButton;
    procedure FormActivate(Sender: TObject);
    procedure btOkClick(Sender: TObject);
    procedure btAddClick(Sender: TObject);
    procedure btDelClick(Sender: TObject);
    procedure btEditClick(Sender: TObject);
    procedure btUpClick(Sender: TObject);
    procedure btAddEmptyClick(Sender: TObject);
  private
    { Private declarations }
  public
    G: TavGroup;
    M: TavStroka;
  end;

implementation
uses
  avTagList, avTagProp, numbers;

{$R *.dfm}

procedure TavStrokaPropForm.FormActivate(Sender: TObject);
var
  i: integer;
begin
  if M=nil then begin
    edName.Text := '';
    edDescr.Text := '';
    list.items.Clear;
  end else begin
    edName.Text := M.Name;
    edDescr.Text := M.Descr;
    list.items.Clear;
    for i:=0 to length(M.Tags)-1 do
      with list.Items.Add do begin
        Caption := M.Tags[i].TagName;
        SubItems.Add(M.Tags[i].Transform);             //0

        if M.Tags[i].Visulizator<>nil then
          SubItems.Add(M.Tags[i].Visulizator.Name)     //1
        else
          SubItems.Add('');

        SubItems.Add( inttostr(integer(pointer(M.Tags[i].Visulizator))) );   //2
      end;
  end;
end;

// OK
procedure TavStrokaPropForm.btOkClick(Sender: TObject);
var
  i: integer;
begin

  edName.Text := trim(edName.Text);
  if edName.Text='' then exit;

  if M=nil then begin
    M := TavStroka.Create;
    M.Group := G;
    i := length(G.Stroki);
    SetLength(G.Stroki, i+1);
    G.Stroki[i] := M;
  end;


  M.Name := edName.Text;
  M.Descr := edDescr.Text;

  M.Clear;
  SetLength(M.Tags, list.Items.Count);
  for i:=0 to list.Items.Count-1 do begin
    M.Tags[i] := TavTag.Create;
    M.Tags[i].TagName := list.Items[i].Caption;
    M.Tags[i].Transform := list.Items[i].SubItems[0];
    M.Tags[i].Visulizator := pointer(strtoint(list.Items[i].SubItems[2]));
  end;

  ModalResult := mrOk;
end;

// ADD TAGS
procedure TavStrokaPropForm.btAddClick(Sender: TObject);
var
  i,j: integer;
  flag: boolean;
  s: string;
begin
  for i:=0 to avTagListForm.list.Items.Count-1 do begin
    flag := false;
    s := avTagListForm.list.Items[i].Caption;
    for j:=0 to list.Items.Count-1 do
      if SameText(s, list.Items[j].Caption) then begin
        flag := true;
        break;
      end;
    avTagListForm.list.Items[i].Checked := flag;
  end;

  if avTagListForm.ShowModal<>mrOk then exit;

  for j:=0 to list.Items.Count-1 do
    list.Items[j].Checked := false;

  for i:=0 to avTagListForm.list.Items.Count-1 do
    if avTagListForm.list.Items[i].Checked then begin
      flag := false;
      s := avTagListForm.list.Items[i].Caption;
      for j:=0 to list.Items.Count-1 do
        if SameText(s, list.Items[j].Caption) then begin
          list.Items[j].SubItems[0] := '';
          list.Items[j].Checked := true;
          flag := true;
          break;
        end;
      if not flag then begin
        with list.Items.Add do begin
          Caption := s;
          SubItems.Add('');
          SubItems.Add('');
          SubItems.Add('0');
        end;
      end;
    end;

  for j:=list.Items.Count-1 downto 0 do
    if not list.Items[j].Checked then
      if not (list.Items[j].Caption='-') then
        list.Items[j].Delete;


//  while list.Items.Count>10 do
//    list.Items[list.Items.Count-1].Delete;

end;

procedure TavStrokaPropForm.btDelClick(Sender: TObject);
begin
  if list.ItemFocused = nil then exit;
  list.ItemFocused.Delete;
end;

procedure TavStrokaPropForm.btEditClick(Sender: TObject);
var
  w: TavTagPropForm;
  k: integer;
begin
  if list.ItemFocused = nil then exit;

  w := TavTagPropForm.Create(self);
  try
    w.edTagName.Text := list.ItemFocused.Caption;
    w.edTransform.Text := list.ItemFocused.subitems[0];
    w.cmbVisualizator.ItemIndex := w.cmbVisualizator.Items.IndexOf( list.ItemFocused.subitems[1] );
    w.cbVisualizator.Checked := w.cmbVisualizator.ItemIndex <> -1;


    if w.ShowModal=mrOk then begin
      list.ItemFocused.Caption := w.edTagName.Text;
      list.ItemFocused.subitems[0] := w.edTransform.Text;
      if w.cbVisualizator.Checked then begin
        k := w.cmbVisualizator.ItemIndex;
        list.ItemFocused.subitems[1] := w.cmbVisualizator.Items[ k ];
        list.ItemFocused.subitems[2] := inttostr(integer( w.cmbVisualizator.Items.Objects[ k ] ));
      end else begin
        list.ItemFocused.subitems[1] := '';
        list.ItemFocused.subitems[2] := inttostr(integer( nil ));
      end;  

    end;
  finally
    w.Free;
  end;

end;

procedure TavStrokaPropForm.btUpClick(Sender: TObject);
var
  s: string;
  ss: array of string;
  i1,i2,i,n: integer;
begin
  if list.Selected = nil then exit;
  i1 := list.Selected.Index;
  if sender = btDown then begin
    i2 := i1 + 1;
    if i2 = list.Items.Count then exit;
  end else begin
    i2 := i1 - 1;
    if i2 < 0 then exit;
  end;


  with list.Items[i1] do begin
    n := list.Items[i1].SubItems.Count;
    SetLength(ss, n);

    s:=Caption;
    for i:=0 to n-1 do ss[i] := Subitems[i];

    Caption := list.Items[i2].Caption;
    for i:=0 to n-1 do Subitems[i] := list.Items[i2].SubItems[i];
  end;

  with list.Items[i2] do begin
    Caption := s;
    for i:=0 to n-1 do Subitems[i] := ss[i];
  end;

  list.Selected := list.Items[i2];
  list.Selected.Focused := true;
end;

procedure TavStrokaPropForm.btAddEmptyClick(Sender: TObject);
begin
  with list.Items.Add do begin
    Caption := '-';
    SubItems.Add('');
    SubItems.Add('');
    SubItems.Add( inttostr(integer(nil)) );
  end;
end;

end.
