unit avVisualizatorItemProp;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, ComCtrls;

type
  TavVisualizatorItemPropForm = class(TForm)
    edCondition: TEdit;
    edExpression: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Bevel1: TBevel;
    btOk: TBitBtn;
    btCancel: TBitBtn;
    cbUseColor: TCheckBox;
    pnlColor: TPanel;
    btFontColor: TSpeedButton;
    btBackColor: TSpeedButton;
    ColorDialog1: TColorDialog;
    Label4: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label5: TLabel;
    Label3: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    procedure FormActivate(Sender: TObject);
    procedure cbUseColorClick(Sender: TObject);
    procedure btFontColorClick(Sender: TObject);
    procedure btOkClick(Sender: TObject);
  private
    { Private declarations }
  public
    newflag: boolean;
  end;

var
  _Condition: string;
  _Expression: string;
  _UseColor: boolean;
  _BackColor: TColor = clWindow;
  _FontColor: TColor = clBlack;

implementation

{$R *.dfm}

procedure TavVisualizatorItemPropForm.FormActivate(Sender: TObject);
begin
  if newflag then begin
    edCondition.Text := _Condition;
    edExpression.Text := _Expression;
    cbUseColor.Checked := _UseColor;
    btBackColor.Tag := _BackColor;
    btFontColor.Tag := _FontColor;
  end;
  cbUseColorClick(nil);
end;

procedure TavVisualizatorItemPropForm.cbUseColorClick(Sender: TObject);
begin
  if cbUseColor.Checked then begin
    pnlColor.Color := btBackColor.Tag;
    pnlColor.Font.Color := btFontColor.Tag;
  end else begin
    pnlColor.Color := clWindow;
    pnlColor.Font.Color := clBlack;
  end;
end;

procedure TavVisualizatorItemPropForm.btFontColorClick(Sender: TObject);
begin
  ColorDialog1.Color := (sender as TSpeedButton).Tag;
  if not ColorDialog1.Execute then exit;
  (sender as TSpeedButton).Tag := ColorDialog1.Color;
  cbUseColorClick(nil);
end;

procedure TavVisualizatorItemPropForm.btOkClick(Sender: TObject);
begin
  _Condition := edCondition.Text;
  _Expression := edExpression.Text;
  _UseColor := cbUseColor.Checked;
  _BackColor := btBackColor.Tag;
  _FontColor := btFontColor.Tag;
end;

end.
