unit avVisualizatorProp;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ComCtrls, ExtCtrls, avBase;

type
  TavVisualizatorPropForm = class(TForm)
    Label1: TLabel;
    edName: TEdit;
    btAdd: TSpeedButton;
    btDel: TSpeedButton;
    btUp: TSpeedButton;
    btDown: TSpeedButton;
    btOk: TButton;
    btCancel: TButton;
    list: TListView;
    btEdit: TSpeedButton;
    Bevel1: TBevel;
    Label2: TLabel;
    procedure FormActivate(Sender: TObject);
    procedure btOkClick(Sender: TObject);
    procedure btAddClick(Sender: TObject);
    procedure btDelClick(Sender: TObject);
    procedure btUpClick(Sender: TObject);
    procedure listAdvancedCustomDrawSubItem(Sender: TCustomListView;
      Item: TListItem; SubItem: Integer; State: TCustomDrawState;
      Stage: TCustomDrawStage; var DefaultDraw: Boolean);
  private
    { Private declarations }
  public
    M: TavVisulizator;
  end;

implementation
uses
//  tvTagList,
//  tvTagProp,
//  avColumnProp,
  avVisualizatorItemProp,
  numbers;

{$R *.dfm}

// ACTIVATE
procedure TavVisualizatorPropForm.FormActivate(Sender: TObject);
var
  i: integer;
begin
  if M=nil then begin
    edName.Text := '';
    list.items.Clear;
  end else begin
    edName.Text := M.Name;
    list.items.Clear;
    for i:=0 to length(M.Items)-1 do
      with list.Items.Add do begin
        Caption := M.Items[i].Condition;
        SubItems.Add(M.Items[i].Expression);
        SubItems.Add( iif(M.Items[i].UseColor, '', '') );
        SubItems.Add( inttostr(M.items[i].FontColor) );
        SubItems.Add( inttostr(M.items[i].BackColor) );
      end;
  end;
end;

// OK
procedure TavVisualizatorPropForm.btOkClick(Sender: TObject);
var
  i,j: integer;
begin

  edName.Text := trim(edName.Text);
  if edName.Text='' then exit;

  if M=nil then M := TavVisulizator.Create;

  M.Name := edName.Text;

  M.Clear;
  SetLength(M.Items, list.Items.Count);
  for i:=0 to list.Items.Count-1 do begin
    M.Items[i] := TavVisulizatorItem.Create;
    M.Items[i].Condition := list.Items[i].Caption;
    M.Items[i].Expression := list.Items[i].SubItems[0];
    M.Items[i].UseColor := list.Items[i].SubItems[1] <> '';
    val(list.Items[i].SubItems[2], M.Items[i].FontColor, j);
    val(list.Items[i].SubItems[3], M.Items[i].BackColor, j);
  end;

  ModalResult := mrOk;
end;

// ADD COLUMNS
procedure TavVisualizatorPropForm.btAddClick(Sender: TObject);
var
  i,j: integer;
  newflag: boolean;
  w: TavVisualizatorItemPropForm;
begin
  newflag := sender = btAdd;
  if not newflag then
    if list.Selected = nil then exit;

  w := TavVisualizatorItemPropForm.Create(self);
  try
    w.newflag := newflag;
    if not newflag then begin
      w.edCondition.Text := list.Selected.Caption;
      w.edExpression.Text := list.Selected.SubItems[0];
      w.cbUseColor.Checked := list.Selected.SubItems[1] <> '';
      val(list.Selected.SubItems[2], i, j);
      w.btFontColor.Tag := i;
      val(list.Selected.SubItems[3], i, j);
      w.btBackColor.Tag := i;
    end;

    if w.ShowModal = mrOk then begin
      if newflag then begin
        list.Selected := list.items.Add;
        list.Selected.SubItems.Add('');
        list.Selected.SubItems.Add('');
        list.Selected.SubItems.Add('');
        list.Selected.SubItems.Add('');
      end;

      with list.Selected do begin
        Caption := w.edCondition.Text;
        SubItems[0] := w.edExpression.Text;
        SubItems[1] := iif(w.cbUseColor.Checked, '', '');
        SubItems[2] := inttostr(w.btFontColor.Tag);
        SubItems[3] := inttostr(w.btBackColor.Tag);
      end;
    end;

  finally
    w.free;
  end;
end;

procedure TavVisualizatorPropForm.btDelClick(Sender: TObject);
begin
  if list.ItemFocused = nil then exit;
  list.ItemFocused.Delete;
end;

procedure TavVisualizatorPropForm.btUpClick(Sender: TObject);
var
  s: string;
  ss: array of string;
  i1,i2,i,n: integer;
begin
  if list.Selected = nil then exit;
  i1 := list.Selected.Index;
  if sender = btDown then begin
    i2 := i1 + 1;
    if i2 = list.Items.Count then exit;
  end else begin
    i2 := i1 - 1;
    if i2 < 0 then exit;
  end;


  with list.Items[i1] do begin
    n := list.Items[i1].SubItems.Count;
    SetLength(ss, n);

    s:=Caption;
    for i:=0 to n-1 do ss[i] := Subitems[i];

    Caption := list.Items[i2].Caption;
    for i:=0 to n-1 do Subitems[i] := list.Items[i2].SubItems[i];
  end;

  with list.Items[i2] do begin
    Caption := s;
    for i:=0 to n-1 do Subitems[i] := ss[i];
  end;

  list.Selected := list.Items[i2];
  list.Selected.Focused := true;
end;

procedure TavVisualizatorPropForm.listAdvancedCustomDrawSubItem(
  Sender: TCustomListView; Item: TListItem; SubItem: Integer;
  State: TCustomDrawState; Stage: TCustomDrawStage;
  var DefaultDraw: Boolean);
begin
  if SubItem=2 then
    if item.SubItems[1] <> '' then
    begin
      list.Canvas.Font.Color := strtoint(item.SubItems[2]);
      list.Canvas.Brush.Color := strtoint(item.SubItems[3]);
    end;
end;

end.
