unit avVisualizators;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, Buttons, ExtCtrls, avBase;

type
  TavVisualizatorsForm = class(TForm)
    Bevel1: TBevel;
    btAdd: TSpeedButton;
    btDel: TSpeedButton;
    btEdit: TSpeedButton;
    btCancel: TButton;
    list: TListView;
    procedure FormActivate(Sender: TObject);
    procedure btAddClick(Sender: TObject);
    procedure btDelClick(Sender: TObject);
  private
    { Private declarations }
  public
    A: TVisulizators;
  end;


implementation
uses avVisualizatorProp, arcviewer;

{$R *.dfm}

procedure TavVisualizatorsForm.FormActivate(Sender: TObject);
var
  i: integer;
begin
  list.Items.Clear;
  for i:=0 to length(A.Items)-1 do
    with list.Items.add do begin
      Caption := A.Items[i].Name;
      Data := A.Items[i];
    end;

  list.AlphaSort;
end;

procedure TavVisualizatorsForm.btAddClick(Sender: TObject);
var
  newflag: boolean;
  w: TavVisualizatorPropForm;
  k: integer;
begin
  newflag := Sender = btAdd;

  if not newflag then
    if list.Selected=nil then exit;

  w := TavVisualizatorPropForm.Create(self);
  try
    if newflag then
      w.M := nil
    else
      w.M := TavVisulizator( list.Selected.data );

    if w.ShowModal=mrOk then begin
      if newflag then begin
        list.Selected := list.Items.Add;
        list.Selected.Data := w.M;

        k := length(A.Items);
        SetLength(A.Items, k+1);
        A.Items[k] := w.M;
      end;

      list.Selected.Caption := w.M.Name;
    end;
  finally
    w.Free;
  end;
end;

procedure TavVisualizatorsForm.btDelClick(Sender: TObject);
var
  i,j,k: integer;
  vzr: TavVisulizator;
  gr: TavGroup;
begin
  if list.Selected=nil then exit;
  vzr := TavVisulizator(list.Selected.data);

  with owner as TArcViewerForm do
    for i:=1 to tree.Items.Count-1 do begin
      gr := TavGroup( tree.Items[i].Data );
      for j:=0 to length(gr.Stroki)-1 do
        for k:=0 to length(gr.Stroki[j].Tags)-1 do
          if gr.Stroki[j].Tags[k].Visulizator = vzr then
            gr.Stroki[j].Tags[k].Visulizator := nil;
    end;

  k := length(a.Items)-1;
  for i:=0 to k do
    if A.Items[i] = vzr then begin
      A.Items[i] := A.Items[k];
      SetLength(A.Items, k);
    end;

  vzr.Free;

  list.Selected.Delete;  

end;

end.
