unit tvPeriod;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls;

type
  TtvPeriodForm = class(TForm)
    dtBegDate: TDateTimePicker;
    dtBegTime: TDateTimePicker;
    dtEndDate: TDateTimePicker;
    dtEndTime: TDateTimePicker;
    Label1: TLabel;
    Label2: TLabel;
    edDays: TEdit;
    dtDeltaTime: TDateTimePicker;
    Label3: TLabel;
    Bevel1: TBevel;
    Bevel2: TBevel;
    btOk: TButton;
    btCancel: TButton;
    udDays: TUpDown;
    procedure FormActivate(Sender: TObject);
    procedure dtBegDateChange(Sender: TObject);
    procedure btOkClick(Sender: TObject);
    procedure edDaysChange(Sender: TObject);
  private
    procedure SetDelta;
    procedure get_dtBeg_dtEnd;
    procedure set_dtBeg_dtEnd;
    { Private declarations }
  public
    delta, dtbeg, dtend: TDatetime;

    disable_delta, disable_dt: boolean;
  end;


implementation

{$R *.dfm}

procedure TtvPeriodForm.FormActivate(Sender: TObject);
begin
  disable_delta := true;
  disable_dt := true;
  dtBegDate.DateTime := dtBeg;
  dtBegTime.DateTime := dtBeg;
  dtEndDate.DateTime := dtEnd;
  dtEndTime.DateTime := dtEnd;
  disable_delta := false;
  SetDelta;
  disable_dt := false;
end;

procedure TtvPeriodForm.get_dtBeg_dtEnd;
begin
  dtBeg := dtBegDate.DateTime;
  if dtBegTime.Checked then
    ReplaceTime(dtBeg, dtBegTime.DateTime)
  else
    ReplaceTime(dtBeg, 0);

  dtEnd := dtEndDate.DateTime;
  if dtEndTime.Checked then
    ReplaceTime(dtEnd, dtEndTime.DateTime)
  else
    ReplaceTime(dtEnd, 0);
end;


procedure TtvPeriodForm.SetDelta;
begin
  if disable_delta then exit;

  get_dtBeg_dtEnd;
  delta := dtEnd - dtBeg;
  udDays.Position := trunc(delta);
  dtDeltaTime.DateTime := 30000+delta;
end;

procedure TtvPeriodForm.set_dtBeg_dtEnd;
var
  i,j: integer;
begin
  if disable_dt then exit;

  val(edDays.Text, i, j);
  if dtDeltaTime.Checked then
    delta := i + frac(dtDeltaTime.DateTime);
  dtEndDate.DateTime := dtBegDate.DateTime + delta;
  dtEndTime.DateTime := dtEndDate.DateTime;
end;


procedure TtvPeriodForm.dtBegDateChange(Sender: TObject);
begin
  disable_dt := true;
  SetDelta;
  disable_dt := false;
end;

procedure TtvPeriodForm.btOkClick(Sender: TObject);
begin
  get_dtBeg_dtEnd;
  ModalResult := mrOk;
end;

procedure TtvPeriodForm.edDaysChange(Sender: TObject);
begin
  disable_delta := true;
  set_dtBeg_dtEnd;
  disable_delta := false;
end;

end.
