unit CommonDataboard;

interface
uses
  VisDataboard,
  dialogs;

const
  DEFAULT_CAPTION: string = ' ';

type
  TCommonDataboard = class(TObject)
  published
    procedure ButtonClick(Sender: TObject);
  end;

  procedure CommonDataboard_Init(TagPath: String = ''; TagRoot: String = ''; Caption: String = '' );
  procedure CommonDataboard_Add(line: String = '');

var
  common_databoard: TVisDataboard;

implementation
uses
  _prjprocs,
  main;

var
  common_databoard_object: TCommonDataboard;


procedure CommonDataboardCreate;
begin
  common_databoard := TVisDataboard.Create(Form1);
  common_databoard_object := TCommonDataboard.Create;
end;

procedure CommonDataboardDestroy;
begin
  common_databoard_object.Free;
end;


procedure TCommonDataboard.ButtonClick(Sender: TObject);
begin
  common_databoard.Parent := Form1.PageControl.ActivePage;
  common_databoard.OnControlClick(common_databoard);
end;


procedure CommonDataboard_Init(TagPath: String = ''; TagRoot: String = ''; Caption: String = '' );
begin
  form1.btParams.OnClick := common_databoard_object.ButtonClick;
  form1.bvExtra.Visible := true;
  form1.btParams.Visible := true;


  if TagPath = '' then TagPath := _PrjCodeName;
  if Caption = '' then Caption := DEFAULT_CAPTION;

  common_databoard.TagPath := TagPath;
  common_databoard.TagRoot := TagRoot;
  common_databoard.Caption := Caption;

  common_databoard.HideMessages := true;
end;


procedure CommonDataboard_Add(line: String = '');
begin
  common_databoard.DataPar.Add(line);
end;


initialization
  CommonDataboardCreate;

finalization
  CommonDataboardDestroy;


end.
