unit ControlPanel;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls;

type
  TControlPanelForm = class(TForm)
    pnl: TPanel;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

  procedure OpenControlPanel(var frm: TForm);
  procedure CloseControlPanel;

var
  ControlPanelForm: TControlPanelForm;

implementation
{$R *.dfm}
uses
  main,
  rpvisualglobal;

var
  pForm: ^TForm;


procedure OpenControlPanel(var frm: TForm);
const
  SHIFT_OFFSET = 75;
var
  tp: TPoint;
begin
//  HideControlPanel;  //   

  if not rvgLogIn then exit;
  if frm=nil then exit;

  if pForm<>nil then
    if pForm <> @frm then begin
      FreeAndNil(pForm^);
      pForm := nil;
    end;

  if ControlPanelForm = nil then begin
    ControlPanelForm := TControlPanelForm.Create(Form1);
    ControlPanelForm.Visible := false;
    ControlPanelForm.Parent := Form1;
  end;

  ControlPanelForm.Width := 252; //frm.Width+2;
//  ControlPanelForm.Left := Form1.Width - ControlPanelForm.Width;
  ControlPanelForm.Left := Form1.PageControl.Width - ControlPanelForm.Width;

  ControlPanelForm.Top := Form1.PageControl.Top;
  ControlPanelForm.Height := Form1.PageControl.Height;
  ControlPanelForm.Anchors := [akRight, akTop, akBottom];
  ControlPanelForm.FormStyle := fsStayOnTop;

  frm.Parent := ControlPanelForm.pnl;
  frm.Align := alClient;
  frm.BorderStyle := bsNone;
  pForm := @frm;

  if Assigned(frm.OnActivate) then frm.OnActivate(nil);

  Form1.PageControl.Align := alNone;
  tp := Form1.PageControl.ScreenToClient(Mouse.CursorPos);

  if tp.x > (ControlPanelForm.Left - SHIFT_OFFSET) then begin
    Form1.PageControl.Left := -ControlPanelForm.Width;
  end;

  if tp.x < (ControlPanelForm.Width + SHIFT_OFFSET) then begin
    Form1.PageControl.Left := 0;
  end;

  ControlPanelForm.Show;
  frm.Show;
end;

procedure CloseControlPanel;
begin
  if pForm<>nil then begin
    FreeAndNil(pForm^);
    pForm := nil;
  end;

  if ControlPanelForm <> nil then
    FreeAndNil(ControlPanelForm);

  Form1.PageControl.Align := alClient;

end;


procedure TControlPanelForm.FormCreate(Sender: TObject);
begin
  DoubleBuffered := true;
  pnl.DoubleBuffered := true;
end;

end.
