// DEPRECATED !!!

unit CtrlPanelDltb;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MdtaCtrl, ExtCtrls, StdCtrls, Buttons, VisDltb, ComCtrls;

type
  TCtrlPanelDltbForm = class(TForm)
    Panel1: TPanel;
    Timer: TTimer;
    NamePanel: TPanel;
    ButPanel: TPanel;
    btRun: TSpeedButton;
    btStop: TSpeedButton;
    HandLabel: TLabel;
    Panel2: TPanel;
    Label1: TLabel;
    btFwd: TSpeedButton;
    btRev: TSpeedButton;
    Panel3: TPanel;
    Label2: TLabel;
    btEF: TSpeedButton;
    btReset: TSpeedButton;
    pnlRun: TPanel;
    pnlStop: TPanel;
    pnlFwd: TPanel;
    pnlRev: TPanel;
    pnlFrecCom: TPanel;
    pnlFreqTerm: TPanel;
    pnlOpCom: TPanel;
    pnlParLock: TPanel;
    Panel4: TPanel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    pnlOpFreq: TPanel;
    pnlOutFreq: TPanel;
    pnlOutCurr: TPanel;
    pnlAddr: TPanel;
    Label7: TLabel;
    Label8: TLabel;
    pnlOutVolt: TPanel;
    pnlTemper: TPanel;
    StatList: TListView;
    btTrends: TBitBtn;
    btParams: TBitBtn;
    Label9: TLabel;
    pnlModel: TPanel;

    procedure FormActivate(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btRunClick(Sender: TObject);
    procedure btStopClick(Sender: TObject);
    procedure btFwdClick(Sender: TObject);
    procedure btRevClick(Sender: TObject);
    procedure btEFClick(Sender: TObject);
    procedure btResetClick(Sender: TObject);
    procedure pnlFrecComClick(Sender: TObject);
    procedure pnlOpFreqClick(Sender: TObject);
    procedure btTrendsClick(Sender: TObject);
    procedure btParamsClick(Sender: TObject);
  private
    FidxReg2000: integer;
    FidxReg2001: integer;
    FidxReg2002: integer;

    FidxReg2100: integer;
    FidxReg2101: integer;
    FidxReg2102: integer;
    FidxReg2103: integer;
    FidxReg2104: integer;
    FidxReg2105: integer;
    FidxReg2106: integer;
    FidxReg210D: integer;
    FidxAnswer: integer;

    FidxErrorFlag: integer;
    FidxAddr: integer;

    FMessageTagName: string;
    procedure button_click(btn: TSpeedButton; mes1, mes2: string; idx, mask,
      value: integer);
  public
    M: TVisDltb;
  end;

var
  CtrlPanelDltbForm: TCtrlPanelDltbForm;

implementation
uses
  UserControlEx,
  MesConst,
  numbers, TagStorage, MesLogging, TrendWindow, Users, CtrlPanelDltbParams,
  VisMachine;

{$R *.DFM}

procedure TCtrlPanelDltbForm.FormActivate(Sender: TObject);
var
  stag: string;
begin
  case m.VFDModel of
    dmVFDM: pnlModel.Caption := 'VFD-M';
    dmVFDE: pnlModel.Caption := 'VFD-E';
    dmVFDB: pnlModel.Caption := 'VFD-B';
  end;

  NamePanel.Caption := M.DeviceName;
  FMessageTagName := M.DeviceName;

  stag := M.TagPath + '.Reg.R';

  FidxReg2000 := GetTagIndex(stag+'2000');
  FidxReg2001 := GetTagIndex(stag+'2001');
  FidxReg2002 := GetTagIndex(stag+'2002');
  FidxReg2100 := GetTagIndex(stag+'2100');
  FidxReg2101 := GetTagIndex(stag+'2101');
  FidxReg2102 := GetTagIndex(stag+'2102');
  FidxReg2103 := GetTagIndex(stag+'2103');
  FidxReg2104 := GetTagIndex(stag+'2104');
  FidxReg2105 := GetTagIndex(stag+'2105');
  FidxReg2106 := GetTagIndex(stag+'2106');
  FidxReg210D := GetTagIndex(stag+'210D');
  FidxAnswer := GetTagIndex(M.TagPath + '.Answer');

  FidxErrorFlag := GetTagIndex(M.TagPath + '.SYSTEM.ErrorFlag');
  FidxAddr := GetTagIndex(M.TagPath + '.SYSTEM.NetAddr');

  Timer.Enabled := true;
  TimerTimer(nil);
end;

procedure TCtrlPanelDltbForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Timer.Enabled := false;
end;


procedure TCtrlPanelDltbForm.TimerTimer(Sender: TObject);

  procedure set_pnl_color(pnl: TPanel; fnt: TColor; clr: TColor);
  begin
    if (pnl.Color<>clr) then begin
      pnl.Color:=clr;
      pnl.Font.Color := fnt;
    end;
  end;

  procedure blink_pnl_color(pnl: TPanel; fnt: TColor; clr1: TColor; clr2: TColor);
  begin
    if (pnl.Color=clr1) then
      pnl.Color:=clr2
    else
      pnl.Color:=clr1;
    if pnl.Font.Color <> fnt then pnl.Font.Color := fnt;
  end;

  procedure set_btn(btn: TSpeedButton; dwn: boolean);
  begin
    if (btn.Down<>dwn) then btn.Down:=dwn
  end;

  procedure set_status(is_alm: boolean; id: integer; s: string);
  var
    i: integer;
  begin
    if is_alm then begin
      for i:=0 to StatList.Items.Count-1 do
        if StatList.Items[i].Data = pointer(id) then begin
          StatList.Items[i].Caption := s;
          s:='';
          break;
        end;

      if length(s)>0 then with StatList.Items.Add do begin
        Caption:=s;
        Data := pointer(id);
      end;
    end else begin
      for i:=0 to StatList.Items.Count-1 do
        if StatList.Items[i].Data = pointer(id) then begin
          StatList.Items.Delete(i);
          break;
        end;
    end;
  end;

  procedure set_pnl_val(pnl: TPanel; s: string);
  begin
    if not SameText(pnl.Caption, s) then pnl.Caption := s;
  end;

var
  value: integer;
  s: string;
begin
  s := '';
  value := GetTagValue(FidxReg2100);
  if value>0 then begin

    if M.VFDModel=dmVFDM then
      case value of
      $01: s:='  ';
      $03: s:='';
      $04: s:='';
      $05: s:=' ';
      $06: s:=' ';
      $07: s:=' ';
      $08: s:='     ';
      $09: s:='  ';
      $0A: s:='ocA';
      $0B: s:='ocD';
      $0C: s:='ocN';
      $0D: s:=' ';
      $0E: s:=' ';
      $0F: s:='';
      $10: s:='  1';
      $11: s:=' ';
      $12: s:='';
      $13: s:='   /';
      $14: s:='  ';
      end;

    if M.VFDModel=dmVFDE then
      case value of
      01: s:='   ()';
      02: s:='   (v)';
      03: s:=' IGBT- (oH1)';
      04: s:='   (oH2)';
      05: s:=' (oL)';
      06: s:=' 1 (oL1)';
      07: s:=' 2 (oL2)';
      08: s:='   (EF)';
      09: s:='     (ocA)';
      10: s:='     (ocD)';
      11: s:='       (ocn)';
      12: s:='   (GFF)';
      13: s:='  (Lv)';
      14: s:='PHL ( )';
      15: s:=' ';
      16: s:='    /  (cFA)';
      17: s:='   (codeE)';
      18: s:='   CPU   (CF1.0)';
      19: s:='   CPU   (CF1.0)';
      20: s:='  CC, OC (HPF1)';
      21: s:='  OV (HPF2)';
      22: s:='  GFF (HPF3)';
      23: s:='  OC (HPF4)';
      24: s:='   U (F3.0)';
      25: s:='   V (F3.1)';
      26: s:='   W (F3.2)';
      27: s:='  DCBUS (F3.3)';
      28: s:=' IGBT (cF3.4)';
      29: s:='   (cF3.5)';
      30: s:='   CPU   (cF1.1)';
      31: s:='   CPU   (cF2.1)';
      32: s:='  ACI (AErr)';
      33: s:='---';
      34: s:='PTC-   (PtC1)';
      end;

    if M.VFDModel=dmVFDB then
      case value of
      01: s:='   ()';
      02: s:='   (v)';
      03: s:='  (oH)';
      04: s:=' (oL)';
      05: s:=' 1 (oL1)';
      06: s:='   (EF)';
      07: s:=' IGBT-    (occ)';
      08: s:=' CPU (cF3)';
      09: s:='   (HPF)';
      10: s:='     (ocA)';
      11: s:='     (ocD)';
      12: s:='       (ocn)';
      13: s:='   (GFF)';
      14: s:='  (Lv)';
      15: s:=' CPU 1 (cF1)';
      16: s:=' CPU 2 (cF2)';
      17: s:=' ';
      18: s:=' 2 (oL2)';
      19: s:='    /  (cFA)';
      20: s:='   (codeE)';
      21: s:='EF1  ';
      22: s:='    (PHL)';
      23: s:='    (cEF)';
      24: s:='  (Lc)';
      25: s:='     (AnLEr)';
      26: s:='      (PGErr)';
      end;


  end;

  set_status(value>0, 1, s);


  value := GetTagValue(FidxAnswer);
  if value>0 then
    case value of
    $02: s:='  ';
    $04: s:='  ';
    end;
  set_status(value>0, 2, s);

  value := GetTagValue(FidxErrorFlag);
  if value>0 then
    s:=' '
  else
    s := '';
  set_status(value>0, 3, s);


  value := GetTagValue(FidxReg2101) and 3;
  if (value=0) then set_pnl_color(   pnlRun,  clGray,  clBtnFace);
  if (value=0) then set_pnl_color(   pnlStop, clWhite, clRed);

  if (value=1) then set_pnl_color(   pnlRun,  clBlack, clLime);
  if (value=1) then set_pnl_color(   pnlStop, clGray,  clBtnFace);

  if (value=2) then set_pnl_color(   pnlRun,  clGray,  clBtnFace);
  if (value=2) then set_pnl_color(   pnlStop, clWhite, clRed);

  if (value=3) then set_pnl_color(   pnlRun,  clBlack, clLime);
  if (value=3) then set_pnl_color(   pnlStop, clGray,  clBtnFace);

  value := GetTagValue(FidxReg2101) and 8;
  if (value>0) then set_pnl_color(   pnlFwd,  clBlack, clLime)
               else set_pnl_color(   pnlFwd,  clGray,  clBtnFace);

  value := GetTagValue(FidxReg2101) and 16;
  if (value>0) then set_pnl_color(   pnlRev,  clBlack, clLime)
               else set_pnl_color(   pnlRev,  clGray,  clBtnFace);

  value := GetTagValue(FidxReg2101) and $100;
  if (value>0) then set_pnl_color(   pnlFrecCom,  clBlack, clLime)
               else set_pnl_color(   pnlFrecCom,  clGray,  clBtnFace);

  value := GetTagValue(FidxReg2101) and $400;
  if (value>0) then set_pnl_color(   pnlOpCom,  clBlack, clLime)
               else set_pnl_color(   pnlOpCom,  clGray,  clBtnFace);

  value := GetTagValue(FidxReg2101) and $200;
  if (value>0) then set_pnl_color(   pnlFreqTerm,  clBlack, clYellow)
               else set_pnl_color(   pnlFreqTerm,  clGray,  clBtnFace);

  value := GetTagValue(FidxReg2101) and $800;
  if (value>0) then set_pnl_color(   pnlParLock,  clBlack, clRed)
               else set_pnl_color(   pnlParLock,  clGray,  clBtnFace);


  value := GetTagValue(FidxReg2000);
  set_btn( btStop, (value and 1)>0);
  set_btn( btRun, (value and 2)>0);
  set_btn( btFwd, (value and $10)>0);
  set_btn( btRev, (value and $20)>0);
  set_btn( btRun, (value and 2)>0);

  value := GetTagValue(FidxReg2002);
  if value > 0 then SetTagValue(FidxReg2002, 0);

  set_pnl_val(pnlOpFreq, format('%.2f', [GetTagValue(FidxReg2102)/100]));

  value := GetTagValue(FidxReg2103);
  set_pnl_val(pnlOutFreq, iif(value > $8000,
                               format('-%.2f', [($10000 - value)/100]),
                               format('%.2f', [value/100])
                             ));


  set_pnl_val(pnlOutCurr, format('%.2f', [GetTagValue(FidxReg2104)/10]));

  set_pnl_val(pnlOutVolt, format('%.2f', [GetTagValue(FidxReg2106)/10]));

  set_pnl_val(pnlTemper, format('%.2f', [GetTagValue(FidxReg210D)/10]));

  set_pnl_val(pnlAddr, inttostr(GetTagValue(FidxAddr)));


end;


procedure TCtrlPanelDltbForm.button_click(btn: TSpeedButton; mes1, mes2: string; idx, mask, value: integer);
begin
    if isModeUserEx then
    if not isPermitted(ClassName + '~' + NamePanel.Caption + '~') then
      Exit
    else
  else
  if not CheckAccess( PREVILEG_ZAPUSK_MASHIN_1, true) then exit;
  if not btn.Down then exit;
  if MessageDlg(mes1, mtConfirmation, [mbYes, mbNo], 0) = mrYes then begin

    SaveMessageText(mcMode_text, FMessageTagName, mes2, mcMode_bc, mcMode_fc);
    SetTagValue( idx, (GetTagValue(idx) and mask) or value);
  end;
end;

procedure TCtrlPanelDltbForm.btRunClick(Sender: TObject);
begin
  button_click(btRun, '!    ?', '', FidxReg2000, $FFFC, 2);
end;

procedure TCtrlPanelDltbForm.btStopClick(Sender: TObject);
begin
  button_click(btStop, '!    ?', '', FidxReg2000, $FFFC, 1);
end;

procedure TCtrlPanelDltbForm.btFwdClick(Sender: TObject);
begin
  button_click(btFwd, '  ?', '', FidxReg2000, $FFCF, $10);
end;

procedure TCtrlPanelDltbForm.btRevClick(Sender: TObject);
begin
  button_click(btRev, '  ?', '', FidxReg2000, $FFCF, $20);
end;

procedure TCtrlPanelDltbForm.btEFClick(Sender: TObject);
begin
  if isModeUserEx then
    if not isPermitted(ClassName + '~' + NamePanel.Caption + '~') then
      Exit
    else
  else
  if not CheckAccess( PREVILEG_ZAPUSK_MASHIN_1, true) then exit;
  if MessageDlg('   " "?', mtConfirmation, [mbYes, mbNo], 0) = mrYes then begin
    SaveMessageText(mcMode_text, FMessageTagName, '.', mcMode_bc, mcMode_fc);
    SetTagValue( FidxReg2002, 1 );
  end;
end;

procedure TCtrlPanelDltbForm.btResetClick(Sender: TObject);
begin
  if isModeUserEx then
    if not isPermitted(ClassName + '~' + NamePanel.Caption + '~') then
      Exit
    else
  else
  if not CheckAccess( PREVILEG_ZAPUSK_MASHIN_1, true) then exit;
  if MessageDlg('   ""?', mtConfirmation, [mbYes, mbNo], 0) = mrYes then begin
    SaveMessageText(mcMode_text, FMessageTagName, '', mcMode_bc, mcMode_fc);
    SetTagValue( FidxReg2002, 2 );
  end;
end;

procedure TCtrlPanelDltbForm.pnlFrecComClick(Sender: TObject);
begin
  ShowMessage(' "' + (Sender as TPanel).Hint + '"');
end;

procedure TCtrlPanelDltbForm.pnlOpFreqClick(Sender: TObject);
var
  s: string;
  v,i: integer;
  r: real;
begin
  if isModeUserEx then begin
    if not isPermitted(ClassName + '~' + NamePanel.Caption + '~ ') then
      Exit;
  end else
    if not CheckAccess( PREVILEG_ZAPUSK_MASHIN_1, true) then
      Exit;

  Str(GetTagValue(FidxReg2001)/100:2:2, s);
  if InputQuery('  ',
      ' ' + ', ', s) then begin

    val(s,r,i);
    r := r*100;
    v := trunc(r);
    SaveMessageText(mcMode_text, FMessageTagName, 'F=' + s, mcMode_bc, mcMode_fc);
    SetTagValue( FidxReg2001, v);                                                     
  end;
end;
                                                                                    
procedure TCtrlPanelDltbForm.btTrendsClick(Sender: TObject);
begin
  ShowTrendWindow( '       ',
        M.TagPath + '.Reg.R2102~cast(^ as float)/100;'+
        M.TagPath + '.Reg.R2103~cast(^ as float)/100;'+
        M.TagPath + '.Reg.R2104~cast(^ as float)/10;'+
//        M.TagPath + '.Reg.R2106~cast(^ as float)/10;'+
        M.TagPath + '.Reg.R210D~cast(^ as float)/10;',

        '.;'+
        '.;'+
        '.;'+
//        '..;'+
        ';',

        'dltb', '' );
end;

procedure TCtrlPanelDltbForm.btParamsClick(Sender: TObject);
begin
  CtrlPanelDltbParamsForm := TCtrlPanelDltbParamsForm.Create(nil);
  try
    CtrlPanelDltbParamsForm.TagPath := M.TagPath;
    CtrlPanelDltbParamsForm.TagName := M.TagName;
    CtrlPanelDltbParamsForm.ShowModal;
  finally
    CtrlPanelDltbParamsForm.Free;
  end;
end;

end.
