// DEPRECATED !!!

unit CtrlPanelWesAkkont;

{$DEFINE MyCtrlPanelWesAkkont}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons, VisDynamicPict;

type
  TCtrlPanelWesAkkontForm = class(TForm)
    Panel1: TPanel;
    Timer: TTimer;
    pnlName: TPanel;
    pnlSost: TPanel;
    Panel2: TPanel;
    btStart: TSpeedButton;
    btStop: TSpeedButton;
    Panel3: TPanel;
    Label2: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    lbReqOutput: TLabel;
    lbReqDose: TLabel;
    Panel4: TPanel;
    Label9: TLabel;
    Label12: TLabel;
    Label1: TLabel;
    Label3: TLabel;
    pnlSumWes: TPanel;
    pnlWNum: TPanel;
    pnlLastWes: TPanel;
    pnlCurWes: TPanel;
    pnlReqOutput: TPanel;
    pnlReqDose: TPanel;
    pnlOutput: TPanel;
    pnlWCycle: TPanel;
    pnlWesSvrState: TPanel;
    pnlErrCode: TPanel;
    pnlStageNum: TPanel;
    lbErr: TLabel;

    procedure FormActivate(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure pnlReqClick(Sender: TObject);
    procedure btStartClick(Sender: TObject);
  private
    idxSumWesHigh: integer;
    idxSumWesLow: integer;
    idxWNum: integer;
    idxLastWes: integer;
    idxCurWes: integer;
    idxReqOutput: integer;
    idxReqDose: integer;
    idxWCycle: integer;
    idxWesSvrState: integer;
    idxErrCode: integer;
    idxStageNum: integer;
    idxSYSTEM_ErrorFlag: integer;
    idxSYSTEM_ErrorCount: integer;
  public
    M: TVisDynamicPict;
  end;

var
  CtrlPanelWesAkkontForm: TCtrlPanelWesAkkontForm;

implementation
uses numbers, TagStorage;

{$R *.DFM}

procedure TCtrlPanelWesAkkontForm.FormActivate(Sender: TObject);
var
  i: integer;
  stag: string;
begin
  if M=nil then exit;

  stag := M.TagPath + '.';
  pnlName.Caption := M.DeviceName;

  idxSumWesHigh := GetTagIndex(stag + 'SumWesHigh');
  idxSumWesLow := GetTagIndex(stag + 'SumWesLow');
  idxWNum := GetTagIndex(stag + 'WNum');
  idxLastWes := GetTagIndex(stag + 'LastWes');
  idxCurWes := GetTagIndex(stag + 'CurWes');
  idxReqOutput := GetTagIndex(stag + 'ReqOutput');
  idxReqDose := GetTagIndex(stag + 'ReqDose');
  idxWCycle := GetTagIndex(stag + 'WCycle');
  idxWesSvrState := GetTagIndex(stag + 'WesSvrState');
  idxErrCode := GetTagIndex(stag + 'ErrCode');
  idxStageNum := GetTagIndex(stag + 'StageNum');
  idxSYSTEM_ErrorFlag := GetTagIndex(stag + 'SYSTEM.ErrorFlag');
  idxSYSTEM_ErrorCount := GetTagIndex(stag + 'SYSTEM.ErrorCount');

  Timer.Enabled := true;
  TimerTimer(nil);
end;

procedure TCtrlPanelWesAkkontForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Timer.Enabled := false;
end;


procedure TCtrlPanelWesAkkontForm.TimerTimer(Sender: TObject);

  procedure set_caption(pnl: TPanel; del,pnt: integer; value: int64);
  var
    s: string;
  begin
    if value<0 then begin
      pnl.Caption := '';
      exit;
    end;
    
    if (pnt>0) and (del>0) then s := format('%.'+inttostr(pnt)+'g', [value/del]) else
    if (del>0) then s := inttostr(round(value/del)) else s := inttostr(value);

    if not SameText(pnl.Caption, s) then pnl.Caption := s;
  end;

var
  ii: int64;
  i,j: integer;
  s: string;
begin
  i := GetTagValue( idxSYSTEM_ErrorFlag );
  if i<0 then s:='  c OPC' else
  if i=1 then s:='   !' else begin
    i := GetTagValue( idxStageNum );
    if (i and $80)>0 then s:=' ' else s:=' ';
    if (i and $7F)>0 then s:=s+' ()';
  end;
  if not SameText(pnlSost.Caption, s) then pnlSost.Caption:=s;


  i := GetTagValue(idxSumWesHigh);
  j := GetTagValue(idxSumWesLow);
  ii := int64(i)*$10000+j;
  set_caption( pnlSumWes,    1000,0,  ii );
  set_caption( pnlWNum,      1,0   ,  GetTagValue(idxWNum) );
  set_caption( pnlLastWes,   1000,3,  GetTagValue(idxLastWes) );
  set_caption( pnlCurWes,    1000,3,  GetTagValue(idxCurWes) );
  set_caption( pnlReqOutput, 1000,3,  GetTagValue(idxReqOutput) );
  set_caption( pnlReqDose,   1000,3,  GetTagValue(idxReqDose) );
  set_caption( pnlWCycle,    1,0   ,  GetTagValue(idxWCycle) );
  set_caption( pnlErrCode,   1,0   ,  GetTagValue(idxStageNum) and $7F );
  set_caption( pnlStageNum,  1,0   ,  GetTagValue(idxErrCode) );

  i:=GetTagValue(idxLastWes);
  j:=GetTagValue(idxWCycle);
  if (i>=0) and (j>0) then
    set_caption( pnlOutput, 1000,3,  round(i*3600/j) )
  else
    pnlOutput.Caption := '';


  if (GetTagValue(idxWesSvrState)>0) and (not(sametext(pnlWesSvrState.Caption, ''))) then
    pnlWesSvrState.Caption := '';
  if (GetTagValue(idxWesSvrState)=0) and (not(sametext(pnlWesSvrState.Caption, '!'))) then
    pnlWesSvrState.Caption := '!';
  if (GetTagValue(idxWesSvrState)<0) and (not(sametext(pnlWesSvrState.Caption, ''))) then
    pnlWesSvrState.Caption := '';


  i := GetTagValue( idxStageNum ) and $7F;
  case i of
    1: s:='  ';
    2: s:='   ';
    3: s:='   ';
    4: s:='   ';
    5: s:='   ';
  else
    s:=''
  end;
  if not SameText(lbErr.Caption, s) then lbErr.Caption:=s; 

end;




procedure TCtrlPanelWesAkkontForm.pnlReqClick(Sender: TObject);
var
  s: string;
  idx,v,i: integer;
  lb: TLabel;
begin
  if Sender = pnlReqOutput then begin
    idx := idxReqOutput;
    lb := lbReqOutput;
  end else
  if Sender = pnlReqDose then begin
    idx := idxReqDose;
    lb := lbReqDose;
  end else
    exit;

  s := inttostr(gettagvalue(idx));
  if InputQuery(lb.Caption, ', ', s) then begin
    val(s,v,i);
    SetTagValue(idx, v);
  end;

end;

procedure TCtrlPanelWesAkkontForm.btStartClick(Sender: TObject);
var
  s: string;
  i: integer;
begin
  if M=nil then exit;
  if Sender = btStart then i := GetTagIndex( M.TagPath + '.' + 'CmdStart' ) else
  if Sender = btStop then i := GetTagIndex( M.TagPath + '.' + 'CmdStop' ) else exit;

  if i>=0 then SetTagValue(i,1);
end;

end.
